/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.ext;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.dbtools.migration.parser.ext.ExtToken;
import oracle.dbtools.migration.translation.api.components.Block;
import org.antlr.stringtemplate.StringTemplate;

public class ExtAST
extends CommonAST {
    protected boolean m_tagged;
    protected Hashtable keyvalues = new Hashtable();
    protected String m_prefixCommentIndexes;
    protected String m_suffixCommentIndexes;
    protected Block m_block;
    protected int m_index;
    protected int m_line;
    protected int m_column;
    protected int m_charPosition;
    protected String m_templateID = null;
    protected ArrayList<StringTemplate> stList = null;

    public ExtAST() {
        this.m_line = -1;
        this.m_column = -1;
        this.sourceStartLine = -1;
        this.sourceStartCol = -1;
        this.sourceEndLine = -1;
        this.sourceEndCol = -1;
        this.stList = new ArrayList();
    }

    public ExtAST(Token token) {
        super(token);
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public int getLine() {
        return this.m_line;
    }

    public void setLine(int n) {
        this.m_line = n;
    }

    public int getColumn() {
        return this.m_column;
    }

    public void setColumn(int n) {
        this.m_column = n;
    }

    public int getCharPosition() {
        return this.m_charPosition;
    }

    public void setCharPosition(int n) {
        this.m_charPosition = n;
    }

    public Block getBlock() {
        return this.m_block;
    }

    public void setBlock(Block block) {
        this.m_block = block;
    }

    public Block getStatementBlock() {
        return this.getStmtBlock(this.m_block);
    }

    private Block getStmtBlock(Block block) {
        if (block != null) {
            if (block.getBlockType().equals("STMTBLOCK") || block.getBlockType().equals("BEGINBLOCK")) {
                return block;
            }
            return this.getStmtBlock(block.getParent());
        }
        return null;
    }

    public void setTagged(boolean bl) {
        this.m_tagged = bl;
    }

    public boolean isTagged() {
        return this.m_tagged;
    }

    public void initialize(int n, String string) {
        super.initialize(n, string);
    }

    public void initialize(AST aST) {
        super.initialize(aST);
        this.m_index = ((ExtAST)aST).getIndex();
        this.setSourceStartLine(aST.getSourceStartLine());
        this.setSourceStartCol(aST.getSourceStartCol());
        this.setSourceEndLine(aST.getSourceEndLine());
        this.setSourceEndCol(aST.getSourceEndCol());
        this.setNoTemplate(aST.isNoTemplate());
        this.setStatement(aST.isStatement());
        this.setLine(aST.getLine());
        this.setColumn(aST.getColumn());
        this.setCharPosition(((ExtAST)aST).getCharPosition());
        this.setKeyValues(((ExtAST)aST).getKeyValues());
        if (aST instanceof ExtAST) {
            this.setBlock(((ExtAST)aST).getBlock());
        }
    }

    public void initialize(Token token) {
        super.initialize(token);
        this.m_index = ((ExtToken)token).getIndex();
        this.setLine(token.getLine());
        this.setColumn(token.getColumn());
        this.setCharPosition(((ExtToken)token).getCharPosition());
        this.sourceStartLine = -1;
        this.sourceStartCol = -1;
        this.sourceEndLine = -1;
        this.sourceEndCol = -1;
    }

    public void addPrefixCommentIndex(int n) {
        this.m_prefixCommentIndexes = this.m_prefixCommentIndexes == null ? "-" + n : this.m_prefixCommentIndexes + ",-" + n;
    }

    public void addBlockPrefixCommentIndex(int n) {
        this.m_prefixCommentIndexes = this.m_prefixCommentIndexes == null ? "--" + n : this.m_prefixCommentIndexes + ",--" + n;
    }

    public String getPrefixCommentIndexes() {
        return this.m_prefixCommentIndexes;
    }

    public void addSuffixCommentIndex(int n) {
        this.m_suffixCommentIndexes = this.m_suffixCommentIndexes == null ? "+" + n : this.m_suffixCommentIndexes + ",+" + n;
    }

    public void addBlockSuffixCommentIndex(int n) {
        this.m_suffixCommentIndexes = this.m_suffixCommentIndexes == null ? "++" + n : this.m_suffixCommentIndexes + ",++" + n;
    }

    public String getSuffixCommentIndexes() {
        return this.m_suffixCommentIndexes;
    }

    public String getText() {
        return super.getText();
    }

    public String getUpperCaseText() {
        return super.getText().toUpperCase();
    }

    public String toString() {
        String string = null;
        if (this.m_tagged) {
            string = this.m_prefixCommentIndexes != null || this.m_suffixCommentIndexes != null ? this.createCommentTag() : "/*AST[" + ((Object)((Object)this)).hashCode() + "]{" + super.getText() + "}*/";
        }
        return string != null ? string : super.getText();
    }

    private String createCommentTag() {
        String string = "/*COMMENT[%indexes%]{%text%}*/";
        String string2 = "";
        if (this.m_prefixCommentIndexes != null) {
            string2 = string2 + this.m_prefixCommentIndexes;
        }
        if (this.m_suffixCommentIndexes != null) {
            string2 = string2 + (this.m_prefixCommentIndexes != null ? "," : "") + this.m_suffixCommentIndexes;
        }
        string = string.replaceFirst("%indexes%", string2);
        string = string.replaceFirst("%text%", super.getText());
        return string;
    }

    public AST getSourceAST(AST aST, int n, int n2) {
        if (aST.getSt().getStartIndex() > n || aST.getSt().getEndIndex() < n2) {
            return null;
        }
        if (aST.getNumberOfChildren() > 0) {
            AST aST2 = aST.getFirstChild();
            AST aST3 = this.getSourceAST(aST2, n, n2);
            if (aST3 != null) {
                return aST3;
            }
            while (aST2.getNextSibling() != null) {
                aST3 = this.getSourceAST(aST2 = aST2.getNextSibling(), n, n2);
                if (aST3 == null) continue;
                return aST3;
            }
            return aST;
        }
        return aST;
    }

    public ExtAST getOutputAST(int n, int n2, int n3, int n4) {
        ExtAST extAST = null;
        ExtAST[] extASTArray = new ExtAST[1];
        this.getOutputAST(this, n, n2, n3, n4, extASTArray);
        extAST = extASTArray[0];
        if (extAST == null) {
            extAST = this;
        }
        return extAST;
    }

    void getOutputAST(ExtAST extAST, int n, int n2, int n3, int n4, ExtAST[] extASTArray) {
        ExtAST extAST2;
        if (extAST.containsRange(n, n2, n3, n4) && ((extAST2 = extASTArray[0]) == null || extAST2.contains((AST)extAST))) {
            extASTArray[0] = extAST;
        }
        if (extAST.getNumberOfChildren() > 0) {
            extAST2 = (ExtAST)extAST.getFirstChild();
            this.getOutputAST(extAST2, n, n2, n3, n4, extASTArray);
            while (extAST2.getNextSibling() != null) {
                extAST2 = (ExtAST)extAST2.getNextSibling();
                this.getOutputAST(extAST2, n, n2, n3, n4, extASTArray);
            }
        }
    }

    public boolean contains(AST aST) {
        int n = aST.getSourceStartLine();
        int n2 = aST.getSourceStartCol();
        int n3 = aST.getSourceEndLine();
        int n4 = aST.getSourceEndCol();
        return this.containsRange(n, n2, n3, n4);
    }

    public boolean containsRange(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return false;
        }
        if (this.getSourceEndCol() == 0 && this.getSourceEndLine() == 0 && this.getSourceStartCol() == 0 && this.getSourceStartLine() == 0) {
            return false;
        }
        return n >= this.getSourceStartLine() && (n != this.getSourceStartLine() || n2 >= this.getSourceStartCol()) && n3 <= this.getSourceEndLine() && (n3 != this.getSourceEndLine() || n4 <= this.getSourceEndCol());
    }

    public void addExtraInfo(Object object, Object object2) {
        this.keyvalues.put(object, object2);
    }

    public Object getExtraInfo(Object object) {
        if (object == null) {
            return null;
        }
        return this.keyvalues.get(object);
    }

    public Hashtable getKeyValues() {
        return this.keyvalues;
    }

    public void setKeyValues(Hashtable hashtable) {
        this.keyvalues = hashtable;
    }

    public void setStatement(boolean bl) {
        super.setStatement(bl);
    }

    public StringTemplate[] getAllStringTemplates() {
        return this.stList.toArray(new StringTemplate[this.stList.size()]);
    }

    public void setSt(StringTemplate stringTemplate) {
        if (this.st == null) {
            this.st = stringTemplate;
        }
        this.stList.add(stringTemplate);
    }

    public AST getLastChild() {
        AST aST = this.getFirstChild();
        if (aST == null) {
            return aST;
        }
        for (int i = 1; i < this.getNumberOfChildren(); ++i) {
            if (aST == null) continue;
            aST = aST.getNextSibling();
        }
        return aST;
    }

    public static AST findParentAST(AST aST, AST aST2) {
        AST aST3 = null;
        if (aST == null) {
            return null;
        }
        AST aST4 = aST.getFirstChild();
        if (aST4 == null) {
            return null;
        }
        do {
            if (!aST4.getText().equalsIgnoreCase(aST2.getText())) continue;
            aST3 = aST;
            break;
        } while ((aST3 = ExtAST.findParentAST(aST4, aST2)) == null && (aST4 = aST4.getNextSibling()) != null);
        return aST3;
    }
}

