/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.ext;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.stringtemplate.AutoIndentWriter;

public class ExtAutoIndentWriter
extends AutoIndentWriter {
    public static final String COMMENT_TAG_PATTERN = "/\\*COMMENT\\[((\\+|\\-){1,2}([0-9])+(,)?)+\\]\\{([^}])*\\}\\*/";
    public static final String TEMPLATE_COMMENT_TAG_PATTERN = "/\\*TEMPLATE_COMMENT\\{([0-9])+\\}\\[((\\+|\\-){1,2}([0-9])+(,)?)+\\]\\*/";
    public static final String AST_TAG_PATTERN = "/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{([^}])*\\}\\*/";
    private Pattern[] tagPatterns = new Pattern[3];

    public ExtAutoIndentWriter(Writer writer) {
        super(writer);
        this.tagPatterns[0] = Pattern.compile(COMMENT_TAG_PATTERN);
        this.tagPatterns[1] = Pattern.compile(TEMPLATE_COMMENT_TAG_PATTERN);
        this.tagPatterns[2] = Pattern.compile(AST_TAG_PATTERN);
    }

    public int write(String string) throws IOException {
        int n = 0;
        n = super.write(string);
        n = this.adjustCharPosition(string, n);
        return n;
    }

    public int writeWrapSeparator(String string) throws IOException {
        int n = 0;
        n = super.writeWrapSeparator(string);
        n = this.adjustCharPosition(string, n);
        return n;
    }

    private int adjustCharPosition(String string, int n) {
        int n2 = n;
        for (Pattern pattern : this.tagPatterns) {
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group();
                int n3 = string2.indexOf("{");
                int n4 = string2.indexOf("}");
                int n5 = string2.length();
                if (n3 > 0 && n4 > 0) {
                    n5 -= string2.substring(n3 + 1, n4).length();
                }
                this.charPositionOffset -= n5;
                this.charPosition -= n5;
                n2 -= n5;
            }
        }
        return n2;
    }
}

