/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.filter.comments;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.filter.comments.Comment;
import oracle.dbtools.migration.translation.api.components.Block;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.language.StringRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentHelper {
    private static final String NEWLINE = "\n";
    private static final String STATEMENT_TERMINATOR = ";";
    private static final String ITEM_SEPARATOR = ",";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String COMMENT_BEGIN_MARKER = "/*";
    private static final String COMMENT_END_MARKER = "*/";
    private static final String PRECEEDING_AST = "-";
    private static final String FOLLOWING_AST = "+";
    private static final String PRECEEDING_BLOCK = "--";
    private static final String FOLLOWING_BLOCK = "++";
    private static final String PROGRAM_BLOCK_START_TAG_PATTERN = "/\\*PROGRAM-BLOCK-START\\*/";
    private static final String PROGRAM_BLOCK_END_TAG_PATTERN = "/\\*PROGRAM-BLOCK-END\\*/";
    private static final String PROGRAM_BLOCK_START_TAG = "/*PROGRAM-BLOCK-START*/";
    private static final String PROGRAM_BLOCK_END_TAG = "/*PROGRAM-BLOCK-END*/";
    private ArrayList<Comment> m_commentList;
    private HashMap<AST, Object> m_astTemplateMap;
    private String m_translatedText;
    private Block m_topBlock;
    private ArrayList<StringTemplate> m_blockTemplateList;
    private HashMap<Comment, AST> m_commentASTMap;
    private HashMap<AST, Object> m_ASTLineMap;
    private ArrayList<String> m_outputTextLines;
    private HashMap<Integer, StringTemplate> m_templateMap;
    private HashMap<StringTemplate, ArrayList<String>> m_templateCommentIdxMap;
    private ArrayList<String> processedCommentList;
    private StringTemplate currentTemplate;
    private HashMap<StringTemplate, ArrayList<AST>> m_templateASTMap;
    private String m_outputStr = null;
    private HashMap<String, StringTemplate> m_tanslatedTemplateMap = new HashMap();
    private HashMap<StringTemplate, Integer> m_templateLocMap = new HashMap();

    public CommentHelper() {
        this.m_commentList = new ArrayList();
        this.m_astTemplateMap = new HashMap();
        this.m_outputTextLines = new ArrayList();
        this.m_ASTLineMap = new HashMap();
        this.m_templateMap = new HashMap();
        this.m_templateCommentIdxMap = new HashMap();
        this.processedCommentList = new ArrayList();
        this.m_templateASTMap = new HashMap();
    }

    public void addComment(Comment comment) {
        if (comment.getType() == Comment.Type.MULTI_LINE_NESTED || comment.getType() == Comment.Type.MULTI_LINE_SEPARATE_LINE) {
            this.unnestMultilineComment(comment);
        }
        if (this.m_commentList.size() > 0) {
            Comment comment2 = this.m_commentList.get(this.m_commentList.size() - 1);
            this.m_commentList.add(comment);
        } else {
            this.m_commentList.add(comment);
        }
    }

    private void unnestMultilineComment(Comment comment) {
        String string = comment.getText();
        int n = 0;
        do {
            n = string.lastIndexOf(COMMENT_END_MARKER);
            if ((n = string.lastIndexOf(COMMENT_END_MARKER, n - 1)) == -1) break;
            string = string.substring(0, n) + string.substring(n + 2);
        } while (n != -1);
        comment.setText(string);
    }

    public void removeComment(Comment comment) {
        this.m_commentList.remove(comment);
    }

    public void setStringTemplate(StringTemplate stringTemplate) {
        this.buildASTTemplateMap(stringTemplate);
    }

    private void buildASTTemplateMap(StringTemplate stringTemplate) {
        Stack<StringTemplate> stack = new Stack<StringTemplate>();
        stack.push(stringTemplate);
        this.m_templateMap.put(stringTemplate.getTemplateID(), stringTemplate);
        while (!stack.isEmpty()) {
            StringTemplate stringTemplate2 = (StringTemplate)stack.pop();
            Map map = stringTemplate2.getAttributes();
            if (map == null) continue;
            for (Object object : map.values()) {
                if (object instanceof StringTemplate) {
                    stack.push((StringTemplate)object);
                    this.m_templateMap.put(((StringTemplate)object).getTemplateID(), (StringTemplate)object);
                    continue;
                }
                if (object instanceof AST) {
                    if (object instanceof ExtAST) {
                        ((ExtAST)((Object)object)).setTagged(true);
                    }
                    this.updateASTTemplateMapping(stringTemplate2, (AST)object);
                    continue;
                }
                if (!(object instanceof StringTemplate.STAttributeList)) continue;
                StringTemplate.STAttributeList sTAttributeList = (StringTemplate.STAttributeList)object;
                for (int i = 0; i < sTAttributeList.size(); ++i) {
                    object = sTAttributeList.get(i);
                    if (object instanceof StringTemplate) {
                        stack.push((StringTemplate)object);
                        this.m_templateMap.put(((StringTemplate)object).getTemplateID(), (StringTemplate)object);
                        continue;
                    }
                    if (!(object instanceof AST)) continue;
                    if (object instanceof ExtAST) {
                        ((ExtAST)((Object)object)).setTagged(true);
                    }
                    this.updateASTTemplateMapping(stringTemplate2, (AST)object);
                }
            }
        }
    }

    private void updateASTTemplateMapping(StringTemplate stringTemplate, AST aST) {
        if (this.m_astTemplateMap.containsKey(aST)) {
            ArrayList<StringTemplate> arrayList = null;
            Object object = this.m_astTemplateMap.get(aST);
            if (object instanceof StringTemplate) {
                if (!stringTemplate.equals(object)) {
                    arrayList = new ArrayList<StringTemplate>();
                    arrayList.add((StringTemplate)object);
                    arrayList.add(stringTemplate);
                    this.m_astTemplateMap.put(aST, arrayList);
                }
            } else if (object instanceof ArrayList && !(arrayList = (ArrayList<StringTemplate>)object).contains(stringTemplate)) {
                arrayList.add(stringTemplate);
                this.m_astTemplateMap.put(aST, arrayList);
            }
        } else {
            this.m_astTemplateMap.put(aST, stringTemplate);
        }
    }

    public void setTopBlock(Block block) {
        this.m_topBlock = block;
    }

    public void matchCommentToAST(StringTemplate stringTemplate) {
        Object object = null;
        Object var8_3 = null;
        if (this.m_commentList.isEmpty() || this.m_astTemplateMap.isEmpty()) {
            return;
        }
        this.m_commentASTMap = new HashMap();
        ArrayList<AST> arrayList = new ArrayList<AST>();
        for (AST object2 : this.m_astTemplateMap.keySet()) {
            arrayList.add(object2);
        }
        Collections.sort(arrayList, new ASTComparator());
        for (Comment comment : this.m_commentList) {
            Object object2;
            Object object3;
            int n = comment.getLine();
            int n2 = comment.getColumn();
            Object object4 = null;
            Iterator iterator = arrayList.iterator();
            this.m_outputStr = null;
            while (iterator.hasNext()) {
                object3 = (AST)iterator.next();
                if (object3.getLine() == -1 && object3.getColumn() == -1) {
                    iterator.remove();
                    continue;
                }
                object2 = this.m_astTemplateMap.get(object3);
                StringTemplate stringTemplate2 = null;
                if (object2 instanceof StringTemplate) {
                    stringTemplate2 = (StringTemplate)object2;
                } else if (object2 instanceof ArrayList) {
                    stringTemplate2 = (StringTemplate)((ArrayList)object2).get(0);
                }
                if (!this.isASTUsedInTemplate((AST)object3, stringTemplate2)) {
                    if (arrayList.size() == 1) {
                        object = object4;
                    }
                    iterator.remove();
                    continue;
                }
                if (object3.getLine() >= n) break;
                if (arrayList.size() == 1) {
                    object = object3;
                }
                object4 = object3;
                iterator.remove();
            }
            if (object != null) {
                object3 = null;
                object2 = ((ExtAST)((Object)object)).getStatementBlock();
                if (object2 != null) {
                    object3 = ((Block)object2).getOutermostProgramBlock();
                }
                if (object2 != null && (object3 == null || object3 != null && !((Block)object3).getBlockName().equalsIgnoreCase("VIEW"))) {
                    this.attachCommentToStmtTemplate(((Block)object2).getAST(), comment, false);
                    continue;
                }
                this.attachCommentToAST((AST)object, comment, false);
                continue;
            }
            AST aST = (AST)arrayList.get(0);
            if (n == aST.getLine()) {
                AST aST2;
                while (arrayList.size() > 1 && (aST2 = (AST)arrayList.get(1)).getLine() == n && aST2.getColumn() < n2 && Math.abs(aST2.getColumn() - n2) < Math.abs(aST.getColumn() - n2)) {
                    aST2 = null;
                    arrayList.remove(0);
                    aST = (AST)arrayList.get(0);
                }
                if (n2 > aST.getColumn()) {
                    if (comment.getType() == Comment.Type.SINGLE_LINE_NESTED) {
                        this.attachCommentToAST(aST, comment, false);
                        continue;
                    }
                    if (arrayList.size() > 1) {
                        aST2 = (AST)arrayList.get(1);
                        int n3 = comment.getIndex();
                        if (Math.abs(n3 - ((ExtAST)aST).getIndex()) < Math.abs(n3 - ((ExtAST)aST2).getIndex())) {
                            this.attachCommentToAST(aST, comment, false);
                            continue;
                        }
                        this.attachCommentToAST(aST2, comment, true);
                        continue;
                    }
                    this.attachCommentToAST(aST, comment, false);
                    continue;
                }
            }
            this.attachCommentToAST(aST, comment, true);
        }
    }

    private boolean isASTUsedInTemplate(AST aST, StringTemplate stringTemplate) {
        if (stringTemplate == null) {
            return false;
        }
        String string = aST.toString();
        if (stringTemplate.toString().indexOf(string) != -1) {
            return true;
        }
        return stringTemplate.toString().indexOf(aST.getText()) != -1;
    }

    private void attachCommentToAST(AST aST, Comment comment, boolean bl) {
        if (bl) {
            ((ExtAST)aST).addPrefixCommentIndex(comment.getIndex());
        } else {
            ((ExtAST)aST).addSuffixCommentIndex(comment.getIndex());
        }
        this.updateCommentIndexesForTemplate(aST, comment.getIndex(), bl);
        this.m_commentASTMap.put(comment, aST);
    }

    private void attachCommentToStmtTemplate(AST aST, Comment comment, boolean bl) {
        StringTemplate stringTemplate = this.getSQLStatement(aST.getSt());
        if (stringTemplate == null) {
            return;
        }
        stringTemplate.setAttribute("postComment", (Object)comment.getText());
    }

    private StringTemplate getSQLStatement(StringTemplate stringTemplate) {
        if (stringTemplate == null) {
            return stringTemplate;
        }
        if (stringTemplate.getName().equals("sqlStatement")) {
            return stringTemplate;
        }
        return this.getSQLStatement(stringTemplate.getEnclosingInstance());
    }

    private void updateCommentIndexesForTemplate(AST aST, int n, boolean bl) {
        StringTemplate stringTemplate = null;
        Object object = this.m_astTemplateMap.get(aST);
        if (object instanceof StringTemplate) {
            stringTemplate = (StringTemplate)object;
        } else if (object instanceof ArrayList) {
            stringTemplate = (StringTemplate)((ArrayList)object).get(0);
        }
        if (stringTemplate != null) {
            String string = stringTemplate.getCommentIndexes();
            string = string != null ? string + ITEM_SEPARATOR + (bl ? PRECEEDING_AST : FOLLOWING_AST) + n : (bl ? PRECEEDING_AST : FOLLOWING_AST) + n;
            stringTemplate.setCommentIndexes(string);
        }
    }

    private boolean findMatchedBlock(AST aST, Comment comment) {
        boolean bl;
        boolean bl2 = false;
        Block block = null;
        Block block2 = this.findEnclosingBlock(this.m_topBlock, aST);
        if (block2 == null) {
            return false;
        }
        boolean bl3 = bl = comment.getLine() > aST.getLine();
        if (bl) {
            boolean bl4 = false;
            while (block2 != null) {
                boolean bl5 = bl ? block2.getSourceEndLine() > comment.getLine() : (bl4 = block2.getSourceStartLine() < comment.getLine());
                if (bl4) break;
                block = block2;
                block2 = block2.getParent();
            }
            if (block != null) {
                bl2 = true;
            }
        }
        if (bl2) {
            ExtAST extAST = (ExtAST)block.getAST();
            boolean bl6 = false;
            for (AST aST2 : this.m_astTemplateMap.keySet()) {
                if (!aST2.equals((AST)extAST)) continue;
                if (bl) {
                    extAST.addBlockSuffixCommentIndex(comment.getIndex());
                } else {
                    extAST.addBlockPrefixCommentIndex(comment.getIndex());
                }
                bl6 = true;
            }
            if (!bl6) {
                StringTemplate stringTemplate = block.getAST().getSt();
                stringTemplate.getChunks().add(new Integer(0), new StringRef(stringTemplate, extAST.toString()));
            }
        }
        return bl2;
    }

    private Block findEnclosingBlock(Block block, AST aST) {
        Block block2 = null;
        for (Block block3 : block.getChildren()) {
            Block block4;
            if (block3.getSourceStartLine() <= aST.getSourceStartLine() && block3.getSourceEndLine() >= aST.getSourceEndLine()) {
                block2 = block3;
            }
            if ((block4 = this.findEnclosingBlock(block3, aST)) != null) {
                block2 = block4;
            }
            if (block2 == null) continue;
            break;
        }
        return block2;
    }

    public void setTranslatedText(String string) {
        this.m_translatedText = string;
    }

    private String removeObjectTag(String string) {
        return string.replaceAll(PROGRAM_BLOCK_START_TAG_PATTERN, "").replaceAll(PROGRAM_BLOCK_END_TAG_PATTERN, "");
    }

    public boolean processObjectTagForProgramBlock(String string, boolean bl) {
        String string2 = string;
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl;
        do {
            if ((n = string2.indexOf(PROGRAM_BLOCK_START_TAG)) != -1) {
                bl2 = true;
                string2 = string2.substring(n + PROGRAM_BLOCK_START_TAG.length() - 1);
            }
            if ((n2 = string2.indexOf(PROGRAM_BLOCK_END_TAG)) == -1) continue;
            bl2 = false;
            string2 = string2.substring(n2 + PROGRAM_BLOCK_END_TAG.length() - 1);
        } while (n != -1 || n2 != -1);
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    public String getTranslatedTextWithComment() {
        void var14_18;
        void var14_16;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = -1;
        boolean bl = false;
        int n2 = -1;
        Pattern pattern = Pattern.compile("/\\*COMMENT\\[((\\+|\\-){1,2}([0-9])+(,)?)+\\]\\{([^}])*\\}\\*/");
        if (this.m_blockTemplateList == null) {
            this.buildBlockTemplateList(this.m_topBlock);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_translatedText, NEWLINE);
        ArrayList<String> arrayList3 = this.splitIntoLines(this.m_translatedText);
        for (String object : arrayList3) {
            arrayList2.add(object);
            ++n;
            if (object.trim().length() <= 0 || n2 != -1) continue;
            n2 = n;
        }
        if (this.m_translatedText == null || this.m_commentList.isEmpty() || this.m_astTemplateMap.isEmpty()) {
            Object object = "";
            for (String string : this.processASTCommentTag(this.getCommentTag(arrayList2, "/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{([^}])*\\}\\*/", "/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{"), arrayList2, true)) {
                object = (String)object + string + NEWLINE;
            }
            object = this.removeObjectTag((String)object);
            return object;
        }
        for (int i = arrayList2.size() - 1; i >= 0 && (((String)arrayList2.get(i)).trim().length() <= 0 || ((String)arrayList2.get(i)).trim().equalsIgnoreCase(PROGRAM_BLOCK_END_TAG)); --i) {
            --n;
        }
        String string = null;
        boolean string3 = false;
        while (var14_16 < arrayList2.size()) {
            string = (String)arrayList2.get((int)var14_16);
            bl = this.processObjectTagForProgramBlock(string, bl);
            string = this.removeObjectTag(string);
            string = this.processTemplateCommentTag(string, arrayList, (int)var14_16, hashMap);
            arrayList3.clear();
            List<CommentTag> list = this.getCommentTag(arrayList2, string, (int)var14_16, "/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{([^}])*\\}\\*/", "/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{");
            if (!list.isEmpty()) {
                arrayList3.add(string);
                for (void var15_22 = var14_16 + true; var15_22 <= list.get(list.size() - 1).getEndLine(); ++var15_22) {
                    arrayList3.add(this.processTemplateCommentTag((String)arrayList2.get((int)var15_22), arrayList, (int)var15_22, hashMap));
                }
            } else {
                arrayList3.add(string);
            }
            List<String> list2 = this.processASTCommentTag(list, arrayList3, false);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.find()) {
                    this.m_outputTextLines.add(string2);
                    ++var14_16;
                    continue;
                }
                int n3 = this.addOutputLines(this.processTranslatedLine(string2, matcher, arrayList, var14_16 == n, (int)var14_16, var14_16 == n2, bl));
                hashMap.put((int)var14_16, n3);
                ++var14_16;
            }
            --var14_16;
            ++var14_16;
        }
        if (!hashMap.isEmpty()) {
            this.updateBlockStringTemplate(hashMap, true);
        }
        this.processOrphanedComment(hashMap, arrayList);
        String string4 = "";
        for (String string5 : this.m_outputTextLines) {
            String string6 = (String)var14_18 + string5 + NEWLINE;
        }
        return var14_18;
    }

    private List<CommentTag> getCommentTag(List<String> list, String string, String string2) {
        boolean bl = false;
        ArrayList<CommentTag> arrayList = new ArrayList<CommentTag>();
        for (int i = 0; i < list.size(); ++i) {
            List<CommentTag> list2 = this.getCommentTag(list, list.get(i), i, string, string2);
            for (CommentTag commentTag : list2) {
                arrayList.add(commentTag);
            }
        }
        return arrayList;
    }

    private List<CommentTag> getCommentTag(List<String> list, String string, int n, String string2, String string3) {
        Matcher matcher;
        List<CommentTag> list2 = null;
        Matcher matcher2 = null;
        list2 = this.getCommentTagInLine(string, n, string2);
        String string4 = string;
        if (!list2.isEmpty()) {
            String string5 = list2.get(list2.size() - 1).getText();
            string4 = string4.substring(string4.indexOf(string5) + string5.length());
        }
        int n2 = n;
        while ((matcher = Pattern.compile(string3).matcher(string4)).find()) {
            while (++n2 < list.size()) {
                string4 = string4 + NEWLINE + list.get(n2);
                matcher2 = Pattern.compile(string2).matcher(string4);
                if (!matcher2.find()) continue;
            }
            list2.add(new CommentTag(n, n2, matcher2.group()));
            string4 = matcher2.end() + 1 < string4.length() ? string4.substring(matcher2.end() + 1) : "";
            for (CommentTag commentTag : this.getCommentTag(list, string4, n2, string2, string3)) {
                list2.add(commentTag);
            }
            if (matcher.find()) continue;
        }
        return list2;
    }

    private List<CommentTag> getCommentTagInLine(String string, int n, String string2) {
        ArrayList<CommentTag> arrayList = new ArrayList<CommentTag>();
        Matcher matcher = Pattern.compile(string2).matcher(string);
        if (!matcher.find()) {
            return arrayList;
        }
        do {
            CommentTag commentTag = new CommentTag(n, n, matcher.group());
            arrayList.add(commentTag);
        } while (matcher.find());
        return arrayList;
    }

    private String trimTrailing(String string) {
        int n = 0;
        int n2 = 0;
        for (char c : string.toCharArray()) {
            ++n2;
            if (Character.isWhitespace(c)) continue;
            n = n2;
        }
        if (n == 0) {
            return "";
        }
        return string.substring(0, n);
    }

    private ArrayList<String> splitIntoLines(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (string2 = string; string2 != null && !string2.trim().equals("") && string2.indexOf(10) != -1; string2 = string2.substring(string2.indexOf(10) + 1)) {
            arrayList.add(this.trimTrailing(string2.substring(0, string2.indexOf(10))));
        }
        arrayList.add(this.trimTrailing(string2));
        return arrayList;
    }

    private void orderCommentListByIndex(ArrayList<String> arrayList) {
        try {
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                for (int j = i + 1; j < arrayList.size(); ++j) {
                    int n;
                    int n2 = this.getComment(arrayList.get(i)).getIndex();
                    if (n2 <= (n = this.getComment(arrayList.get(j)).getIndex())) continue;
                    String string = arrayList.get(i);
                    arrayList.set(i, arrayList.get(j));
                    arrayList.set(j, string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processOrphanedComment(HashMap<Integer, Integer> hashMap, ArrayList<String> arrayList) {
        AST aST;
        int n;
        int n2;
        AST aST2 = null;
        HashMap<AST, String> hashMap2 = new HashMap<AST, String>();
        String string = "";
        Collection<AST> collection = null;
        boolean bl = false;
        StringTemplate object = null;
        hashMap.clear();
        this.orderCommentListByIndex(arrayList);
        for (String string2 : arrayList) {
            Comment comment = this.getComment(string2);
            String string3 = comment.getText();
            collection = null;
            bl = false;
            object = null;
            for (StringTemplate stringTemplate : this.m_templateCommentIdxMap.keySet()) {
                for (String string4 : this.m_templateCommentIdxMap.get(stringTemplate)) {
                    if (!this.getComment(string4).equals(comment)) continue;
                    collection = this.m_templateASTMap.get(stringTemplate);
                    object = stringTemplate;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (collection == null && object != null) {
                n2 = this.m_templateLocMap.get(object);
                string3 = this.addIndentLike(this.m_outputTextLines.get(n2), string3);
                n = this.addOutputLines(string3, n2, true);
                this.updateTemplateLocMap(n2, n);
                this.updateASTLineMap(n2, n);
                hashMap.put(n2, n);
                continue;
            }
            int n3 = Integer.MAX_VALUE;
            aST2 = null;
            aST = null;
            for (AST aST3 : collection == null ? this.m_ASTLineMap.keySet() : collection) {
                int n4;
                if (comment.getLine() < aST3.getLine() && (n4 = Math.abs(comment.getLine() - aST3.getLine())) < n3) {
                    n3 = n4;
                    aST2 = aST3;
                }
                aST = aST3;
            }
            if (aST2 == null && aST != null) {
                aST2 = aST;
            }
            string = "";
            if (hashMap2.containsKey(aST2)) {
                string = (String)hashMap2.get(aST2);
            }
            string = string + string3;
            hashMap2.put(aST2, string);
        }
        for (String string2 : hashMap2.keySet()) {
            aST = this.m_ASTLineMap.get(string2);
            n2 = aST instanceof ArrayList ? ((Integer)((ArrayList)aST).get(0)).intValue() : ((Integer)aST).intValue();
            n = this.addOutputLines((String)hashMap2.get(string2), n2, true);
            this.updateTemplateLocMap(n2, n);
            this.updateASTLineMap(n2, n);
            hashMap.put(n2, n);
        }
        this.updateBlockStringTemplate(hashMap, true);
    }

    private String addIndentLike(String string, String string2) {
        String string3 = "";
        String string4 = this.getIndentation(string);
        ArrayList<String> arrayList = this.splitIntoLines(string2);
        int n = 0;
        for (String string5 : arrayList) {
            if (++n == 1) {
                string3 = string3 + string4 + string5;
                continue;
            }
            string3 = string3 + NEWLINE + string4 + string5;
        }
        return string3;
    }

    private void updateTemplateLocMap(int n, int n2) {
        for (StringTemplate stringTemplate : this.m_templateLocMap.keySet()) {
            int n3 = this.m_templateLocMap.get(stringTemplate);
            if (n3 >= n) {
                n3 += n2;
            }
            this.m_templateLocMap.put(stringTemplate, n3);
        }
    }

    private void updateASTLineMap(int n, int n2) {
        HashMap hashMap = new HashMap();
        for (AST aST : this.m_ASTLineMap.keySet()) {
            ArrayList<Integer> arrayList = this.m_ASTLineMap.get(aST);
            if (arrayList instanceof ArrayList) {
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                Iterator iterator = ((ArrayList)arrayList).iterator();
                while (iterator.hasNext()) {
                    int n3 = (Integer)iterator.next();
                    if (n3 >= n) {
                        n3 += n2;
                    }
                    arrayList2.add(n3);
                }
                arrayList = arrayList2;
            } else {
                int n4 = (Integer)((Object)arrayList);
                if (n4 >= n) {
                    n4 += n2;
                }
                arrayList = new Integer(n4);
            }
            hashMap.put(aST, arrayList);
        }
        this.m_ASTLineMap = hashMap;
    }

    private String processTemplateCommentTag(String string, ArrayList<String> arrayList, int n, HashMap<Integer, Integer> hashMap) {
        Pattern pattern = Pattern.compile("/\\*TEMPLATE_COMMENT\\{([0-9])+\\}\\[((\\+|\\-){1,2}([0-9])+(,)?)+\\]\\*/");
        String string2 = new String(string);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String[] stringArray;
            String string3 = matcher.group();
            ArrayList<Object> arrayList2 = new ArrayList();
            int n2 = Integer.parseInt(string3.substring(string3.indexOf("{") + 1, string3.indexOf("}")));
            int n3 = n;
            String[] stringArray2 = hashMap.values().iterator();
            while (stringArray2.hasNext()) {
                int n4 = stringArray2.next();
                n3 += n4;
            }
            this.m_templateLocMap.put(this.m_templateMap.get(n2), n3);
            if (this.m_templateCommentIdxMap.containsKey(this.m_templateMap.get(n2))) {
                arrayList2 = this.m_templateCommentIdxMap.get(this.m_templateMap.get(n2));
            }
            for (String string4 : stringArray = CommentHelper.getCommentIndexes(string3.substring(string3.indexOf("[") + 1, string3.indexOf("]")))) {
                arrayList.add(string4);
                arrayList2.add(string4);
            }
            this.m_tanslatedTemplateMap.put(n3 + ":" + matcher.end(), this.m_templateMap.get(n2));
            this.m_templateCommentIdxMap.put(this.m_templateMap.get(n2), arrayList2);
            string2 = string2.replace(string3, "");
        }
        return string2;
    }

    private List<String> processASTCommentTag(List<CommentTag> list, List<String> list2, boolean bl) {
        String string = "";
        ArrayList<Object> arrayList = new ArrayList();
        if (list.isEmpty()) {
            return list2;
        }
        int n = list.get(0).getStartLine();
        for (String object : list2) {
            string = string + object + NEWLINE;
        }
        string = this.trimTrailing(string);
        for (CommentTag commentTag : list) {
            String string2 = commentTag.getText();
            if (!bl) {
                int n2 = Integer.parseInt(string2.substring(string2.indexOf("[") + 1, string2.indexOf("]")));
                for (AST aST : this.m_astTemplateMap.keySet()) {
                    if (aST.hashCode() != n2) continue;
                    if (this.m_ASTLineMap.containsKey(aST)) {
                        Object object = this.m_ASTLineMap.get(aST);
                        ArrayList<Integer> arrayList2 = object instanceof Integer ? new ArrayList<Integer>() : (ArrayList)object;
                        arrayList2.add(this.m_outputTextLines.size());
                        this.m_ASTLineMap.put(aST, arrayList2);
                    } else {
                        this.m_ASTLineMap.put(aST, this.m_outputTextLines.size());
                    }
                    this.currentTemplate = this.getCurrentTemplate(this.m_outputTextLines.size(), list2.get(commentTag.getStartLine() - n).indexOf(string2));
                    if (!this.m_templateASTMap.containsKey(this.currentTemplate)) break;
                    arrayList = this.m_templateASTMap.get(this.currentTemplate);
                    arrayList.add(aST);
                    this.m_templateASTMap.put(this.currentTemplate, arrayList);
                    break;
                }
            }
            string = string.replace(string2, string2.substring(string2.indexOf("{") + 1, string2.indexOf("}")));
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (Iterator<Object> iterator : string.split(NEWLINE)) {
            arrayList3.add((String)((Object)iterator));
        }
        return arrayList3;
    }

    private StringTemplate getCurrentTemplate(int n, int n2) {
        StringTemplate stringTemplate = null;
        int n3 = -1;
        int n4 = -1;
        for (String string : this.m_tanslatedTemplateMap.keySet()) {
            if (n3 > n || n3 == n && n4 > n2) break;
            n3 = Integer.parseInt(string.substring(0, string.indexOf(":")));
            n4 = Integer.parseInt(string.substring(string.indexOf(":") + 1));
            stringTemplate = this.m_tanslatedTemplateMap.get(string);
        }
        return stringTemplate;
    }

    private String processTranslatedLine(String string, Matcher matcher, ArrayList<String> arrayList, boolean bl, int n, boolean bl2, boolean bl3) {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = this.m_outputTextLines.size();
        List<Tag> list = this.extractTags(matcher);
        for (int i = 0; i < list.size(); ++i) {
            n2 = this.processCommentTag(stringBuffer, string, list.get(i), i == list.size() - 1, n2, n3, arrayList, bl, n, bl2, bl3);
            if (stringBuffer.length() <= 0) continue;
            n3 += CommentHelper.getLineCount(stringBuffer.toString());
            if (stringBuffer.toString().trim().endsWith(NEWLINE)) continue;
            --n3;
        }
        if (!list.isEmpty()) {
            Tag tag = list.get(list.size() - 1);
            int n4 = tag.getStartIndex();
            int n5 = tag.getEndIndex();
            if (n2 < n4) {
                stringBuffer.append(string.substring(n2, n4));
                n2 = n4;
            }
            if (n2 < n5) {
                stringBuffer.append(tag.getActualText());
                n2 = n5;
            }
            if (n2 < string.length()) {
                stringBuffer.append(string.substring(n2));
                n2 = string.length();
            }
        }
        return stringBuffer.toString();
    }

    private List<Tag> extractTags(Matcher matcher) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        do {
            arrayList.add(new Tag(matcher.group(), matcher.start(), matcher.end()));
        } while (matcher.find());
        return arrayList;
    }

    private int processCommentTag(StringBuffer stringBuffer, String string, Tag tag, boolean bl, int n, int n2, ArrayList<String> arrayList, boolean bl2, int n3, boolean bl3, boolean bl4) {
        String[] stringArray;
        boolean bl5 = true;
        boolean bl6 = false;
        int n4 = tag.getStartIndex();
        int n5 = tag.getEndIndex();
        AST aST = null;
        String string2 = null;
        for (String string3 : stringArray = CommentHelper.getCommentIndexes(tag.getCommentIndices())) {
            String string4;
            Comment comment = this.getComment(string3);
            Comment.Type type = comment.getType();
            comment.setText(comment.getText().trim());
            if (aST == null) {
                aST = this.m_commentASTMap.get(comment);
            }
            if (!arrayList.contains(string3)) continue;
            arrayList.remove(string3);
            if (string3.startsWith(FOLLOWING_AST)) {
                if (bl5) {
                    bl5 = false;
                }
                if (n < n4) {
                    stringBuffer.append(string.substring(n, n4));
                    n = n4;
                }
                if (n < n5) {
                    stringBuffer.append(tag.getActualText());
                    n = n5;
                }
                if (bl && !bl2 && n < string.length()) {
                    n = this.processLineTerminator(stringBuffer, n, string);
                }
            }
            if (type.equals((Object)Comment.Type.MULTI_LINE_SEPARATE_LINE) || type.equals((Object)Comment.Type.SINGLE_LINE_SEPARATE_LINE)) {
                int n6 = stringBuffer.lastIndexOf(NEWLINE) + 1;
                if (n6 == -1) {
                    n6 = 0;
                }
                if (bl3 && string3.startsWith(PRECEEDING_AST) && bl4) {
                    if (string2 == null) {
                        string2 = "";
                    }
                    string2 = string2 + comment.getText() + NEWLINE;
                    continue;
                }
                if (!bl3 && string3.startsWith(PRECEEDING_AST)) {
                    stringBuffer.insert(n6, this.getIndentation(string) + comment.getText() + NEWLINE);
                    continue;
                }
                stringBuffer.append(NEWLINE + this.getIndentation(string) + comment.getText() + NEWLINE);
                continue;
            }
            if (!type.equals((Object)Comment.Type.MULTI_LINE_NESTED) && !type.equals((Object)Comment.Type.SINGLE_LINE_NESTED)) continue;
            if (!bl6) {
                if (!string3.startsWith(PRECEEDING_AST) && type.equals((Object)Comment.Type.SINGLE_LINE_NESTED)) {
                    if (bl) {
                        bl6 = true;
                    }
                } else if (string3.startsWith(PRECEEDING_AST) && n < n4) {
                    stringBuffer.append(string.substring(n, n4));
                    n = n4;
                }
            } else if (!string3.startsWith(PRECEEDING_AST) && n < string.length()) {
                stringBuffer.append(string.substring(n));
                n = string.length();
            }
            if ((string4 = this.trimTrailing(comment.getText())).endsWith(NEWLINE)) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            stringBuffer.append(string4);
            if (!type.equals((Object)Comment.Type.SINGLE_LINE_NESTED)) continue;
            stringBuffer.append(NEWLINE + this.getIndentation(string));
        }
        if (n < n4) {
            stringBuffer.append(string.substring(n, n4));
            n = n4;
        }
        if (n < n5) {
            stringBuffer.append(tag.getActualText());
            n = n5;
        }
        if (string2 != null) {
            stringBuffer.append(NEWLINE + string2);
        }
        if (aST != null) {
            this.m_ASTLineMap.put(aST, n2);
        }
        return n;
    }

    private StringTemplate getTemplateForAST(AST aST) {
        if (!this.m_astTemplateMap.containsKey(aST)) {
            return null;
        }
        Object var3_2 = null;
        Object object = this.m_astTemplateMap.get(aST);
        if (object instanceof ArrayList) {
            object = ((ArrayList)object).get(0);
        }
        return (StringTemplate)object;
    }

    private String getIndentation(String string) {
        String string2 = "";
        for (int i = 0; i < string.length() && (string.charAt(i) == ' ' || string.charAt(i) == '\t'); ++i) {
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    private void updateBlockStringTemplate(HashMap<Integer, Integer> hashMap, boolean bl) {
        for (StringTemplate stringTemplate : this.m_blockTemplateList) {
            int n = stringTemplate.getStartLine();
            int n2 = stringTemplate.getEndLine();
            int n3 = 0;
            int n4 = 0;
            for (int n5 : hashMap.keySet()) {
                int n6 = hashMap.get(n5) - (!bl ? 1 : 0);
                if (n5 >= n && n5 <= n2) {
                    n4 += n6;
                    continue;
                }
                if (n5 < n) {
                    n3 += n6;
                    n4 += n6;
                    continue;
                }
                if (n5 <= n2) continue;
            }
            stringTemplate.setStartLine(n + n3);
            stringTemplate.setEndLine(n2 + n4);
        }
    }

    private void buildBlockTemplateList(Block block) {
        if (this.m_blockTemplateList == null) {
            this.m_blockTemplateList = new ArrayList();
        }
        for (Block block2 : block.getChildren()) {
            AST aST = block2.getAST();
            if (aST != null && aST.getSt() != null) {
                this.m_blockTemplateList.add(aST.getSt());
            }
            this.buildBlockTemplateList(block2);
        }
    }

    private int processLineTerminator(StringBuffer stringBuffer, int n, String string) {
        boolean bl = false;
        int n2 = n;
        String string2 = "";
        String string3 = string.substring(n);
        int n3 = -1;
        int n4 = 0;
        if (string3.indexOf(">>") != -1) {
            n3 = string3.indexOf(">>");
            n4 = 2;
        } else if (string3.indexOf("THEN") != -1) {
            n3 = string3.indexOf("THEN");
            n4 = 4;
        } else if (string3.indexOf(");") != -1) {
            n3 = string3.indexOf(");");
            n4 = 2;
        } else if (string3.indexOf(")") != -1) {
            n3 = string3.indexOf(")");
            n4 = 1;
        } else if (string3.indexOf(ITEM_SEPARATOR) != -1) {
            n3 = string3.indexOf(ITEM_SEPARATOR);
            n4 = 1;
        } else if (string3.indexOf(STATEMENT_TERMINATOR) != -1) {
            n3 = string3.indexOf(STATEMENT_TERMINATOR);
            n4 = 1;
        } else if (string3.indexOf(SINGLE_QUOTE) != -1) {
            int n5 = 0;
            int n6 = -1;
            while ((n6 = stringBuffer.indexOf(SINGLE_QUOTE, n6 + 1)) != -1) {
                ++n5;
            }
            if (n5 % 2 == 1) {
                n3 = string3.indexOf(SINGLE_QUOTE);
                n4 = 1;
            }
        } else if (string3.indexOf(DOUBLE_QUOTE) != -1) {
            int n7 = 0;
            int n8 = -1;
            while ((n8 = stringBuffer.indexOf(DOUBLE_QUOTE, n8 + 1)) != -1) {
                ++n7;
            }
            if (n7 % 2 == 1) {
                n3 = string3.indexOf(DOUBLE_QUOTE);
                n4 = 1;
            }
        }
        if (n3 != -1) {
            stringBuffer.append(string3.substring(0, n3 + n4));
            n2 += n3 + n4;
        }
        return n2;
    }

    private int addOutputLines(String string) {
        return this.addOutputLines(string, this.m_outputTextLines.size());
    }

    private int addOutputLines(String string, int n) {
        return this.addOutputLines(string, n, false);
    }

    private int addOutputLines(String string, int n, boolean bl) {
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, NEWLINE);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.m_outputTextLines.add(n++, string2);
            ++n2;
        }
        return bl ? n2 : (n2 > 0 ? n2 - 1 : 0);
    }

    private Comment getComment(String string) {
        Comment comment = null;
        while (string.startsWith(PRECEEDING_AST) || string.startsWith(FOLLOWING_AST)) {
            string = string.substring(1);
        }
        for (Comment comment2 : this.m_commentList) {
            if (comment2.getIndex() != Integer.parseInt(string)) continue;
            comment = comment2;
            break;
        }
        return comment;
    }

    private static String[] getCommentIndexes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ITEM_SEPARATOR);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static int getLineCount(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, NEWLINE);
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            stringTokenizer.nextToken();
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ASTComparator
    implements Comparator<AST> {
        ASTComparator() {
        }

        @Override
        public int compare(AST aST, AST aST2) {
            int n = 0;
            n = aST.getLine() > aST2.getLine() ? 1 : (aST.getLine() == aST2.getLine() ? (aST.getColumn() == aST2.getColumn() ? 0 : (aST.getColumn() > aST2.getColumn() ? 1 : -1)) : -1);
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ASTComparator;
        }
    }

    class Tag {
        private String m_markup;
        private int m_startIdx;
        private int m_endIdx;

        public Tag(String string, int n, int n2) {
            this.m_markup = string;
            this.m_startIdx = n;
            this.m_endIdx = n2;
        }

        public String getMarkup() {
            return this.m_markup;
        }

        public int getStartIndex() {
            return this.m_startIdx;
        }

        public int getEndIndex() {
            return this.m_endIdx;
        }

        public String getActualText() {
            return this.m_markup.substring(this.m_markup.indexOf("{") + 1, this.m_markup.indexOf("}"));
        }

        public String getCommentIndices() {
            return this.m_markup.substring(this.m_markup.indexOf("[") + 1, this.m_markup.indexOf("]"));
        }
    }

    class CommentTag {
        private int startLine;
        private int endLine;
        private String text;

        CommentTag() {
            this.text = "";
        }

        CommentTag(int n, int n2, String string) {
            this.startLine = n;
            this.endLine = n2;
            this.text = string;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public String getText() {
            return this.text;
        }

        public boolean isMultiline() {
            return this.endLine - this.startLine > 1;
        }
    }
}

