/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.filter.comments;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import oracle.dbtools.migration.parser.ext.ExtToken;
import oracle.dbtools.migration.parser.filter.BasicTokenFilter;
import oracle.dbtools.migration.parser.filter.comments.Comment;
import oracle.dbtools.migration.parser.filter.comments.CommentHelper;

public class CommentTokenFilter
extends BasicTokenFilter {
    protected BitSet m_multiLineTokenTypes;
    protected BitSet m_singleLineTokenTypes;
    protected CommentHelper m_commentHelper;
    private ExtToken m_prevToken;

    public CommentTokenFilter(TokenStream tokenStream, CommentHelper commentHelper) {
        super(tokenStream);
        this.m_commentHelper = commentHelper;
        this.m_multiLineTokenTypes = new BitSet();
        this.m_singleLineTokenTypes = new BitSet();
    }

    public void setMultiLineCommentTypes(BitSet bitSet) {
        if (this.m_multiLineTokenTypes != null) {
            this.m_multiLineTokenTypes = bitSet;
        }
    }

    public void setSingLineCommentTypes(BitSet bitSet) {
        if (this.m_singleLineTokenTypes != null) {
            this.m_singleLineTokenTypes = bitSet;
        }
    }

    public Token nextToken() throws TokenStreamException {
        ExtToken extToken = null;
        Token token = null;
        try {
            token = this.m_input.nextToken();
            if (token != null && token instanceof ExtToken) {
                extToken = (ExtToken)token;
                int n = extToken.getType();
                if (this.m_singleLineTokenTypes.member(n) || this.m_multiLineTokenTypes.member(n)) {
                    this.processCommentToken(extToken);
                    extToken = (ExtToken)this.nextToken();
                } else {
                    this.m_prevToken = extToken;
                }
            }
        }
        catch (Throwable throwable) {
            throw new TokenStreamException(throwable);
        }
        return extToken;
    }

    public void processCommentToken(ExtToken extToken) {
        boolean bl = false;
        if (this.m_prevToken != null && this.m_prevToken.getLine() == extToken.getLine()) {
            bl = true;
        }
        Comment.Type type = this.m_singleLineTokenTypes.member(extToken.getType()) ? (bl ? Comment.Type.SINGLE_LINE_NESTED : Comment.Type.SINGLE_LINE_SEPARATE_LINE) : (bl ? Comment.Type.MULTI_LINE_NESTED : Comment.Type.MULTI_LINE_SEPARATE_LINE);
        this.m_commentHelper.addComment(new Comment(type, extToken.getLine(), extToken.getColumn(), extToken.getIndex(), extToken.getText()));
    }
}

