/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.ITranslationManager;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.exceptions.TranslationObjectNotFoundException;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.translation.util.ASTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManager {
    private TranslationHelper m_translationHelper = null;
    public static final String TRANSLATABLE = "TRANSLATABLE";
    public static final String EMULATIONFNC = "EMULATIONFNC";

    public DependencyManager(TranslationHelper translationHelper) {
        this.m_translationHelper = translationHelper;
    }

    public TranslationDBObjectReference getDBObjectReference(String string, String string2, String string3, String string4, String string5, TranslationObjectType translationObjectType) {
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(string, string2, string3, string4, string5, translationObjectType != null ? translationObjectType : TranslationObjectType.UNKNOWN_TYPE);
        if (translationObjectType != TranslationObjectType.UNKNOWN_TYPE && translationObjectType != TranslationObjectType.EMULATION_TYPE && this.isManagerAvailable()) {
            try {
                this.getTranslationContext().completeSourceObject(translationDBObjectReference, this.getTranslationHelper().getSourceDBObject().getOMWBObj());
            }
            catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
                // empty catch block
            }
        }
        return translationDBObjectReference;
    }

    public TranslationDBObjectReference getDBObjectReference(AST aST, AST aST2, AST aST3, AST aST4, AST aST5, TranslationObjectType translationObjectType) {
        return this.getDBObjectReference(ASTUtil.toString(aST), ASTUtil.toString(aST2), ASTUtil.toString(aST3), ASTUtil.toString(aST4), ASTUtil.toString(aST5), translationObjectType);
    }

    public void handleSourceReference(TranslationDBObjectReference translationDBObjectReference, String string) {
        if (translationDBObjectReference == null || string == null || !this.isManagerAvailable()) {
            return;
        }
        this.saveSourceDependency(translationDBObjectReference);
        if (string == TRANSLATABLE && translationDBObjectReference.getType() != TranslationObjectType.TABLE_TYPE) {
            if (!this.isManagerAvailable()) {
                return;
            }
            this.handleReferenceForTranslating(translationDBObjectReference);
        }
    }

    public void handleTargetReference(TranslationDBObjectReference translationDBObjectReference, String string) {
        if (translationDBObjectReference == null || string == null || !this.isManagerAvailable()) {
            return;
        }
        this.saveTargetDependency(translationDBObjectReference);
    }

    public ArrayList<TranslationParameter> getTargetParameters(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return null;
        }
        ArrayList<TranslationParameter> arrayList = null;
        this.translateIfRequired(translationDBObjectReference);
        try {
            TranslationDBObjectReference translationDBObjectReference2 = this.getTranslationContext().getTargetDBObjectReference(translationDBObjectReference, this.getTranslationHelper().getSourceDBObject().getOMWBObj());
            arrayList = this.isTranslating(translationDBObjectReference) ? this.getTranslationContext().getSourceParameters(translationDBObjectReference) : this.getTranslationContext().getTargetParameters(translationDBObjectReference2);
        }
        catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
            // empty catch block
        }
        return arrayList;
    }

    public void handleEmulationFunc(String string) {
        if (string != null && this.isManagerAvailable()) {
            TranslationDBObjectReference translationDBObjectReference = this.getDBObjectReference(null, null, null, string, null, TranslationObjectType.EMULATION_TYPE);
            this.handleTargetReference(translationDBObjectReference, EMULATIONFNC);
        }
    }

    private void saveSourceDependency(TranslationDBObjectReference translationDBObjectReference) {
        if (translationDBObjectReference != null && this.isManagerAvailable()) {
            this.getTranslationHelper();
            TranslationHelper.getLogging().saveSourceDependency(this.getTranslationHelper().getSourceDBObject(), translationDBObjectReference);
        }
    }

    private void saveTargetDependency(TranslationDBObjectReference translationDBObjectReference) {
        if (translationDBObjectReference != null && this.isManagerAvailable()) {
            this.getTranslationHelper();
            TranslationHelper.getLogging().saveTargetDependency(this.getTranslationHelper().getTargetDBObjectReference(), translationDBObjectReference);
        }
    }

    private boolean isTranslated(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return true;
        }
        return this.getTranslationManager().isTranslated(translationDBObjectReference.getOMWBObj());
    }

    private boolean isTranslating(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return false;
        }
        return this.getTranslationManager().isTranslating(translationDBObjectReference.getOMWBObj());
    }

    private void translate(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return;
        }
        this.getTranslationManager().translate(translationDBObjectReference.getOMWBObj());
    }

    private void translateIfRequired(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return;
        }
        if (!this.isTranslated(translationDBObjectReference) && !this.isTranslating(translationDBObjectReference) && this.getTranslationManager() != null) {
            this.translate(translationDBObjectReference);
        }
    }

    private void handleReferenceForTranslating(TranslationDBObjectReference translationDBObjectReference) {
        if (!this.isManagerAvailable()) {
            return;
        }
        try {
            this.getTranslationContext().completeSourceObject(translationDBObjectReference, this.getOMWBObj());
        }
        catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
            // empty catch block
        }
        if (this.isTranslatable(translationDBObjectReference)) {
            this.translateIfRequired(translationDBObjectReference);
        }
    }

    private Object getOMWBObj() {
        return this.getTranslationHelper().getSourceDBObject().getOMWBObj();
    }

    private boolean isTranslatable(TranslationDBObjectReference translationDBObjectReference) {
        if (translationDBObjectReference.getObjName() == null || translationDBObjectReference.getType() == null) {
            return false;
        }
        return translationDBObjectReference.getType().equals(TranslationObjectType.FUNCTION_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.PROCEDURE_OR_FUNCTION_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.PROCEDURE_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.VIEW_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.TRIGGER_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.CONSTRAINT_TYPE);
    }

    private ITranslationContext getTranslationContext() {
        return this.getTranslationHelper().getTranslationContext();
    }

    private ITranslationManager getTranslationManager() {
        return this.getTranslationHelper().getTranslationManager();
    }

    private TranslationHelper getTranslationHelper() {
        return this.m_translationHelper;
    }

    private boolean isManagerAvailable() {
        return this.getTranslationManager() != null && this.getTranslationHelper() != null && this.getTranslationContext() != null;
    }
}

