/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.migration.parser.helper.CodeBlockManager;
import oracle.dbtools.migration.parser.helper.CrossTableQueryHelper;
import oracle.dbtools.migration.parser.helper.TableHelper;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.CrossTableQueryStatement;
import oracle.dbtools.migration.translation.api.components.SQLStatement;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

public class StatementHelper {
    private HashMap<Block, SQLStatement> m_stmtMap;
    private CodeBlockManager m_codeBlockMgr;
    private TableHelper m_tableHelper;
    private ITranslationContext m_translationContext;
    private CrossTableQueryHelper m_crossTableQueryHelper;

    public StatementHelper(CodeBlockManager codeBlockManager, ITranslationContext iTranslationContext, TableHelper tableHelper) {
        this.m_codeBlockMgr = codeBlockManager;
        this.m_translationContext = iTranslationContext;
        this.m_tableHelper = tableHelper;
        this.m_stmtMap = new HashMap();
        this.m_crossTableQueryHelper = new CrossTableQueryHelper();
    }

    public void addSQLStatement(AST aST) {
        Block block = this.getDMLBlock(aST);
        if (block == null) {
            return;
        }
        this.m_stmtMap.put(block, new SQLStatement(aST, block));
    }

    public void addCrossTableQueryStatement(AST aST) {
        Block block = this.getDMLBlock(aST);
        if (block == null) {
            return;
        }
        this.m_crossTableQueryHelper.addCrossTableQueryStatement(aST, block);
    }

    public SQLStatement getSQLStatement(AST aST) {
        Block block = this.getDMLBlock(aST);
        return this.m_stmtMap.get(block);
    }

    public void addNestedSQLStatement(AST aST, AST aST2) {
        Block block = this.getDMLBlock(aST);
        Block block2 = this.getDMLBlock(aST);
        if (block == null || block2 == null) {
            return;
        }
        if (!block2.isDescendentOf(block)) {
            return;
        }
        SQLStatement sQLStatement = this.m_stmtMap.get(block);
        if (sQLStatement == null) {
            return;
        }
        SQLStatement sQLStatement2 = this.m_stmtMap.get(block2);
        if (sQLStatement2 == null) {
            return;
        }
        sQLStatement.addNestedSQLStatement(sQLStatement2);
    }

    public void setDMLTargetTable(AST aST, String string) {
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            return;
        }
        sQLStatement.setDMLTarget(string);
    }

    public String getDMLTargetTable(AST aST) {
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            return null;
        }
        return sQLStatement.getDMLTarget();
    }

    public void addTableReference(AST aST, String string, String string2) {
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            CrossTableQueryStatement crossTableQueryStatement = this.getCrossTableQueryStatement(aST);
            if (crossTableQueryStatement != null) {
                crossTableQueryStatement.addTableReference(string, string2);
            }
            return;
        }
        sQLStatement.addTableReference(string, string2);
    }

    public boolean hasMultiTableReference(AST aST) {
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            CrossTableQueryStatement crossTableQueryStatement = this.getCrossTableQueryStatement(aST);
            if (crossTableQueryStatement != null) {
                return crossTableQueryStatement.getTableNames().length > 1;
            }
            return false;
        }
        return sQLStatement.getTableNames().length > 1;
    }

    public boolean isTableReference(AST aST, String string) {
        return this.isTableReference(aST, string, false);
    }

    public boolean isTableReference(AST aST, String string, boolean bl) {
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            CrossTableQueryStatement crossTableQueryStatement = this.getCrossTableQueryStatement(aST);
            if (crossTableQueryStatement != null) {
                return crossTableQueryStatement.hasTableName(string);
            }
            return false;
        }
        return sQLStatement.hasTableName(string, bl);
    }

    public boolean isTableAlias(AST aST, String string) {
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            CrossTableQueryStatement crossTableQueryStatement = this.getCrossTableQueryStatement(aST);
            if (crossTableQueryStatement != null) {
                return crossTableQueryStatement.getTableNameForAlias(string) != null;
            }
            return false;
        }
        return sQLStatement.getTableNameForAlias(string) != null;
    }

    public boolean isColumnReference(AST aST, String string) {
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            return false;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        ArrayList<TranslationColumn> arrayList = null;
        for (String string7 : sQLStatement.getTableNames()) {
            String string8 = new String(string7);
            while ((n = string8.lastIndexOf(".", string8.length() - 1)) != -1) {
                if (n != -1 && n != string8.length() - 1) {
                    if (string6 == null) {
                        string6 = string8.substring(n + 1);
                    } else if (string5 == null) {
                        string5 = string8.substring(n + 1);
                    } else if (string3 == null) {
                        string3 = string8.substring(n + 1);
                    } else if (string4 == null) {
                        string4 = string8.substring(n + 1);
                    } else if (string2 == null) {
                        string2 = string8.substring(n + 1);
                    }
                }
                string8 = string8.substring(0, n);
            }
            if (string5 == null) {
                string5 = string8;
            } else if (string3 == null) {
                string3 = string8;
            } else if (string4 == null) {
                string4 = string8;
            } else if (string2 == null) {
                string2 = string8;
            }
            TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(string2, string4, string3, string5, string6, TranslationObjectType.TABLE_TYPE, true);
            arrayList = this.m_translationContext.getSourceColumns(translationDBObjectReference);
            if (arrayList != null) {
                for (TranslationColumn translationColumn : arrayList) {
                    if (!string.equalsIgnoreCase(translationColumn.getObjName())) continue;
                    return true;
                }
                continue;
            }
            for (TranslationDBObjectReference translationDBObjectReference2 : sQLStatement.getColumns()) {
                if (!string.equalsIgnoreCase(translationDBObjectReference2.getObjName()) && !string.substring(1, string.length() - 1).equalsIgnoreCase(translationDBObjectReference2.getObjName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isColumnAlias(AST aST, String string) {
        String string2 = null;
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            return false;
        }
        if (sQLStatement != null) {
            for (TranslationDBObjectReference translationDBObjectReference : sQLStatement.getColumns()) {
                string2 = sQLStatement.getAliasForColumn(translationDBObjectReference);
                if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String getColumnAlias(AST aST, String string) {
        String string2 = null;
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            return string2;
        }
        if (sQLStatement != null) {
            TranslationDBObjectReference translationDBObjectReference;
            TranslationDBObjectReference[] translationDBObjectReferenceArray = sQLStatement.getColumns();
            int n = translationDBObjectReferenceArray.length;
            for (int i = 0; !(i >= n || (string2 = sQLStatement.getAliasForColumn(translationDBObjectReference = translationDBObjectReferenceArray[i])) != null && string2.equalsIgnoreCase(string)); ++i) {
            }
        }
        return string2;
    }

    public void addColumn(AST aST, String string, String string2) {
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            return;
        }
        sQLStatement.addColumn(string, string2);
    }

    public void addCrossTableQueryColumn(AST aST, AST aST2) {
        if (aST2 == null) {
            return;
        }
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement != null) {
            return;
        }
        Block block = this.getStatementBlock(aST);
        if (block == null) {
            return;
        }
        this.m_crossTableQueryHelper.addColumn(block, aST2);
    }

    public TranslationDBObjectReference getColumn(AST aST, int n) {
        SQLStatement sQLStatement = this.getSQLStatement(aST);
        if (sQLStatement == null) {
            return null;
        }
        return sQLStatement.getColumn(n);
    }

    private Block getDMLBlock(AST aST) {
        if (aST == null) {
            return null;
        }
        return this.m_codeBlockMgr.findEnclosingDMLBlock(aST);
    }

    private Block getStatementBlock(AST aST) {
        if (aST == null) {
            return null;
        }
        return this.m_codeBlockMgr.findEnclosingBlock(aST, "STMTBLOCK");
    }

    public CrossTableQueryStatement getCrossTableQueryStatement(AST aST) {
        Block block = this.getStatementBlock(aST);
        if (block == null) {
            return null;
        }
        return this.m_crossTableQueryHelper.getCrossTableQueryStatement(block);
    }

    public boolean isCrossTableQueryStatement(AST aST) {
        Block block = this.getStatementBlock(aST);
        if (block == null) {
            return false;
        }
        return this.m_crossTableQueryHelper.getCrossTableQueryStatement(block) != null;
    }
}

