/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.helper.CodeBlockManager;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.Table;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.exceptions.TranslationObjectNotFoundException;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableHelper {
    private CodeBlockManager m_codeBlockMgr;
    private List<Table> m_tableList;
    private ITranslationContext m_translationContext;
    private TranslationHelper m_helper;

    public TableHelper(CodeBlockManager codeBlockManager, ITranslationContext iTranslationContext, TranslationHelper translationHelper) {
        this.m_codeBlockMgr = codeBlockManager;
        this.m_translationContext = iTranslationContext;
        this.m_helper = translationHelper;
        this.m_tableList = new ArrayList<Table>();
    }

    public void addTable(AST aST, String string) {
        Block block = this.getStatementBlock(aST);
        if (block == null) {
            return;
        }
        this.m_tableList.add(new Table(aST, block, string));
    }

    private Block getStatementBlock(AST aST) {
        Block block = null;
        block = ((ExtAST)aST).getBlock();
        if (block == null || block != null && block.getBlockType().equals("STMTBLOCK")) {
            block = this.m_codeBlockMgr.findEnclosingBlock(aST, "STMTBLOCK");
        }
        return block;
    }

    public Table getTable(AST aST) {
        Table table = null;
        Block block = this.getStatementBlock(aST);
        for (Table table2 : this.m_tableList) {
            if (!table2.getBlock().equals(block)) continue;
            table = table2;
            break;
        }
        return table;
    }

    public Table getTable(String string) {
        Table table = null;
        for (Table table2 : this.m_tableList) {
            if (!table2.getName().equalsIgnoreCase(string)) continue;
            table = table2;
            break;
        }
        return table;
    }

    public void setTableName(AST aST, String string) {
        Table table = this.getTable(aST);
        if (table == null) {
            return;
        }
        table.setName(string);
    }

    public void addColumn(AST aST, String string, TranslationDataType translationDataType) {
        Table table = this.getTable(aST);
        if (table == null) {
            return;
        }
        table.addColumn(string, translationDataType);
    }

    public TranslationColumn getColumn(String string, int n) {
        Table table = this.getTable(string);
        if (table == null) {
            return null;
        }
        TranslationColumn translationColumn = null;
        translationColumn = table.getColumn(n);
        if (translationColumn != null) {
            return translationColumn;
        }
        List<TranslationColumn> list = this.getColumnsFromContext(table);
        if (list != null) {
            int n2 = 0;
            for (TranslationColumn translationColumn2 : list) {
                if (n2++ != n) continue;
                translationColumn = translationColumn2;
                break;
            }
        }
        return translationColumn;
    }

    public TranslationColumn getColumn(String string, TranslationDBObjectReference translationDBObjectReference) {
        TranslationColumn translationColumn = null;
        Table table = this.getTable(string);
        if (table == null) {
            return null;
        }
        String string2 = translationDBObjectReference.getFullName();
        translationColumn = table.getColumn(string2);
        if (translationColumn != null) {
            return translationColumn;
        }
        List<TranslationColumn> list = this.getColumnsFromContext(table);
        if (list != null) {
            for (TranslationColumn translationColumn2 : list) {
                if (!translationColumn2.getColumnName().equalsIgnoreCase(string2)) continue;
                translationColumn = translationColumn2;
                break;
            }
        }
        return translationColumn;
    }

    private List<TranslationColumn> getColumnsFromContext(Table table) {
        Object var2_2 = null;
        ArrayList<TranslationColumn> arrayList = null;
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(null, null, null, table.getName(), null, TranslationObjectType.TABLE_TYPE, this.m_helper.getSourceDBObject() != null ? this.m_helper.getSourceDBObject().getOMWBObj() : null);
        try {
            arrayList = this.m_translationContext.getTargetColumns(translationDBObjectReference);
        }
        catch (TranslationObjectNotFoundException translationObjectNotFoundException) {
            arrayList = null;
        }
        return arrayList;
    }

    public String getColumnDataType(String string, TranslationDBObjectReference translationDBObjectReference) {
        if (translationDBObjectReference == null || string == null) {
            return null;
        }
        TranslationColumn translationColumn = this.getColumn(string, translationDBObjectReference);
        if (translationColumn == null) {
            return null;
        }
        return translationColumn.getColumnDataType().getDataType();
    }

    public String getColumnDataType(String string, int n) {
        if (string == null) {
            return null;
        }
        TranslationColumn translationColumn = this.getColumn(string, n);
        if (translationColumn == null) {
            return null;
        }
        return translationColumn.getColumnDataType().getDataType();
    }
}

