/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.log;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class DebugMsg
extends PrintStream {
    private static final String LOGFILE = "debug.log";
    private static final String ENCODING = "UTF8";
    private static final boolean DEBUG_WINDOW = true;
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    public static DebugMsg m_log;
    private static JFrame m_frame;
    private static JTextPane m_textPane;
    private static Document m_doc;
    private static OutputStreamWriter m_writer;

    private DebugMsg(FileOutputStream fileOutputStream) {
        super(fileOutputStream, true);
        try {
            m_writer = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Invalid encoding");
            System.exit(1);
        }
        System.setErr(this);
        System.setOut(this);
        m_frame = new JFrame("Debug Output");
        m_textPane = DebugMsg.createTextPane();
        m_frame.getContentPane().add(new JScrollPane(m_textPane));
        m_frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        m_frame.pack();
        m_frame.setVisible(true);
        System.err.println("Debug Log file: " + new Date());
        System.err.println("Debug class by Matthew Ford  email:matthew.ford@forward.com.au");
        System.err.println("(c)2000 Forward Computing and Control Pty. Ltd.");
        System.err.println("   NSW, Australia,  www.forward.com.au");
        System.err.println(" You may use this class without restriction");
        System.err.println("---------------------------------------------------------------");
    }

    private static JTextPane createTextPane() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        DebugMsg.initStylesForTextPane(jTextPane);
        m_doc = jTextPane.getDocument();
        jTextPane.setPreferredSize(new Dimension(500, 500));
        return jTextPane;
    }

    public void print(boolean bl) {
        this.print(new Boolean(bl).toString());
    }

    public void print(double d) {
        this.print(new Double(d).toString());
    }

    public void print(long l) {
        this.print(new Long(l).toString());
    }

    public void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void print(char c) {
        char[] cArray = new char[]{c};
        this.print(new String(cArray));
    }

    public void print(char[] cArray) {
        this.print(new String(cArray));
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void print(String string) {
        try {
            m_writer.write(string, 0, string.length());
        }
        catch (IOException iOException) {
            string = string + iOException.getMessage();
        }
        try {
            m_doc.insertString(m_doc.getLength(), string, m_textPane.getStyle("regular"));
        }
        catch (BadLocationException badLocationException) {
            System.exit(2);
        }
    }

    public void println() {
        String string = "\n";
        try {
            m_writer.write(NEWLINE, 0, NEWLINE.length());
            m_writer.flush();
        }
        catch (IOException iOException) {
            string = string + iOException.getMessage();
        }
        try {
            m_doc.insertString(m_doc.getLength(), "\n", m_textPane.getStyle("regular"));
        }
        catch (BadLocationException badLocationException) {
            System.exit(2);
        }
    }

    private static void initStylesForTextPane(JTextPane jTextPane) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = jTextPane.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
    }

    static {
        try {
            System.out.println("Redirecting all output to file debug.log in UTF8 format");
            m_log = new DebugMsg(new FileOutputStream(LOGFILE));
        }
        catch (IOException iOException) {
            System.err.println("Could not open Debug file debug.log");
            System.exit(1);
        }
    }
}

