/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.plugin;

import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import antlr.debug.misc.ASTFrame;
import java.io.CharArrayReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.parser.analysis.TranslationAnalysisResult;
import oracle.dbtools.migration.parser.defaults.DefaultVariabletNameTranslator;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.ext.ExtAutoIndentWriter;
import oracle.dbtools.migration.parser.ext.ExtTreeParser;
import oracle.dbtools.migration.parser.ext.RosettaLexer;
import oracle.dbtools.migration.parser.ext.RosettaRecognizer;
import oracle.dbtools.migration.parser.filter.FaultTolleranceFilter;
import oracle.dbtools.migration.parser.filter.KeywordCaseConversionFilter;
import oracle.dbtools.migration.parser.filter.comments.CommentHelper;
import oracle.dbtools.migration.parser.filter.comments.CommentTokenFilter;
import oracle.dbtools.migration.parser.filter.highlighting.HighLightingBlock;
import oracle.dbtools.migration.parser.filter.highlighting.HighlightingBlockFilter;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.parser.internalapi.IFoldingBlock;
import oracle.dbtools.migration.parser.internalapi.ISyntaxHighlightingBlock;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.internalapi.ITranslationAnalysisResult;
import oracle.dbtools.migration.parser.internalapi.ITranslationDiffBlock;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.parser.log.TranslationMessages;
import oracle.dbtools.migration.parser.plugin.IVariableNameTranslator;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.ITranslationLogging;
import oracle.dbtools.migration.translation.api.ITranslationManager;
import oracle.dbtools.migration.translation.api.TranslationResult;
import oracle.dbtools.migration.translation.api.TranslationSession;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.dbtools.migration.translation.util.TranslationUtil;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractParserMain
implements ITranslationAll {
    protected static final String TARGET_GENERATION = "TargetGeneration";
    protected static final String EXTENDED_TOKEN_CLASS_NAME = "oracle.dbtools.migration.parser.ext.ExtToken";
    protected static final String EXTENDED_AST_CLASS_NAME = "oracle.dbtools.migration.parser.ext.ExtAST";
    protected static final String STRINGTEMPLATE_DIR = "templates";
    protected static final String DEFAULT_TEMPLATE_GROUP_FILE = "generic";
    protected static final String LEXER = "lexer";
    protected boolean m_astTreeVisibility;
    protected int m_keywordTokenType;
    protected CommentHelper m_commentHelper;
    protected String m_templateGroupName;
    protected StringTemplateGroup m_templateGroup;
    protected CommonAST m_outputAST;
    protected RosettaRecognizer m_recognizer;
    protected HashMap<TreeWalkerType, TreeParser> m_treeWalkerMap;
    protected TreeParser m_outputGenerator;
    protected HighlightingBlockFilter m_highlightingFilter;
    private ArrayList<HighLightingBlock> m_hlb = null;
    private HashMap<String, AST> m_astHashMap = new HashMap();
    private TranslationHelper m_helper = null;
    private TranslationPreferences m_prefs = null;

    protected AbstractParserMain() {
        this.cleanUp();
    }

    protected void cleanUp() {
        this.m_keywordTokenType = 0;
        this.m_commentHelper = new CommentHelper();
        this.m_templateGroupName = DEFAULT_TEMPLATE_GROUP_FILE;
        this.m_treeWalkerMap = new HashMap();
        this.m_outputGenerator = null;
        this.m_highlightingFilter = null;
        this.m_astHashMap = new HashMap();
        this.m_helper = null;
        this.m_templateGroup = null;
        this.m_outputAST = null;
        this.m_recognizer = null;
        this.m_hlb = null;
    }

    private String translateStr(String string, TranslationHelper translationHelper) throws TranslationException {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return string;
        }
        this.setupTranslator(string, translationHelper, TARGET_GENERATION);
        return this.translate();
    }

    public ITranslationAnalysisResult analyseStr(String string, TranslationHelper translationHelper) throws TranslationException {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return null;
        }
        this.setupTranslator(string, translationHelper, TreeWalkerType.METADATA_ANALYSIS.toString());
        return this.analyse();
    }

    @Override
    public TranslateResultWithASTs translateAndGetASTS(String string) throws TranslationException {
        TranslateResultWithASTs translateResultWithASTs = null;
        String string2 = this.translate(string);
        String string3 = TranslationUtil.getFullDdlScript(this.m_helper.getTranslationMetaData().getExtraObjects(), string2);
        translateResultWithASTs = new TranslateResultWithASTs(string3, this.m_astHashMap);
        translateResultWithASTs.setHelper(this.m_helper);
        return translateResultWithASTs;
    }

    @Override
    public TranslationResult translate(TranslationDBObject translationDBObject, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging, ITranslationManager iTranslationManager, TranslationSession translationSession) throws TranslationException {
        Object object;
        if (translationDBObject.getDdl() == null) {
            TranslationException translationException = new TranslationException(" > " + translationDBObject.getFullName() + ":No DDL Text Associate With Object");
            throw translationException;
        }
        TranslationMessages.debuginfo("translating:" + translationDBObject.getDatabaseName() + "." + translationDBObject.getOwnerName() + "." + translationDBObject.getObjName());
        TranslationDBObject translationDBObject2 = null;
        TranslationResult translationResult = null;
        boolean bl = false;
        if (translationDBObject.getType().equals(TranslationObjectType.CONSTRAINT_TYPE)) {
            if (this.isRule(translationDBObject)) {
                object = iTranslationContext.getInfoKeyValue("CONSTRAINT_COLUMN");
                if (object != null) {
                    this.processRuleDDL(translationDBObject, (String)object);
                } else {
                    this.processRuleDDL(translationDBObject, "columnName");
                }
            }
            if (translationDBObject.getDdl().toUpperCase().indexOf("GETDATE") != -1) {
                bl = true;
                translationDBObject2 = this.getDummyTriggerFromConstraint(translationDBObject);
            } else {
                translationDBObject2 = this.getDummyProcFromConstraint(translationDBObject);
            }
        } else {
            translationDBObject2 = translationDBObject;
        }
        object = new TranslationHelper(translationDBObject2, iTranslationContext, iTranslationLogging, iTranslationManager, translationSession);
        ((TranslationHelper)object).setVariableNameTranslator(this.getVariableNameTranslator());
        String string = null;
        try {
            string = this.translateStr(translationDBObject2.getDdl(), (TranslationHelper)object);
        }
        catch (TranslationException translationException) {
            throw translationException;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            TranslationException translationException = new TranslationException(" > " + translationDBObject.getFullName() + ":" + exception.getLocalizedMessage());
            translationException.setStackTrace(exception.getStackTrace());
            throw translationException;
        }
        if (translationDBObject.getType().equals(TranslationObjectType.CONSTRAINT_TYPE) && !bl) {
            string = this.getConstraintFromDummyProc(string);
        }
        if (string == null) {
            TranslationException translationException = new TranslationException(" > " + translationDBObject.getFullName() + ":No Text Returned From Translator");
            throw translationException;
        }
        translationResult = this.createTargetObject(this.hackToRemoveTopComments(string = string.replaceFirst("(\\s)+$", "")), translationDBObject, (TranslationHelper)object);
        if (translationResult != null) {
            if (bl) {
                translationResult.getTargetObject().setType(TranslationObjectType.TRIGGER_TYPE);
                translationResult.getTargetObject().setObjName(this.getConstraintTriggerName(translationDBObject.getObjName(), translationDBObject.getPartName()));
            }
            translationResult.setExtraObjects(this.m_helper.getTranslationMetaData().getExtraObjects());
        }
        return translationResult;
    }

    private boolean isRule(TranslationDBObject translationDBObject) {
        return translationDBObject.getDdl().toLowerCase().indexOf("create rule") != -1;
    }

    private void processRuleDDL(TranslationDBObject translationDBObject, String string) {
        String string2 = translationDBObject.getDdl();
        int n = string2.indexOf(" as ") + 4;
        string2 = string2.substring(n);
        String string3 = this.getParamName(string2);
        string2 = string2.replaceAll(string3, string);
        translationDBObject.setDdl(string2);
    }

    private String getParamName(String string) {
        int n = string.indexOf(64);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f!=.()[]{}:;><'\"~#?,+_-*&^%$\u00a3\u00ac`");
        return stringTokenizer.nextToken();
    }

    private String hackToRemoveTopComments(String string) {
        if (string == null) {
            return null;
        }
        int n = string.toUpperCase().indexOf("CREATE OR REPLACE");
        int n2 = string.toUpperCase().indexOf("\nBEGIN");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (n == -1) {
            return string;
        }
        if (n != 0 && n2 != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n, n2 + 7);
            string4 = string.substring(n2 + 7);
            string = (string3 != null && !string3.trim().equalsIgnoreCase("") ? string3 + "\n" : "") + (string2 != null && !string2.trim().equalsIgnoreCase("") ? string2 + "\n" : "") + string4;
        }
        return string;
    }

    private TranslationResult createTargetObject(String string, TranslationDBObject translationDBObject, TranslationHelper translationHelper) {
        TranslationResult translationResult = null;
        TranslationDBObjectReference translationDBObjectReference = null;
        try {
            translationDBObjectReference = translationHelper.getTranslationContext().getTargetDBObjectReference(translationDBObject.getDBObjectReference(), translationDBObject.getOMWBObj());
        }
        catch (Exception exception) {
            translationDBObjectReference = translationDBObject.getDBObjectReference();
        }
        if (translationDBObjectReference != null) {
            TranslationDBObject translationDBObject2 = new TranslationDBObject(translationDBObjectReference, string);
            ArrayList<TranslationDBObject> arrayList = null;
            translationResult = new TranslationResult(translationDBObject2, arrayList, translationHelper);
        }
        return translationResult;
    }

    private TranslationDBObject getDummyProcFromConstraint(TranslationDBObject translationDBObject) {
        String string = translationDBObject.getDdl();
        String string2 = translationDBObject.getObjName();
        String string3 = "proc1";
        String string4 = "CREATE PROCEDURE " + string3 + " AS SELECT * FROM " + string2 + " WHERE " + string;
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(translationDBObject.getDBObjectReference());
        translationDBObjectReference.setType(TranslationObjectType.PROCEDURE_TYPE);
        translationDBObjectReference.setObjName(string3);
        TranslationDBObject translationDBObject2 = new TranslationDBObject(translationDBObjectReference, string4);
        return translationDBObject2;
    }

    private TranslationDBObject getDummyTriggerFromConstraint(TranslationDBObject translationDBObject) {
        String string = translationDBObject.getDdl();
        String string2 = translationDBObject.getObjName();
        String string3 = translationDBObject.getPartName();
        String string4 = this.getConstraintTriggerName(string2, string3);
        String string5 = "CREATE TRIGGER " + string4 + " ON " + string2 + " FOR INSERT, UPDATE AS \n" + " IF NOT (" + string + ")\n" + " BEGIN \n" + " RAISERROR ('" + string4 + " failed', 1, 1) \n" + " END ";
        TranslationDBObjectReference translationDBObjectReference = new TranslationDBObjectReference(translationDBObject.getDBObjectReference());
        translationDBObjectReference.setType(TranslationObjectType.TRIGGER_TYPE);
        translationDBObjectReference.setObjName(string4);
        TranslationDBObject translationDBObject2 = new TranslationDBObject(translationDBObjectReference, string5);
        return translationDBObject2;
    }

    private String getConstraintTriggerName(String string, String string2) {
        return this.generateName(string, string2) + "_SYSDTRG";
    }

    private String generateName(String string, String string2) {
        if (string2.length() > 22) {
            return string2.substring(0, 16) + AbstractParserMain.randomChars(6);
        }
        return string2;
    }

    private static String randomChars(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = (int)(Math.random() * 26.0);
            boolean bl2 = bl = (int)(Math.random() * 10000.0) % 2 == 0;
            if (bl) {
                stringBuffer.append((char)(65 + n2));
                continue;
            }
            stringBuffer.append((char)(97 + n2));
        }
        return stringBuffer.toString();
    }

    private String getConstraintFromDummyProc(String string) {
        String string2 = string;
        string2 = string2.substring(string2.indexOf("WHERE") + 6);
        string2 = string2.substring(0, string2.indexOf(";"));
        return string2;
    }

    public TranslationResult getEmulationPackage(TranslationDBObjectReference translationDBObjectReference, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging, TranslationSession translationSession) throws TranslationException {
        return null;
    }

    @Override
    public TranslationResult getEmulationPackageForConnection(Object object, TranslationDBObjectReference translationDBObjectReference, ITranslationContext iTranslationContext) throws TranslationException {
        return null;
    }

    @Override
    public TranslationResult getEmulationPackageForSchema(Object object, TranslationDBObjectReference translationDBObjectReference, ITranslationContext iTranslationContext) throws TranslationException {
        return null;
    }

    @Override
    public TranslationSession startTranslationSession() {
        return new TranslationSession();
    }

    @Override
    public final Reader translate(Reader reader) throws TranslationException {
        char[] cArray = new char[100];
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            string = this.translate(stringBuffer.toString());
        }
        catch (TranslationException translationException) {
            throw translationException;
        }
        catch (Exception exception) {
            TranslationException translationException = new TranslationException(" > Unknown Object:" + exception.getLocalizedMessage());
            translationException.setStackTrace(exception.getStackTrace());
            throw translationException;
        }
        return new CharArrayReader(string.toCharArray());
    }

    @Override
    public String translate(String string) throws TranslationException {
        TranslationHelper translationHelper = new TranslationHelper();
        translationHelper.setVariableNameTranslator(this.getVariableNameTranslator());
        translationHelper.getTranslationContext().setPreferences(this.m_prefs);
        String string2 = this.translateStr(string, translationHelper);
        return string2;
    }

    public ArrayList<IFoldingBlock> getFoldingBlocks() {
        return null;
    }

    public ArrayList<ISyntaxHighlightingBlock> getSyntaxHighLightingBlocks() {
        return null;
    }

    public ArrayList<ITranslationDiffBlock> getTranslationDiffBlocks() {
        return null;
    }

    protected void setupTranslator(String string, TranslationHelper translationHelper, String string2) {
        this.cleanUp();
        this.m_helper = translationHelper;
        this.m_astHashMap = null;
        this.m_astHashMap = new HashMap();
        string = string.replace('\u0000', ' ');
        translationHelper.setSourceText(string);
        RosettaLexer rosettaLexer = this.getLexer(new StringReader(string));
        rosettaLexer.setTokenObjectClass(EXTENDED_TOKEN_CLASS_NAME);
        rosettaLexer.setHelper(this.m_helper);
        this.m_highlightingFilter = new HighlightingBlockFilter((TokenStream)rosettaLexer);
        if (string2.equals(LEXER)) {
            return;
        }
        CommentTokenFilter commentTokenFilter = new CommentTokenFilter(this.m_highlightingFilter, this.m_commentHelper);
        commentTokenFilter.setSingLineCommentTypes(this.getSingleLineCommentTypes());
        commentTokenFilter.setMultiLineCommentTypes(this.getMultiLineCommentTypes());
        KeywordCaseConversionFilter keywordCaseConversionFilter = new KeywordCaseConversionFilter(rosettaLexer, commentTokenFilter);
        FaultTolleranceFilter faultTolleranceFilter = new FaultTolleranceFilter(rosettaLexer, keywordCaseConversionFilter, commentTokenFilter);
        this.m_recognizer = this.getRecognizer(faultTolleranceFilter);
        this.m_recognizer.setHelper(translationHelper);
        if (this.m_recognizer != null) {
            this.m_recognizer.setKeywordIdType(this.getKeywordTokenType());
            this.m_recognizer.setASTNodeClass(EXTENDED_AST_CLASS_NAME);
        }
        this.getTreeWalkers();
        Iterator<TreeParser> iterator = this.m_treeWalkerMap.values().iterator();
        ExtTreeParser extTreeParser = null;
        while (iterator.hasNext()) {
            extTreeParser = (ExtTreeParser)iterator.next();
            extTreeParser.setASTNodeClass(EXTENDED_AST_CLASS_NAME);
            this.setHelper(extTreeParser, translationHelper);
        }
        if (string2.equals(TARGET_GENERATION)) {
            this.loadStringTemplateGroup();
            this.m_outputGenerator = this.getOutputGenerator();
            if (this.m_outputGenerator != null) {
                this.m_outputGenerator.setASTNodeClass(EXTENDED_AST_CLASS_NAME);
                this.setHelper((ExtTreeParser)this.m_outputGenerator, translationHelper);
                this.setOutputStringTemplateGroup(this.m_outputGenerator, this.m_templateGroup);
            }
        }
    }

    @Override
    public ExtAST getAST(String string) throws TranslationException {
        if (string == null) {
            return null;
        }
        if (string.trim().equals("")) {
            return null;
        }
        TranslationHelper translationHelper = new TranslationHelper();
        translationHelper.setVariableNameTranslator(this.getVariableNameTranslator());
        this.setupTranslator(string, translationHelper, TreeWalkerType.SOURCE_TREE_WALKER.toString());
        CommonAST commonAST = this.recognize();
        return (ExtAST)commonAST;
    }

    @Override
    public boolean recognize(String string) throws TranslationException {
        if (string == null) {
            return false;
        }
        if (string.trim().equals("")) {
            return false;
        }
        TranslationHelper translationHelper = new TranslationHelper();
        translationHelper.setVariableNameTranslator(this.getVariableNameTranslator());
        this.setupTranslator(string, translationHelper, TreeWalkerType.SOURCE_TREE_WALKER.toString());
        CommonAST commonAST = this.recognize();
        return commonAST != null;
    }

    private ITranslationAnalysisResult analyse() throws TranslationException {
        CommonAST commonAST = null;
        ITranslationAnalysisResult iTranslationAnalysisResult = null;
        commonAST = this.generateSourceAST();
        iTranslationAnalysisResult = this.analyseAST(commonAST);
        return iTranslationAnalysisResult;
    }

    private CommonAST recognize() throws TranslationException {
        CommonAST commonAST = null;
        commonAST = this.generateSourceAST();
        return commonAST;
    }

    private String translate() throws TranslationException {
        CommonAST commonAST = null;
        CommonAST commonAST2 = null;
        CommonAST commonAST3 = null;
        ITranslationAnalysisResult iTranslationAnalysisResult = null;
        String string = null;
        commonAST = this.generateSourceAST();
        this.m_astHashMap.put("SOURCE_AST", (AST)commonAST);
        iTranslationAnalysisResult = this.analyseAST(commonAST);
        commonAST2 = this.generateTargetAST(commonAST);
        this.m_astHashMap.put("TARGET_AST", (AST)commonAST2);
        commonAST3 = this.translateTargetAST(commonAST2);
        this.m_astHashMap.put("TRANSLATED_TARGET_AST", (AST)commonAST3);
        string = this.generateTargetResult(commonAST3);
        return string;
    }

    private CommonAST generateSourceAST() throws TranslationException {
        CommonAST commonAST = null;
        String string = "Unknown Object";
        if (this.m_helper != null && this.m_helper.getSourceDBObject() != null && this.m_helper.getSourceDBObject().getFullName() != null) {
            string = this.m_helper.getSourceDBObject().getFullName();
        }
        if (this.m_recognizer == null) {
            throw new TranslationException(" > " + string + ":Recognizer not set:This should not happen, please report as bug");
        }
        try {
            this.m_recognizer.start();
            this.m_hlb = this.m_highlightingFilter.getHighLightingBlocks();
            commonAST = (CommonAST)this.m_recognizer.getAST();
            if (this.m_astTreeVisibility) {
                this.displayASTTree(((Object)((Object)this.m_recognizer)).getClass().getSimpleName(), commonAST);
            }
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.SOURCE_TREE_WALKER), commonAST);
        }
        catch (RecognitionException recognitionException) {
            TranslationException translationException = new TranslationException(" > " + string + ":" + recognitionException.getLocalizedMessage() + ": Line " + recognitionException.getLine() + " Column " + recognitionException.getColumn());
            translationException.setStackTrace(recognitionException.getStackTrace());
            throw translationException;
        }
        catch (TokenStreamException tokenStreamException) {
            TranslationException translationException = new TranslationException(" > " + string + ":" + tokenStreamException.getLocalizedMessage() + ": Token Stream Exception ");
            translationException.setStackTrace(tokenStreamException.getStackTrace());
            throw translationException;
        }
        return commonAST;
    }

    private ITranslationAnalysisResult analyseAST(CommonAST commonAST) throws TranslationException {
        Object object;
        ArrayList<IFoldingBlock> arrayList = null;
        try {
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.STRUCTURAL_ANALYSIS_PASS1), commonAST);
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.STRUCTURAL_ANALYSIS_PASS2), commonAST);
            object = ((ExtTreeParser)this.m_treeWalkerMap.get((Object)TreeWalkerType.STRUCTURAL_ANALYSIS_PASS2)).getHelper().getCodeBlockManager().getTopBlock();
            arrayList = ((Block)object).getFoldingBlocks();
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.DEPENDENCY_ANALYSIS), commonAST);
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.LIMITATION_ANALYSIS), commonAST);
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.METADATA_ANALYSIS), commonAST);
            ((ExtTreeParser)this.m_treeWalkerMap.get((Object)TreeWalkerType.METADATA_ANALYSIS)).getHelper().getTranslationMetaData().persist();
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.EXPRESSION_ANALYSIS), commonAST);
        }
        catch (RecognitionException recognitionException) {
            TranslationException translationException = new TranslationException(" > " + this.m_helper.getSourceDBObject().getFullName() + ":" + recognitionException.getLocalizedMessage() + ": Line " + recognitionException.getLine() + " Column " + recognitionException.getColumn());
            translationException.setStackTrace(recognitionException.getStackTrace());
            throw translationException;
        }
        catch (Exception exception) {
            TranslationException translationException = new TranslationException(" > " + this.m_helper.getSourceDBObject().getFullName() + ":" + exception.getLocalizedMessage());
            translationException.setStackTrace(exception.getStackTrace());
            throw translationException;
        }
        object = new TranslationAnalysisResult();
        object.setFoldingBlocks(arrayList);
        object.setSyntaxHighLightingBlocks(this.m_hlb);
        return object;
    }

    private CommonAST generateTargetAST(CommonAST commonAST) throws TranslationException {
        CommonAST commonAST2 = null;
        try {
            commonAST2 = this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.SOURCE_TO_TARGET_TRANSFORMER), commonAST);
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.TARGET_TREE_WALKER), commonAST2);
        }
        catch (RecognitionException recognitionException) {
            TranslationException translationException = new TranslationException(" > " + this.m_helper.getSourceDBObject().getFullName() + ":" + recognitionException.getLocalizedMessage() + ": Line " + recognitionException.getLine() + " Column " + recognitionException.getColumn());
            translationException.setStackTrace(recognitionException.getStackTrace());
            throw translationException;
        }
        catch (Exception exception) {
            TranslationException translationException = new TranslationException(" > " + this.m_helper.getSourceDBObject().getFullName() + ":" + exception.getLocalizedMessage());
            translationException.setStackTrace(exception.getStackTrace());
            throw translationException;
        }
        return commonAST2;
    }

    private CommonAST translateTargetAST(CommonAST commonAST) throws TranslationException {
        CommonAST commonAST2 = null;
        try {
            this.startTreeWalker(this.m_treeWalkerMap.get((Object)TreeWalkerType.TARGET_TREE_TRANSLATOR), commonAST);
            commonAST2 = commonAST;
        }
        catch (RecognitionException recognitionException) {
            TranslationException translationException = new TranslationException(" > " + this.m_helper.getSourceDBObject().getFullName() + ":" + recognitionException.getLocalizedMessage() + ": Line " + recognitionException.getLine() + " Column " + recognitionException.getColumn());
            translationException.setStackTrace(recognitionException.getStackTrace());
            throw translationException;
        }
        catch (Exception exception) {
            TranslationException translationException = new TranslationException(" > " + this.m_helper.getSourceDBObject().getFullName() + ":" + exception.getLocalizedMessage());
            translationException.setStackTrace(exception.getStackTrace());
            throw translationException;
        }
        return commonAST2;
    }

    private String generateTargetResult(CommonAST commonAST) throws TranslationException {
        String string = null;
        String string2 = "Unknown Object";
        if (this.m_helper != null && this.m_helper.getSourceDBObject() != null && this.m_helper.getSourceDBObject().getFullName() != null) {
            string2 = this.m_helper.getSourceDBObject().getFullName();
        }
        try {
            if (this.m_outputGenerator != null) {
                this.m_outputGenerator.start((AST)commonAST);
                StringTemplate stringTemplate = this.getOutputStringTemplate(this.m_outputGenerator);
                StringTemplate.setLintMode((boolean)true);
                if (stringTemplate != null) {
                    this.m_commentHelper.setStringTemplate(stringTemplate);
                    this.m_commentHelper.setTopBlock(this.m_helper.getCodeBlockManager().getTopBlock());
                    this.m_commentHelper.matchCommentToAST(stringTemplate);
                    string = stringTemplate.toString();
                    this.m_commentHelper.setTranslatedText(string);
                    string = this.m_commentHelper.getTranslatedTextWithComment();
                }
            }
        }
        catch (RecognitionException recognitionException) {
            TranslationException translationException = new TranslationException(" > " + string2 + ":" + recognitionException.getLocalizedMessage() + ": Line " + recognitionException.getLine() + " Column " + recognitionException.getColumn());
            translationException.setStackTrace(recognitionException.getStackTrace());
            throw translationException;
        }
        catch (Exception exception) {
            TranslationException translationException = new TranslationException(" > " + string2 + ":" + exception.getLocalizedMessage());
            translationException.setStackTrace(exception.getStackTrace());
            throw translationException;
        }
        catch (Throwable throwable) {
            TranslationException translationException = new TranslationException(" > " + string2 + ":" + throwable.getLocalizedMessage());
            translationException.setStackTrace(throwable.getStackTrace());
            throw translationException;
        }
        return string;
    }

    private void displayBlock(Block block) {
        Block block2 = block;
        AST aST = block2.getAST();
        if (aST != null) {
            TranslationMessages.debuginfo("Block Name: " + block2.getBlockName() + "Block Type: " + block2.getBlockType() + " - source[start:end]=" + block2.getSourceStartLine() + ":" + block2.getSourceEndLine() + "; target[start:end]=" + block2.getTargetStartLine() + ":" + block2.getTargetEndLine());
        }
        ArrayList<Block> arrayList = block2.getChildren();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.displayBlock(arrayList.get(i));
        }
    }

    private CommonAST startTreeWalker(TreeParser treeParser, CommonAST commonAST) throws RecognitionException {
        CommonAST commonAST2 = commonAST;
        if (treeParser == null) {
            return commonAST2;
        }
        treeParser.start((AST)commonAST);
        commonAST2 = (CommonAST)treeParser.getAST();
        if (this.m_astTreeVisibility) {
            this.displayASTTree(treeParser.getClass().getSimpleName(), commonAST2);
        }
        return commonAST2;
    }

    private void displayASTTree(String string, CommonAST commonAST) {
        ASTFrame aSTFrame = new ASTFrame(string, (AST)commonAST);
        aSTFrame.setVisible(true);
    }

    protected void loadStringTemplateGroup() {
        String string = null;
        try {
            StringTemplateGroup stringTemplateGroup;
            CommonGroupLoader commonGroupLoader = new CommonGroupLoader(STRINGTEMPLATE_DIR, null);
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)this.m_templateGroupName);
            this.m_templateGroup.setStringTemplateWriter(ExtAutoIndentWriter.class);
            this.m_templateGroup.setRefreshInterval(0);
            string = this.getTemplateSubgroupName();
            if (string != null && (stringTemplateGroup = StringTemplateGroup.loadGroup((String)string, (StringTemplateGroup)this.m_templateGroup)) != null) {
                stringTemplateGroup.setSuperGroup(this.m_templateGroup);
                this.m_templateGroup = stringTemplateGroup;
                this.m_templateGroup.setStringTemplateWriter(ExtAutoIndentWriter.class);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public String[] getAllTemplateNames() {
        int n = 0;
        String[] stringArray = null;
        if (this.m_templateGroup != null) {
            Set set = this.m_templateGroup.getTemplateNames();
            stringArray = new String[set.size()];
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = (String)iterator.next();
            }
        }
        return stringArray;
    }

    public StringTemplate getStringTemplate(String string) {
        return this.m_templateGroup != null ? this.m_templateGroup.getInstanceOf(string) : null;
    }

    public void setDisplayASTTree(boolean bl) {
        this.m_astTreeVisibility = bl;
    }

    protected void setHelper(ExtTreeParser extTreeParser, TranslationHelper translationHelper) {
        extTreeParser.setHelper(translationHelper);
    }

    protected IVariableNameTranslator getVariableNameTranslator() {
        return new DefaultVariabletNameTranslator();
    }

    protected Block getFoldingBlockFromTree(TreeParser treeParser) {
        return null;
    }

    public int getKeywordTokenType() {
        return -1;
    }

    protected void setOutputStringTemplateGroup(TreeParser treeParser, StringTemplateGroup stringTemplateGroup) {
    }

    protected BitSet getSingleLineCommentTypes() {
        return null;
    }

    protected BitSet getMultiLineCommentTypes() {
        return null;
    }

    protected RosettaLexer getLexer(StringReader stringReader) {
        return null;
    }

    protected RosettaRecognizer getRecognizer(TokenStream tokenStream) {
        return null;
    }

    protected void getTreeWalkers() {
    }

    protected TreeParser getOutputGenerator() {
        return null;
    }

    protected String getTemplateSubgroupName() {
        return null;
    }

    public StringTemplate getOutputStringTemplate(TreeParser treeParser) {
        return null;
    }

    @Override
    public ITranslationAnalysisResult lex(String string) throws TranslationException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        TranslationHelper translationHelper = new TranslationHelper();
        this.setupTranslator(string, translationHelper, LEXER);
        TranslationAnalysisResult translationAnalysisResult = null;
        try {
            Token token = this.m_highlightingFilter.nextToken();
            while (token != null && token.getType() != 1) {
                token = this.m_highlightingFilter.nextToken();
            }
            translationAnalysisResult = new TranslationAnalysisResult();
            translationAnalysisResult.setSyntaxHighLightingBlocks(this.m_highlightingFilter.getHighLightingBlocks());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return translationAnalysisResult;
    }

    @Override
    public ITranslationAnalysisResult analyse(String string) throws TranslationException {
        return this.analyse(string, null, null);
    }

    public ITranslationAnalysisResult analyse(TranslationDBObject translationDBObject, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging) throws TranslationException {
        return this.analyse(translationDBObject.getDdl(), translationDBObject, iTranslationContext, iTranslationLogging);
    }

    public ITranslationAnalysisResult analyse(String string, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging) throws TranslationException {
        return this.analyse(string, null, iTranslationContext, iTranslationLogging);
    }

    private ITranslationAnalysisResult analyse(String string, TranslationDBObject translationDBObject, ITranslationContext iTranslationContext, ITranslationLogging iTranslationLogging) throws TranslationException {
        TranslationHelper translationHelper = new TranslationHelper(translationDBObject, iTranslationContext, iTranslationLogging, null, null);
        translationHelper.setVariableNameTranslator(this.getVariableNameTranslator());
        return this.analyseStr(string, translationHelper);
    }

    @Override
    public void setPreferences(TranslationPreferences translationPreferences) {
        this.m_prefs = translationPreferences;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TreeWalkerType {
        SOURCE_TREE_WALKER,
        METADATA_ANALYSIS,
        EXPRESSION_ANALYSIS,
        STRUCTURAL_ANALYSIS_PASS1,
        STRUCTURAL_ANALYSIS_PASS2,
        DEPENDENCY_ANALYSIS,
        LIMITATION_ANALYSIS,
        SOURCE_TO_TARGET_TRANSFORMER,
        TARGET_TREE_WALKER,
        TARGET_TREE_TRANSLATOR;

    }
}

