/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.components;

import antlr.collections.AST;
import java.util.ArrayList;
import oracle.dbtools.migration.parser.plugin.IExpressionOperator;
import oracle.dbtools.migration.translation.api.components.Block;

public class Expression {
    private AST m_tree;
    private Block m_block;
    private ResultType m_resultType;
    private IExpressionOperator m_operator;
    private ArrayList<Expression> m_exprComponents;

    public Expression(Block block, AST aST) {
        this.m_block = block;
        this.m_tree = aST;
        this.m_resultType = ResultType.UNKNOWN;
        this.m_exprComponents = new ArrayList();
    }

    public Expression(Block block, AST aST, ResultType resultType) {
        this(block, aST);
        this.m_resultType = resultType;
    }

    public Block getBlock() {
        return this.m_block;
    }

    public AST getTree() {
        return this.m_tree;
    }

    public ResultType getResultType() {
        if (this.m_resultType.equals((Object)ResultType.UNKNOWN)) {
            this.evaluate();
        }
        return this.m_resultType;
    }

    public void setOperator(IExpressionOperator iExpressionOperator) {
        this.m_operator = iExpressionOperator;
    }

    public void addComponent(Expression expression) {
        this.m_exprComponents.add(expression);
    }

    public Expression[] getAllComponents() {
        return this.m_exprComponents.toArray(new Expression[this.m_exprComponents.size()]);
    }

    public int getComponentCount() {
        return this.m_exprComponents.size();
    }

    private void evaluate() {
        if (this.m_exprComponents.isEmpty()) {
            this.m_resultType = ResultType.UNKNOWN;
        } else if (this.m_exprComponents.size() == 1) {
            this.m_resultType = this.m_operator == null ? this.m_exprComponents.get(0).getResultType() : this.m_operator.evaluate(this.m_exprComponents.get(0));
        } else if (this.m_exprComponents.size() > 1) {
            this.m_resultType = this.m_operator != null ? this.m_operator.evaluate(this.m_exprComponents.get(0), this.m_exprComponents.get(1)) : ResultType.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultType {
        BINARY,
        BOOLEAN,
        CHARACTER,
        DATE,
        LARGE_TEXT,
        NULL,
        NUMERIC,
        TIMESTAMP,
        UNKNOWN,
        XML;

    }
}

