/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.components;

import antlr.collections.AST;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

public class Table {
    private AST m_tree;
    private Block m_stmtBlock;
    private String m_name;
    private Map<String, TranslationColumn> m_columns;

    public Table(AST aST, Block block, String string) {
        this.m_tree = aST;
        this.m_stmtBlock = block;
        this.m_name = string;
        this.m_columns = new LinkedHashMap<String, TranslationColumn>();
    }

    public Table(AST aST, Block block) {
        this(aST, block, null);
    }

    public AST getTree() {
        return this.m_tree;
    }

    public Block getBlock() {
        return this.m_stmtBlock;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void addColumn(String string, TranslationDataType translationDataType) {
        if (this.m_columns.containsKey(string)) {
            return;
        }
        TranslationColumn translationColumn = new TranslationColumn(new TranslationDBObjectReference(null, null, null, string, null, TranslationObjectType.COLUMN_TYPE, null), translationDataType);
        this.m_columns.put(string, translationColumn);
    }

    public TranslationColumn getColumn(String string) {
        return this.m_columns.get(string);
    }

    public TranslationColumn getColumn(int n) {
        int n2 = 0;
        for (TranslationColumn translationColumn : this.m_columns.values()) {
            if (n2++ != n) continue;
            return translationColumn;
        }
        return null;
    }

    public TranslationColumn[] getColumns() {
        return this.m_columns.values().toArray(new TranslationColumn[this.m_columns.size()]);
    }
}

