/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.objects;

import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

public class TranslationDBObjectReference {
    private String m_serverName = null;
    private String m_databaseName = null;
    private String m_ownerName = null;
    private String m_objName = null;
    private String m_partName = null;
    private TranslationObjectType m_type = null;
    private Object m_OMWBObj = null;
    private boolean m_keepAsOriginal = false;

    public TranslationDBObjectReference(String string, String string2, String string3, String string4, String string5, TranslationObjectType translationObjectType, Object object) {
        this(string, string2, string3, string4, string5, translationObjectType);
        this.setOMWBObj(object);
    }

    public TranslationDBObjectReference(String string, String string2, String string3, String string4, String string5, TranslationObjectType translationObjectType, Object object, boolean bl) {
        this(string, string2, string3, string4, string5, translationObjectType, true);
        this.setOMWBObj(object);
    }

    public TranslationDBObjectReference(String string, String string2, String string3, String string4, String string5, TranslationObjectType translationObjectType, boolean bl) {
        if (!bl) {
            this.m_serverName = this.removeExtra(string);
            this.m_databaseName = this.removeExtra(string2);
            this.m_ownerName = this.removeExtra(string3);
            this.m_objName = this.removeExtra(string4);
            this.m_partName = this.removeExtra(string5);
        } else {
            this.m_serverName = string;
            this.m_databaseName = string2;
            this.m_ownerName = string3;
            this.m_objName = string4;
            this.m_partName = string5;
        }
        this.m_type = translationObjectType;
        this.m_keepAsOriginal = bl;
    }

    public TranslationDBObjectReference(String string, String string2, String string3, String string4, String string5, TranslationObjectType translationObjectType) {
        this.m_serverName = this.removeExtra(string);
        this.m_databaseName = this.removeExtra(string2);
        this.m_ownerName = this.removeExtra(string3);
        this.m_objName = this.removeExtra(string4);
        this.m_partName = this.removeExtra(string5);
        this.m_type = translationObjectType;
    }

    public TranslationDBObjectReference(TranslationDBObjectReference translationDBObjectReference) {
        this(translationDBObjectReference.getServerName(), translationDBObjectReference.getDatabaseName(), translationDBObjectReference.getOwnerName(), translationDBObjectReference.getObjName(), translationDBObjectReference.getPartName(), translationDBObjectReference.getType(), translationDBObjectReference.getOMWBObj(), translationDBObjectReference.isNameKeepAsOriginal());
    }

    public String getDatabaseName() {
        return this.m_databaseName;
    }

    public void setDatabaseName(String string) {
        this.m_databaseName = this.m_keepAsOriginal ? string : this.removeExtra(string);
    }

    public String getObjName() {
        return this.m_objName;
    }

    public void setObjName(String string) {
        this.m_objName = this.m_keepAsOriginal ? string : this.removeExtra(string);
    }

    public String getOwnerName() {
        return this.m_ownerName;
    }

    public void setOwnerName(String string) {
        this.m_ownerName = this.m_keepAsOriginal ? string : this.removeExtra(string);
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public void setServerName(String string) {
        this.m_serverName = this.m_keepAsOriginal ? string : this.removeExtra(string);
    }

    public TranslationObjectType getType() {
        return this.m_type;
    }

    public void setType(TranslationObjectType translationObjectType) {
        this.m_type = translationObjectType;
    }

    public String getPartName() {
        return this.m_partName;
    }

    public void setPartName(String string) {
        this.m_partName = this.m_keepAsOriginal ? string : this.removeExtra(string);
    }

    public TranslationDBObjectReference getDBObjectReference() {
        return this;
    }

    public Object getOMWBObj() {
        return this.m_OMWBObj;
    }

    public void setOMWBObj(Object object) {
        this.m_OMWBObj = object;
    }

    public boolean isNameKeepAsOriginal() {
        return this.m_keepAsOriginal;
    }

    public String getFullName() {
        String string = (this.getServerName() != null ? (!this.getServerName().trim().equals("") ? this.getServerName() + "." : "") : "") + (this.getDatabaseName() != null ? (!this.getDatabaseName().trim().equals("") ? this.getDatabaseName() + "." : "") : "") + (this.getOwnerName() != null ? (!this.getOwnerName().trim().equals("") ? this.getOwnerName() + "." : "") : "") + this.getObjName();
        if (this.getPartName() != null) {
            string = string + '.' + this.getPartName();
        }
        return string;
    }

    private String removeExtra(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace('[', ' ');
        string = string.replace(']', ' ');
        string = string.replace('\"', ' ');
        string = string.trim();
        return string;
    }

    public String getIdentifierName() {
        if (this.getPartName() != null) {
            return this.getPartName();
        }
        return this.getObjName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModelType {
        SOURCE_REF,
        TARGET_REF,
        TARGET_PARAM,
        SOURCE_PARAM;

    }
}

