/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.objects;

import oracle.dbtools.migration.translation.util.ArgUtil;

public class TranslationDatabase {
    public static final String DBTYPE_ORACLE = "DBTYPE_ORACLE";
    public static final String DBTYPE_SQLSERVER = "DBTYPE_SQLSERVER";
    public static final String DBTYPE_MSACCESS = "DBTYPE_MSACCESS";
    public static final String DBTYPE_MYSQL = "DBTYPE_MYSQL";
    public static final String DBTYPE_INFORMIX = "DBTYPE_INFORMIX";
    public static final String DBTYPE_SYBASE = "DBTYPE_SYBASE";
    public static final String DBTYPE_DB2 = "DBTYPE_DB2";
    private String m_databaseType = null;
    private int m_databaseMainVersion = 0;
    private int m_databasePatchVersion = 0;
    private String m_databaseName = null;

    public TranslationDatabase(String string, int n, int n2, String string2) {
        if (n < 1 || n2 < 0) {
            throw new IllegalArgumentException("database version need to be 1 or more, databasePatchVersion needs to be 0 or more");
        }
        Object[] objectArray = new String[]{string};
        if (ArgUtil.isNull(objectArray) || ArgUtil.isEmpty(objectArray)) {
            throw new IllegalArgumentException("argument null or empty");
        }
        this.m_databaseType = string;
        this.m_databaseMainVersion = n;
        this.m_databasePatchVersion = n2;
        this.m_databaseName = string2;
    }

    public int getDatabaseMainVersion() {
        return this.m_databaseMainVersion;
    }

    public String getDatabaseName() {
        return this.m_databaseName;
    }

    public int getDatabasePatchVersion() {
        return this.m_databasePatchVersion;
    }

    public String getDatabaseType() {
        return this.m_databaseType;
    }
}

