/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.prefs.jdev;

import java.awt.Color;
import oracle.dbtools.migration.translation.api.prefs.ConfigurationOptions;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public final class ConfigurationData
extends HashStructureAdapter {
    public static final String KEY = "IdeSettings4GenEditor1.0";
    private static final String USEEMULATEDFUNCTIONS = "UseEmulatedFunctions";
    private static final boolean DEFAULT_USEEMULATEDFUNCTIONS = true;
    private static final String USEREGULAREXPRESSIONS = "UseRegularExpressions";
    private static final boolean DEFAULT_USEREGULAREXPRESSIONS = false;
    private static final String COMPATIBLEWITH10G = "CompatibleWith10g";
    private static final boolean DEFAULT_COMPATIBLEWITH10G = false;
    private static final String DOWNWARDCOMPATIBLE = "DownwardCompatible";
    private static final boolean DEFAULT_DOWNWARDCOMPATIBLE = false;
    private static final String PRESERVEIDENTIFIERCASE = "PreserveIdentifierCase";
    private static final boolean DEFAULT_PRESERVEIDENTIFIERCASE = true;
    private static final String DISCARDCOMMENTS = "DiscardComments";
    private static final boolean DEFAULT_DISCARDCOMMENTS = false;
    private static final String PROVIDERECOMMENDATIONS = "ProvideRecommendations";
    private static final boolean DEFAULT_PROVIDERECOMMENDATIONS = false;
    private static final String COLORLIST = "ColorList";
    private static final ListStructure DEFAULT_COLORLIST = ListStructure.newInstance();
    private static final String DEFAULT_DATEFORMAT = "dd/mm/yyyy";
    private static final String DATEFORMAT = "DATEFORMAT";

    private ConfigurationData(HashStructure hashStructure) {
        super(hashStructure);
        DEFAULT_COLORLIST.clear();
        for (int i = 0; i < ConfigurationOptions.getLevelNumber(); ++i) {
            DEFAULT_COLORLIST.add((Object)this.getString(ConfigurationOptions.colors[i]));
        }
    }

    public static ConfigurationData getInstance(PropertyStorage propertyStorage) {
        return new ConfigurationData(ConfigurationData.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public boolean isCompatibleWith10g() {
        return this._hash.getBoolean(COMPATIBLEWITH10G, false);
    }

    public void setCompatibleWith10g(boolean bl) {
        this._hash.putBoolean(COMPATIBLEWITH10G, bl);
    }

    public boolean isDownwardCompatible() {
        return this._hash.getBoolean(DOWNWARDCOMPATIBLE, false);
    }

    public void setDownwardCompatible(boolean bl) {
        this._hash.putBoolean(DOWNWARDCOMPATIBLE, bl);
    }

    public boolean isPreserveIdentifierCase() {
        return this._hash.getBoolean(PRESERVEIDENTIFIERCASE, true);
    }

    public void setPreserveIdentifierCase(boolean bl) {
        this._hash.putBoolean(PRESERVEIDENTIFIERCASE, bl);
    }

    public boolean isUseEmulatedFunctions() {
        return this._hash.getBoolean(USEEMULATEDFUNCTIONS, true);
    }

    public void setUseEmulatedFunctions(boolean bl) {
        this._hash.putBoolean(USEEMULATEDFUNCTIONS, bl);
    }

    public boolean isUseRegularExpressions() {
        return this._hash.getBoolean(USEREGULAREXPRESSIONS, false);
    }

    public void setUseRegularExpressions(boolean bl) {
        this._hash.putBoolean(USEREGULAREXPRESSIONS, bl);
    }

    public boolean isDiscardComments() {
        return this._hash.getBoolean(DISCARDCOMMENTS, false);
    }

    public void setDiscardComments(boolean bl) {
        this._hash.putBoolean(DISCARDCOMMENTS, bl);
    }

    public boolean isProvideRecommendations() {
        return this._hash.getBoolean(PROVIDERECOMMENDATIONS, false);
    }

    public void setProvideRecommendations(boolean bl) {
        this._hash.putBoolean(PROVIDERECOMMENDATIONS, bl);
    }

    public ListStructure getColorList() {
        ListStructure listStructure = this._hash.getListStructure(COLORLIST);
        if (listStructure == null) {
            listStructure = DEFAULT_COLORLIST;
        }
        return listStructure;
    }

    public void setColorList(ListStructure listStructure) {
        this._hash.putListStructure(COLORLIST, listStructure);
    }

    private String getString(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return String.format("%1$d,%2$d,%3$d", n, n2, n3);
    }

    public String getDateFormat() {
        return this._hash.getString(DATEFORMAT, DEFAULT_DATEFORMAT);
    }

    public void setDateFormat(String string) {
        this._hash.putString(DATEFORMAT, string);
    }
}

