/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import oracle.javatools.ui.Colors;

public final class Borders {
    private static final String CP_ORIGINAL_BORDER = "_uic_originalBorder";
    private static final Border NULL_BORDER_PLACEHOLDER = BorderFactory.createEmptyBorder();

    private Borders() {
    }

    public static void attachErrorBorder(JComponent component) {
        if (component == null) {
            throw new NullPointerException("component is null");
        }
        Borders.attachBorder(component, Colors.FIELD_ERROR_OUTER, Colors.FIELD_ERROR_INNER);
    }

    public static void attachWarningBorder(JComponent component) {
        Borders.attachBorder(component, Colors.FIELD_WARNING_OUTER, Colors.FIELD_WARNING_INNER);
    }

    public static void attachBorder(JComponent component, Color outer, Color inner) {
        Border originalBorder = Borders.getOriginalBorder(component);
        if (originalBorder == null) {
            Border currentBorder = component.getBorder();
            if (currentBorder == null) {
                currentBorder = NULL_BORDER_PLACEHOLDER;
            }
            Borders.setOriginalBorder(component, currentBorder);
            originalBorder = currentBorder;
        }
        Insets obi = originalBorder == null ? new Insets(0, 0, 0, 0) : originalBorder.getBorderInsets(component);
        CompoundBorder newBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(outer, 1), BorderFactory.createLineBorder(inner, 1)), BorderFactory.createEmptyBorder(Math.max(0, obi.top - 2), Math.max(0, obi.left - 2), Math.max(0, obi.bottom - 2), Math.max(0, obi.right - 2)));
        component.setBorder(newBorder);
    }

    public static void restoreBorder(JComponent component) {
        if (component == null) {
            throw new NullPointerException("component is null");
        }
        Border originalBorder = Borders.getOriginalBorder(component);
        if (originalBorder == null) {
            return;
        }
        if (originalBorder == NULL_BORDER_PLACEHOLDER) {
            component.setBorder(null);
        } else {
            component.setBorder(originalBorder);
        }
        Borders.setOriginalBorder(component, null);
    }

    private static Border getOriginalBorder(JComponent component) {
        return (Border)component.getClientProperty(CP_ORIGINAL_BORDER);
    }

    private static void setOriginalBorder(JComponent component, Border border) {
        component.putClientProperty(CP_ORIGINAL_BORDER, border);
    }
}

