/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public final class ColumnLayout
implements LayoutManager2 {
    private final int _hgap;

    public ColumnLayout() {
        this(5);
    }

    public ColumnLayout(int hgap) {
        if (hgap < 0) {
            throw new IllegalArgumentException("hgap must be >=0 ");
        }
        this._hgap = hgap;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = new Dimension();
        int i = 0;
        while (i < parent.getComponentCount()) {
            Dimension cSize = parent.getComponent(i).getPreferredSize();
            size.width += cSize.width;
            size.height = Math.max(size.height, cSize.height);
            ++i;
        }
        size.width += Math.max(0, parent.getComponentCount() - 1) * this._hgap;
        Insets insets = parent.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int x = insets.left;
        int y = insets.top;
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component c = parent.getComponent(i);
            Dimension cSize = c.getPreferredSize();
            c.setBounds(x, y, cSize.width, cSize.height);
            x += cSize.width + this._hgap;
            ++i;
        }
    }
}

