/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.javatools.ui.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentWithHint<T extends Component>
extends JPanel {
    private static final int VERTICAL_GAP = 5;
    private T _component;
    private final MultiLineLabel _hint;

    private void $init$() {
        this._hint = new MultiLineLabel();
    }

    public ComponentWithHint() {
        this.$init$();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._hint, "South");
        this._hint.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this._hint.setForeground(Colors.HINT_TEXT);
        this._hint.setTextWrapper(WordWrapper.getTextWrapper());
    }

    public ComponentWithHint(T component, String hint) {
        this();
        this.setComponent(component);
        this.setHint(hint);
    }

    public void setComponent(T component) {
        if (this._component == component) {
            return;
        }
        T oldComponent = this._component;
        if (oldComponent != null) {
            this.remove((Component)oldComponent);
        }
        if (component != null) {
            this.add((Component)component, "Center");
        }
        this._component = component;
        this.revalidate();
        this.invalidate();
        this.validate();
        this.firePropertyChange("component", oldComponent, component);
    }

    public T getComponent() {
        return this._component;
    }

    public void setHint(String hint) {
        String oldHint = this._hint.getText();
        if (!oldHint.equals(hint)) {
            this._hint.setVisible(hint != null);
            this._hint.setText(hint);
            this.invalidate();
            this.validate();
            this.firePropertyChange("hint", oldHint, hint);
        }
    }

    public String getHint() {
        return this._hint.getText();
    }
}

