/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ControlBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentWithTitlebar<T extends JComponent>
extends JPanel {
    private T _component;
    private final JPanel _title;
    private JLabel _label;
    private ControlBar _controlBar;

    private void $init$() {
        this._title = new JPanel();
    }

    public ComponentWithTitlebar() {
        this.$init$();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._title, "North");
        this._title.setLayout(new BorderLayout());
        this.configureTitleAppearance();
    }

    public ComponentWithTitlebar(T component, JLabel label, ControlBar controlBar) {
        this();
        this.setComponent(component);
        this.setLabel(label);
        this.setControlBar(controlBar);
    }

    public void setLabel(JLabel label) {
        if (this._label == label) {
            return;
        }
        this.installLabelBorder(label);
        this.swapComponent(this._title, this._label, label, "West");
        JLabel oldLabel = this._label;
        this._label = label;
        this.firePropertyChange("label", oldLabel, label);
    }

    public JLabel getLabel() {
        return this._label;
    }

    public void setControlBar(ControlBar controlBar) {
        if (this._controlBar == controlBar) {
            return;
        }
        this.swapComponent(this._title, this._controlBar, controlBar, "East");
        ControlBar oldControlbar = this._controlBar;
        this._controlBar = controlBar;
        this.firePropertyChange("controlBar", oldControlbar, controlBar);
    }

    public ControlBar getControlBar() {
        return this._controlBar;
    }

    public void setComponent(T component) {
        if (this._component == component) {
            return;
        }
        this.installComponentBorder(component);
        this.swapComponent(this, (Component)this._component, (Component)component, "Center");
        T oldComponent = this._component;
        this._component = component;
        this.firePropertyChange("component", oldComponent, component);
    }

    public T getComponent() {
        return this._component;
    }

    private void installLabelBorder(JLabel label) {
        if (!this.canInstallBorder(label)) {
            return;
        }
        label.setBorder(new BorderUIResource.EmptyBorderUIResource(3, 3, 3, 3));
    }

    private void installComponentBorder(T component) {
        if (!this.canInstallBorder((JComponent)component)) {
            return;
        }
        ((JComponent)component).setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.FLAT_EDITOR_BORDER));
    }

    private boolean canInstallBorder(JComponent c) {
        if (c == null) {
            return false;
        }
        return c.getBorder() == null || c.getBorder() instanceof UIResource;
    }

    private void swapComponent(JComponent parent, Component oldComponent, Component newComponent, String layoutPosition) {
        if (oldComponent != null) {
            parent.remove(oldComponent);
        }
        if (newComponent != null) {
            parent.add(newComponent, layoutPosition);
        }
        parent.revalidate();
        this.revalidate();
    }

    private void configureTitleAppearance() {
        this._title.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Colors.FLAT_EDITOR_BORDER));
        this._title.setBackground(Colors.TAB_PANE_BACKGROUND);
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (!this._title.isOpaque()) {
            this._title.setOpaque(true);
        }
        super.paintChildren(g);
    }
}

