/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControlBar
extends JToolBar
implements Iterable<Component> {
    private int _alignment;
    private JButton _overflowButton;
    private List<ComponentHolder> _components;
    private final transient PopupController _popupController;
    private static final Dimension ZERO_DIM = new Dimension(0, 0);

    private void $init$() {
        this._alignment = 2;
        this._overflowButton = new JButton();
        this._components = new ArrayList<ComponentHolder>();
        this._popupController = new PopupController(null);
    }

    public ControlBar() {
        this.$init$();
        this._overflowButton.setIcon(OracleIcons.getIcon((String)"blafplus/overflow_n.png"));
        this.add(this._overflowButton);
        this.setLayout(new ControlBarLayout(null));
        this.setRollover(true);
        this.setFloatable(false);
        this.setBorder(null);
        this._overflowButton.addActionListener(this._popupController);
    }

    @Override
    protected String paramString() {
        StringBuffer str = new StringBuffer(super.paramString());
        str.append(",orientation=");
        str.append(this.getOrientation() == 0 ? "HORIZONTAL" : "VERTICAL");
        str.append(",alignment=");
        str.append(this._alignment == 1 ? "TOP" : (this._alignment == 2 ? "LEFT" : (this._alignment == 3 ? "BOTTOM" : "RIGHT")));
        return str.toString();
    }

    public boolean isOverflowPopupVisible() {
        return PopupController.mav$isPopupVisible(this._popupController);
    }

    @Override
    public Iterator<Component> iterator() {
        ArrayList<Component> c = new ArrayList<Component>(this._components.size());
        for (ComponentHolder h : this._components) {
            if (h.getComponent() == this._overflowButton) continue;
            c.add(h.getComponent());
        }
        return c.iterator();
    }

    public void setAlignment(int alignment) {
        if (alignment != 1 && alignment != 2 && alignment != 3 && alignment != 4) {
            throw new IllegalArgumentException("alignment must be TOP, LEFT, BOTTOM, or RIGHT. ");
        }
        if (this.getOrientation() == 0 && (alignment == 1 || alignment == 3)) {
            throw new IllegalStateException("Can't use alignment " + alignment + " with orientation=" + this.getOrientation());
        }
        if (this.getOrientation() == 1 && (alignment == 2 || alignment == 4)) {
            throw new IllegalStateException("Can't use alignment " + alignment + " with orientation=" + this.getOrientation());
        }
        int old = this._alignment;
        if (old != alignment) {
            this._alignment = alignment;
            this.firePropertyChange("alignment", old, alignment);
        }
    }

    public int getAlignment() {
        return this._alignment;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        for (ComponentHolder c : this._components) {
            if (c.getComponent() != comp) continue;
            return;
        }
        if (index == -1) {
            this._components.add(new ComponentHolder(comp));
        } else {
            this._components.add(index, new ComponentHolder(comp));
        }
    }

    @Override
    public void setOrientation(int o) {
        super.setOrientation(o);
        if (o == 0) {
            if (this.getAlignment() == 1) {
                this.setAlignment(2);
            } else if (this.getAlignment() == 3) {
                this.setAlignment(4);
            }
        } else if (o == 1) {
            if (this.getAlignment() == 2) {
                this.setAlignment(1);
            } else if (this.getAlignment() == 4) {
                this.setAlignment(3);
            }
        }
    }

    static List ra$_components(ControlBar controlBar) {
        return controlBar._components;
    }

    static JButton ra$_overflowButton(ControlBar controlBar) {
        return controlBar._overflowButton;
    }

    static Dimension ra$ZERO_DIM() {
        return ZERO_DIM;
    }

    private final class ControlBarLayout
    implements LayoutManager2 {
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public Dimension maximumLayoutSize(Container target) {
            return null;
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = new Dimension();
            size.height = insets.top + insets.bottom + 1;
            size.width = insets.left + insets.right + 1;
            boolean isHorizontal = ControlBar.this.getOrientation() == 0;
            for (ComponentHolder holder : ControlBar.ra$_components(ControlBar.this)) {
                if (holder.getComponent() == ControlBar.ra$_overflowButton(ControlBar.this)) continue;
                Dimension cSize = holder.getComponent().getPreferredSize();
                if (isHorizontal) {
                    size.width += cSize.width;
                    size.height = Math.max(size.height, cSize.height);
                    continue;
                }
                size.width = Math.max(size.width, cSize.width);
                size.height += cSize.height;
            }
            return size;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return ControlBar.ra$ZERO_DIM();
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            boolean isHorizontal = ControlBar.this.getOrientation() == 0;
            int visibleComponentCount = ControlBar.ra$_components(ControlBar.this).size() - 1;
            int x = insets.left;
            int y = insets.top;
            int pw = parent.getWidth() - (insets.left + insets.right);
            int ph = parent.getHeight() - (insets.top + insets.bottom);
            int remainder = isHorizontal ? pw : ph;
            boolean flowed = false;
            int overflowSize = isHorizontal ? ControlBar.ra$_overflowButton((ControlBar)ControlBar.this).getPreferredSize().width : ControlBar.ra$_overflowButton((ControlBar)ControlBar.this).getPreferredSize().height;
            int i = 0;
            while (i < ControlBar.ra$_components(ControlBar.this).size()) {
                ComponentHolder holder = (ComponentHolder)ControlBar.ra$_components(ControlBar.this).get(i);
                Component c = holder.getComponent();
                if (c != ControlBar.ra$_overflowButton(ControlBar.this)) {
                    Dimension size = c.getPreferredSize();
                    int nextpos = 0;
                    if (flowed) {
                        this.makeOverflowed(parent, holder);
                    } else {
                        nextpos = (isHorizontal ? x : y) + (isHorizontal ? size.width : size.height);
                        if (nextpos > (isHorizontal ? pw : ph)) {
                            flowed = true;
                            visibleComponentCount = i;
                            this.makeOverflowed(parent, holder);
                        } else {
                            holder.setOverflowed(false);
                            c.setVisible(true);
                            c.setBounds(x, y, isHorizontal ? size.width : pw, isHorizontal ? ph : size.height);
                            remainder = (isHorizontal ? pw : ph) - nextpos;
                        }
                    }
                    if (isHorizontal) {
                        x = nextpos;
                    } else {
                        y = nextpos;
                    }
                }
                ++i;
            }
            if (flowed) {
                if (remainder < overflowSize) {
                    int i2 = ControlBar.ra$_components(ControlBar.this).size() - 1;
                    while (i2 >= 0) {
                        ComponentHolder holder = (ComponentHolder)ControlBar.ra$_components(ControlBar.this).get(i2);
                        Component c = holder.getComponent();
                        if (c != ControlBar.ra$_overflowButton(ControlBar.this) && !holder.isOverflowed()) {
                            this.makeOverflowed(parent, holder);
                            Dimension size = c.getPreferredSize();
                            int n = isHorizontal ? size.width : size.height;
                            --visibleComponentCount;
                            if ((remainder += n) >= overflowSize) break;
                        }
                        --i2;
                    }
                }
                ControlBar.ra$_overflowButton(ControlBar.this).setVisible(true);
                ControlBar.ra$_overflowButton(ControlBar.this).setBounds(isHorizontal ? parent.getWidth() - overflowSize - insets.right : insets.left, isHorizontal ? insets.top : parent.getHeight() - overflowSize - insets.bottom, isHorizontal ? overflowSize : pw, isHorizontal ? ph : overflowSize);
                remainder -= overflowSize;
            } else {
                ControlBar.ra$_overflowButton(ControlBar.this).setVisible(false);
                ControlBar.ra$_overflowButton(ControlBar.this).setBounds(0, 0, 0, 0);
            }
            if (ControlBar.this.getAlignment() == 4 || ControlBar.this.getAlignment() == 3) {
                for (ComponentHolder h : ControlBar.ra$_components(ControlBar.this)) {
                    Component c = h.getComponent();
                    if (c == ControlBar.ra$_overflowButton(ControlBar.this) || h.isOverflowed()) continue;
                    Rectangle bounds = h.getComponent().getBounds();
                    if (isHorizontal) {
                        h.getComponent().setBounds(bounds.x + remainder, bounds.y, bounds.width, bounds.height);
                        continue;
                    }
                    h.getComponent().setBounds(bounds.x, bounds.y + remainder, bounds.width, bounds.height);
                }
            }
        }

        private void makeOverflowed(Container parent, ComponentHolder holder) {
            holder.setOverflowed(true);
            if (this.hasComponent(parent, holder.getComponent())) {
                holder.getComponent().setVisible(false);
                holder.getComponent().setBounds(0, 0, 0, 0);
            }
        }

        private boolean hasComponent(Container container, Component component) {
            int i = 0;
            while (i < container.getComponentCount()) {
                if (container.getComponent(i) == component) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private ControlBarLayout() {
        }

        ControlBarLayout(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class GridFlowLayout
    implements LayoutManager2 {
        private final int _maxColumns;
        private final Dimension CELL_SIZE;

        private void $init$() {
            this.CELL_SIZE = new Dimension(24, 20);
        }

        public GridFlowLayout(int maxColumns) {
            this.$init$();
            this._maxColumns = maxColumns;
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public Dimension maximumLayoutSize(Container target) {
            return null;
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        private Dimension getComponentPreferredSize(Component c) {
            if (c instanceof AbstractButton && ((AbstractButton)c).getIcon() != null && ((AbstractButton)c).getText() == "") {
                return this.CELL_SIZE;
            }
            return c.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = new Dimension();
            int usedCols = 0;
            int col = 0;
            int row = 0;
            int i = 0;
            while (i < parent.getComponentCount()) {
                double d;
                Component c = parent.getComponent(i);
                Dimension cSize = this.getComponentPreferredSize(c);
                int span = 1;
                if (cSize.width > this.CELL_SIZE.width && (span = (int)Math.ceil(d = (double)cSize.width / (double)this.CELL_SIZE.width)) > this._maxColumns) {
                    span = this._maxColumns;
                }
                if (col + span > this._maxColumns) {
                    ++row;
                    col = 0;
                }
                usedCols = Math.max(usedCols, col += span);
                ++i;
            }
            size.width = insets.left + insets.right + usedCols * this.CELL_SIZE.width;
            size.height = insets.top + insets.bottom + (row + 1) * this.CELL_SIZE.height;
            return size;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int col = 0;
            int x = insets.left;
            int y = insets.top;
            int i = 0;
            while (i < parent.getComponentCount()) {
                double d;
                Component c = parent.getComponent(i);
                Dimension cSize = this.getComponentPreferredSize(c);
                int span = 1;
                if (cSize.width > this.CELL_SIZE.width && (span = (int)Math.ceil(d = (double)cSize.width / (double)this.CELL_SIZE.width)) > this._maxColumns) {
                    span = this._maxColumns;
                }
                if (col + span > this._maxColumns) {
                    y += this.CELL_SIZE.height;
                    col = 0;
                }
                x = insets.left + col * this.CELL_SIZE.width;
                c.setBounds(x, y, span * this.CELL_SIZE.width, this.CELL_SIZE.height);
                col += span;
                ++i;
            }
        }
    }

    private class PopupController
    implements ActionListener {
        private Popup _popup;
        private AWTEventListener _listener;

        private boolean isPopupVisible() {
            return this._popup != null;
        }

        private void hidePopup() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this._listener);
            this._popup.hide();
            this._popup = null;
            for (ComponentHolder holder : ControlBar.ra$_components(ControlBar.this)) {
                if (!holder.isOverflowed()) continue;
                boolean oldEnabled = holder.getComponent().isEnabled();
                holder.getComponent().setEnabled(oldEnabled ^ true);
                holder.getComponent().setEnabled(oldEnabled);
                ControlBar.this.add(holder.getComponent());
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this._popup != null) {
                this.hidePopup();
                return;
            }
            JToolBar toolbar = new JToolBar();
            toolbar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Colors.BLAF_TOOLBAR_POPUP_1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            toolbar.setBackground(Colors.BLAF_TOOLBAR_BACKGROUND);
            toolbar.setRollover(true);
            toolbar.setRequestFocusEnabled(ControlBar.this.isRequestFocusEnabled());
            toolbar.setFloatable(ControlBar.this.isFloatable());
            toolbar.setLayout(new GridFlowLayout(5));
            for (ComponentHolder holder : ControlBar.ra$_components(ControlBar.this)) {
                Component c = holder.getComponent();
                if (!holder.isOverflowed()) continue;
                ControlBar.this.remove(c);
                if (c instanceof JToolBar.Separator) continue;
                c.setVisible(true);
                toolbar.add(c);
            }
            this._popup = this.showPopup(toolbar, ControlBar.ra$_overflowButton((ControlBar)ControlBar.this).getLocationOnScreen().x, ControlBar.ra$_overflowButton((ControlBar)ControlBar.this).getLocationOnScreen().y + ControlBar.ra$_overflowButton(ControlBar.this).getHeight());
            this._listener = new 1(this, toolbar);
            Toolkit.getDefaultToolkit().addAWTEventListener(this._listener, 17);
        }

        private Popup showPopup(JToolBar popupPanel, int x, int y) {
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            Point p = this.adjustPopupLocationToFitScreen(x, y, popupPanel.getPreferredSize());
            x = p.x;
            y = p.y;
            Popup popup = popupFactory.getPopup(ControlBar.this, popupPanel, x, y);
            popup.show();
            return popup;
        }

        private Point adjustPopupLocationToFitScreen(int xposition, int yposition, Dimension size) {
            Rectangle screenBounds;
            Insets screenInsets;
            Point p = new Point(xposition, yposition);
            if (GraphicsEnvironment.isHeadless()) {
                return p;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            GraphicsConfiguration gc = null;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gd = ge.getScreenDevices();
            int i = 0;
            while (i < gd.length) {
                GraphicsConfiguration dgc;
                if (gd[i].getType() == 0 && (dgc = gd[i].getDefaultConfiguration()).getBounds().contains(p)) {
                    gc = dgc;
                    break;
                }
                ++i;
            }
            if (gc == null) {
                gc = ControlBar.this.getGraphicsConfiguration();
            }
            if (gc != null) {
                screenInsets = toolkit.getScreenInsets(gc);
                screenBounds = gc.getBounds();
            } else {
                screenInsets = new Insets(0, 0, 0, 0);
                screenBounds = new Rectangle(toolkit.getScreenSize());
            }
            int scrWidth = screenBounds.width - Math.abs(screenInsets.left + screenInsets.right);
            int scrHeight = screenBounds.height - Math.abs(screenInsets.top + screenInsets.bottom);
            if (p.x + size.width > screenBounds.x + scrWidth) {
                p.x = screenBounds.x + scrWidth - size.width;
            }
            if (p.y + size.height > screenBounds.y + scrHeight) {
                p.y = screenBounds.y + scrHeight - size.height;
            }
            if (p.x < screenBounds.x) {
                p.x = screenBounds.x;
            }
            if (p.y < screenBounds.y) {
                p.y = screenBounds.y;
            }
            return p;
        }

        private PopupController() {
        }

        static boolean mav$isPopupVisible(PopupController popupController) {
            return popupController.isPopupVisible();
        }

        PopupController(1 var2_2) {
            this();
        }

        static Popup ra$_popup(PopupController popupController) {
            return popupController._popup;
        }

        static void mav$hidePopup(PopupController popupController) {
            popupController.hidePopup();
        }

        final class oracle.javatools.ui.ControlBar$PopupController$1
        implements AWTEventListener {
            private final /* synthetic */ JToolBar v$toolbar;
            final /* synthetic */ PopupController this$0;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void eventDispatched(AWTEvent event) {
                Component c = (Component)event.getSource();
                int id = event.getID();
                if (PopupController.ra$_popup(this.this$0) == null) return;
                if (id == 504) return;
                if (id == 505) {
                    return;
                }
                if (event instanceof ComponentEvent) {
                    if (id == 103) return;
                }
                if (id == 102) {
                    return;
                }
                boolean childOfPopup = SwingUtilities.isDescendingFrom(c, this.v$toolbar);
                boolean hide = false;
                try {
                    if (childOfPopup) {
                        if (c.getParent() != this.v$toolbar) return;
                        if (!(c instanceof AbstractButton)) return;
                        hide = true;
                    }
                    if (hide) return;
                    if (event.getID() == 500 && event.getSource() != ControlBar.ra$_overflowButton(this.this$0.ControlBar.this)) {
                        hide = true;
                    }
                    if (event.getSource() != this.this$0.ControlBar.this && !(event.getSource() instanceof Frame)) {
                        if (!(event.getSource() instanceof Dialog)) return;
                    }
                    if (event.getID() != 100) {
                        if (event.getID() != 101) return;
                    }
                    hide = true;
                    return;
                }
                finally {
                    if (!hide) return;
                    EventQueue.invokeLater(new 1());
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                }
            }

            public oracle.javatools.ui.ControlBar$PopupController$1(PopupController popupController, JToolBar jToolBar) {
                this.v$toolbar = jToolBar;
                this.this$0 = popupController;
            }

            final class 1
            implements Runnable {
                public void run() {
                    PopupController.mav$hidePopup(1.this.this$0);
                }
            }
        }
    }

    private static class ComponentHolder {
        private final Component _component;
        private boolean _overflowed;

        private void $init$() {
            this._overflowed = false;
        }

        ComponentHolder(Component c) {
            this.$init$();
            this._component = c;
        }

        Component getComponent() {
            return this._component;
        }

        public void setOverflowed(boolean overflowed) {
            this._overflowed = overflowed;
        }

        public boolean isOverflowed() {
            return this._overflowed;
        }
    }
}

