/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import com.jgoodies.looks.Options;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.javatools.util.Log;

public final class ExpansionTip {
    private Adapter adapter;
    private ComponentTracker componentTracker;
    private Popup popup;
    private PopupPanel popupPanel;
    private static final Log LOG = new Log("expansiontip");

    public ExpansionTip(JTable table, int[] columns) {
        this(new JTableAdapter(table, columns));
    }

    public ExpansionTip(JTableHeader tableHeader, int[] columns) {
        this(new JTableHeaderAdapter(tableHeader, columns));
    }

    public ExpansionTip(JTree tree) {
        this(new JTreeAdapter(tree));
    }

    public ExpansionTip(JList list) {
        this(new JListAdapter(list));
    }

    public ExpansionTip(Adapter adapter) {
        this.adapter = adapter;
        this.popupPanel = new PopupPanel(adapter);
        this.componentTracker = new ComponentTracker(adapter);
    }

    private void showPopup(Rectangle unexpandedBounds, Dimension expandedSize) {
        JComponent component = this.adapter.getComponent();
        LOG.trace("showing {0}", (Object)unexpandedBounds);
        if (!component.isShowing()) {
            return;
        }
        Container p = component.getParent();
        while (p != null) {
            if (p instanceof JPopupMenu) break;
            if (p instanceof Window) {
                if (((Window)p).isFocused()) break;
                return;
            }
            p = p.getParent();
        }
        if (component instanceof JComponent && !component.getVisibleRect().contains(unexpandedBounds)) {
            return;
        }
        Rectangle screenBounds = component.getGraphicsConfiguration().getBounds();
        Point screenLocation = component.getLocationOnScreen();
        int preferredWidth = expandedSize.width;
        int availableWidth = screenBounds.x + screenBounds.width - (screenLocation.x + unexpandedBounds.x);
        int totalWidth = Math.min(preferredWidth, availableWidth);
        this.popupPanel.configure(unexpandedBounds.width, totalWidth, unexpandedBounds.height);
        Insets insets = this.popupPanel.getInsets();
        boolean oldDropShadow = Options.isPopupDropShadowEnabled();
        Options.setPopupDropShadowEnabled((boolean)false);
        PopupFactory factory = PopupFactory.getSharedInstance();
        int x = screenLocation.x + unexpandedBounds.x - insets.left;
        int y = screenLocation.y + unexpandedBounds.y - insets.top;
        this.popup = factory.getPopup(component, this.popupPanel, x, y);
        Options.setPopupDropShadowEnabled((boolean)oldDropShadow);
        LOG.trace("really showing {0}, {1}", x, y);
        this.popup.show();
    }

    private void hidePopup() {
        if (this.popup != null) {
            LOG.trace("hiding");
            this.popup.hide();
            this.popup = null;
        }
    }

    private Point getMousePosition(Component component) {
        return component instanceof Container ? ((Container)component).getMousePosition(true) : component.getMousePosition();
    }

    static Log ra$LOG() {
        return LOG;
    }

    static Popup ra$popup(ExpansionTip expansionTip) {
        return expansionTip.popup;
    }

    static Adapter ra$adapter(ExpansionTip expansionTip) {
        return expansionTip.adapter;
    }

    static void mav$hidePopup(ExpansionTip expansionTip) {
        expansionTip.hidePopup();
    }

    static void mav$showPopup(ExpansionTip expansionTip, Rectangle rectangle, Dimension dimension) {
        expansionTip.showPopup(rectangle, dimension);
    }

    static PopupPanel ra$popupPanel(ExpansionTip expansionTip) {
        return expansionTip.popupPanel;
    }

    static Point mav$getMousePosition(ExpansionTip expansionTip, Component component) {
        return expansionTip.getMousePosition(component);
    }

    static ComponentTracker ra$componentTracker(ExpansionTip expansionTip) {
        return expansionTip.componentTracker;
    }

    public static abstract class Adapter
    implements AncestorListener,
    ComponentListener,
    FocusListener {
        private final JComponent component;
        private ChangeListener listener;
        private ChangeEvent event;

        private void $init$() {
            this.event = new ChangeEvent(this);
        }

        protected Adapter(JComponent component) {
            this.$init$();
            this.component = component;
            component.addAncestorListener(this);
        }

        public JComponent getComponent() {
            return this.component;
        }

        public abstract Rectangle getContainingBounds(Point var1);

        public Dimension getPreferredSize() {
            Component subcomponent = this.getSubcomponent();
            if (subcomponent == null) {
                return new Dimension(0, 0);
            }
            return subcomponent.getPreferredSize();
        }

        public abstract Component getSubcomponent();

        public Color getExpandedBorderColor() {
            Color color = UIManager.getColor("Separator.foreground");
            if (color == null) {
                return this.getComponent().getForeground();
            }
            return color;
        }

        protected void fireStateChanged() {
            this.listener.stateChanged(this.event);
        }

        private void addChangeListener(ChangeListener listener) {
            this.listener = listener;
        }

        public void ancestorAdded(AncestorEvent event) {
            this.fireStateChanged();
        }

        public void ancestorMoved(AncestorEvent event) {
            this.fireStateChanged();
        }

        public void ancestorRemoved(AncestorEvent event) {
            this.fireStateChanged();
        }

        public void componentHidden(ComponentEvent e) {
            this.fireStateChanged();
        }

        public void componentMoved(ComponentEvent e) {
            this.fireStateChanged();
        }

        public void componentResized(ComponentEvent e) {
            this.fireStateChanged();
        }

        public void componentShown(ComponentEvent e) {
            this.fireStateChanged();
        }

        public void focusGained(FocusEvent e) {
            this.fireStateChanged();
        }

        public void focusLost(FocusEvent e) {
            this.fireStateChanged();
        }

        static void mav$addChangeListener(Adapter adapter, ChangeListener changeListener) {
            adapter.addChangeListener(changeListener);
        }
    }

    private class ComponentTracker
    extends MouseAdapter
    implements ChangeListener,
    MouseMotionListener {
        private Component component;
        private Rectangle popupUnexpandedBounds;
        private Dimension popupExpandedSize;

        public ComponentTracker(Adapter adapter) {
            this.component = adapter.getComponent();
            Adapter.mav$addChangeListener(adapter, this);
            this.component.addMouseListener(this);
            Point position = ExpansionTip.mav$getMousePosition(ExpansionTip.this, this.component);
            if (position != null) {
                this.maybeChanged(position, false);
            }
        }

        public void stateChanged(ChangeEvent e) {
            if (ExpansionTip.ra$popup(ExpansionTip.this) != null) {
                ExpansionTip.ra$LOG().trace("state changed");
                Point position = ExpansionTip.mav$getMousePosition(ExpansionTip.this, this.component);
                if (position == null && (position = ExpansionTip.ra$popupPanel(ExpansionTip.this).getMousePosition()) != null) {
                    position = SwingUtilities.convertPoint(ExpansionTip.ra$popupPanel(ExpansionTip.this), position, this.component);
                }
                if (position != null) {
                    this.maybeChanged(position, true);
                } else {
                    ExpansionTip.ra$LOG().trace("no position");
                    ExpansionTip.mav$hidePopup(ExpansionTip.this);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
            Point point = e.getPoint();
            ExpansionTip.ra$LOG().trace("mouse entered component {0}", (Object)point);
            this.component.addMouseMotionListener(this);
            if (ExpansionTip.ra$popup(ExpansionTip.this) == null) {
                this.maybeChanged(point, false);
            }
        }

        public void mouseExited(MouseEvent e) {
            Point point = e.getPoint();
            ExpansionTip.ra$LOG().trace("mouse exited component {0}", (Object)point);
            this.component.removeMouseMotionListener(this);
            this.maybeChanged(point, false);
        }

        public void mouseMoved(MouseEvent e) {
            Point point = e.getPoint();
            ExpansionTip.ra$LOG().trace("mouse moved component {0}", (Object)point);
            this.maybeChanged(point, false);
        }

        private void maybeChanged(Point point, boolean revalidate) {
            Rectangle unexpandedBounds = ExpansionTip.ra$adapter(ExpansionTip.this).getContainingBounds(point);
            ExpansionTip.ra$LOG().trace("maybe changed at {1}, revalidate {0}, unexpanded bounds {2}", (Object)revalidate, (Object)point, (Object)unexpandedBounds);
            if (unexpandedBounds == null || !unexpandedBounds.contains(point)) {
                ExpansionTip.mav$hidePopup(ExpansionTip.this);
                return;
            }
            Dimension expandedSize = ExpansionTip.ra$adapter(ExpansionTip.this).getPreferredSize();
            if (expandedSize.width <= unexpandedBounds.width) {
                ExpansionTip.mav$hidePopup(ExpansionTip.this);
                return;
            }
            if (!(ExpansionTip.ra$popup(ExpansionTip.this) == null || unexpandedBounds.equals(this.popupUnexpandedBounds) && expandedSize.equals(this.popupExpandedSize))) {
                ExpansionTip.ra$LOG().trace("invalidating");
                ExpansionTip.mav$hidePopup(ExpansionTip.this);
            }
            if (ExpansionTip.ra$popup(ExpansionTip.this) == null) {
                this.popupUnexpandedBounds = unexpandedBounds;
                this.popupExpandedSize = expandedSize;
                ExpansionTip.mav$showPopup(ExpansionTip.this, unexpandedBounds, expandedSize);
            } else if (revalidate) {
                ExpansionTip.ra$popupPanel(ExpansionTip.this).repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
            Point point = e.getPoint();
            ExpansionTip.ra$LOG().trace("mouse dragged component {0}", (Object)point);
            if (ExpansionTip.ra$popup(ExpansionTip.this) != null) {
                this.maybeChanged(point, true);
            }
        }

        static void mav$maybeChanged(ComponentTracker componentTracker, Point point, boolean bl) {
            componentTracker.maybeChanged(point, bl);
        }
    }

    private class PopupPanel
    extends JComponent
    implements Runnable {
        private CellRendererPane pane;
        private Adapter adapter;
        private int unexpandedWidth;
        private Dimension expandedSize;
        private int[] borderX;
        private int[] borderY;

        private void $init$() {
            this.expandedSize = new Dimension();
            this.borderX = new int[4];
            this.borderY = new int[4];
        }

        public PopupPanel(Adapter adapter) {
            this.$init$();
            this.adapter = adapter;
            this.setBorder(null);
            this.pane = new CellRendererPane();
            this.add(this.pane);
            this.enableEvents(48);
        }

        public void configure(int unexpandedWidth, int expandedWidth, int expandedHeight) {
            ExpansionTip.ra$LOG().trace("configuring, reshowing {0}");
            Insets insets = this.getInsets();
            this.unexpandedWidth = insets.left + unexpandedWidth;
            this.expandedSize.setSize(insets.left + expandedWidth + insets.right, insets.top + expandedHeight + insets.bottom);
        }

        public Dimension getMinimumSize() {
            return this.expandedSize;
        }

        public Dimension getPreferredSize() {
            return this.expandedSize;
        }

        public Dimension getMaximumSize() {
            return this.expandedSize;
        }

        public boolean isOpaque() {
            return false;
        }

        public void paintComponent(Graphics g) {
            Border border;
            Component subcomponent;
            try {
                subcomponent = this.adapter.getSubcomponent();
            }
            catch (Exception e) {
                ExpansionTip.ra$LOG().trace("error getting subcomponent: {0}", (Object)e);
                SwingUtilities.invokeLater(this);
                return;
            }
            Insets insets = this.getInsets();
            this.pane.paintComponent(g, subcomponent, this, insets.left, insets.top, this.expandedSize.width - insets.left - insets.right, this.expandedSize.height - insets.top - insets.bottom, false);
            boolean paintBorder = true;
            if (subcomponent instanceof JComponent && (border = ((JComponent)subcomponent).getBorder()) != null) {
                paintBorder = border.isBorderOpaque() ^ true;
            }
            if (paintBorder) {
                Color oldColor = g.getColor();
                g.setColor(this.adapter.getExpandedBorderColor());
                this.borderX[0] = this.borderX[3] = this.unexpandedWidth + 1;
                this.borderX[1] = this.borderX[2] = this.getWidth() - 1;
                this.borderY[2] = this.borderY[3] = this.getHeight() - 1;
                g.drawPolyline(this.borderX, this.borderY, this.borderX.length);
                g.setColor(oldColor);
            }
        }

        public void paintBorder(Graphics g) {
        }

        public void paintChildren(Graphics g) {
        }

        public void run() {
            ExpansionTip.mav$hidePopup(ExpansionTip.this);
        }

        public void processMouseEvent(MouseEvent e) {
            switch (e.getID()) {
                case 504: {
                    ExpansionTip.ra$LOG().trace("mouse entered popup");
                    break;
                }
                case 505: {
                    ExpansionTip.ra$LOG().trace("mouse exited popup");
                    ComponentTracker.mav$maybeChanged(ExpansionTip.ra$componentTracker(ExpansionTip.this), SwingUtilities.convertPoint(this, e.getPoint(), this.adapter.getComponent()), false);
                    break;
                }
                default: {
                    Point point = e.getPoint();
                    ExpansionTip.ra$LOG().trace("mouse pressed/released/clicked popup {0} ({1})", (Object)point, (Object)this.unexpandedWidth);
                    if (this.unexpandedBoundsContains(point)) {
                        JComponent component = this.adapter.getComponent();
                        component.dispatchEvent(SwingUtilities.convertMouseEvent(this, e, component));
                        break;
                    }
                    ComponentTracker.mav$maybeChanged(ExpansionTip.ra$componentTracker(ExpansionTip.this), SwingUtilities.convertPoint(this, e.getPoint(), this.adapter.getComponent()), false);
                }
            }
        }

        public void processMouseMotionEvent(MouseEvent e) {
            Point point = e.getPoint();
            ExpansionTip.ra$LOG().trace("mouse moved popup {0} ({1})", (Object)point, (Object)this.unexpandedWidth);
            if (this.unexpandedBoundsContains(point)) {
                JComponent component = this.adapter.getComponent();
                component.dispatchEvent(SwingUtilities.convertMouseEvent(this, e, component));
            } else {
                ExpansionTip.ra$LOG().trace("exited region");
                ExpansionTip.mav$hidePopup(ExpansionTip.this);
            }
        }

        private boolean unexpandedBoundsContains(Point point) {
            return point.x >= 0 && point.x < this.unexpandedWidth && point.y >= 0 && point.y < this.expandedSize.height;
        }
    }

    private static class JTableAdapter
    extends Adapter
    implements TableModelListener,
    TableColumnModelListener,
    ListSelectionListener,
    AncestorListener,
    FocusListener {
        private JTable table;
        private int[] columns;
        private int row;
        private int column;

        public JTableAdapter(JTable table, int[] columns) {
            super(table);
            this.table = table;
            this.columns = columns;
            table.addFocusListener(this);
            table.addAncestorListener(this);
            table.getModel().addTableModelListener(this);
            table.getColumnModel().addColumnModelListener(this);
            table.getSelectionModel().addListSelectionListener(this);
        }

        public JComponent getComponent() {
            return this.table;
        }

        public Rectangle getContainingBounds(Point position) {
            this.column = this.table.columnAtPoint(position);
            if (this.column >= 0 && this.enabled(this.column)) {
                Rectangle bounds;
                this.row = this.table.rowAtPoint(position);
                if (this.row >= 0 && (bounds = this.table.getCellRect(this.row, this.column, false)).contains(position)) {
                    return bounds;
                }
            }
            return null;
        }

        private boolean enabled(int column) {
            column = this.table.convertColumnIndexToModel(column);
            int[] nArray = this.columns;
            int n = 0;
            while (n < nArray.length) {
                int c = nArray[n];
                if (c == column) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public Component getSubcomponent() {
            return this.table.prepareRenderer(this.table.getCellRenderer(this.row, this.column), this.row, this.column);
        }

        public Color getExpandedBorderColor() {
            if (this.table.getShowHorizontalLines() || this.table.getShowVerticalLines()) {
                return this.table.getGridColor();
            }
            return super.getExpandedBorderColor();
        }

        public void tableChanged(TableModelEvent e) {
            this.fireStateChanged();
        }

        public void columnAdded(TableColumnModelEvent e) {
            this.fireStateChanged();
        }

        public void columnMarginChanged(ChangeEvent e) {
            this.fireStateChanged();
        }

        public void columnMoved(TableColumnModelEvent e) {
            this.fireStateChanged();
        }

        public void columnRemoved(TableColumnModelEvent e) {
            this.fireStateChanged();
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
            this.fireStateChanged();
        }

        public void valueChanged(ListSelectionEvent e) {
            this.fireStateChanged();
        }
    }

    private static class JTableHeaderAdapter
    extends Adapter
    implements TableColumnModelListener,
    AncestorListener,
    FocusListener {
        private JTableHeader header;
        private int[] columns;
        private int column;

        public JTableHeaderAdapter(JTableHeader header, int[] columns) {
            super(header);
            this.header = header;
            this.columns = columns;
            header.addFocusListener(this);
            header.addAncestorListener(this);
            header.getColumnModel().addColumnModelListener(this);
        }

        public JComponent getComponent() {
            return this.header;
        }

        public Rectangle getContainingBounds(Point position) {
            this.column = this.header.columnAtPoint(position);
            if (this.column >= 0 && this.enabled(this.column)) {
                Rectangle bounds = this.header.getHeaderRect(this.column);
                Insets insets = this.header.getInsets();
                bounds.y -= insets.top;
                bounds.height += insets.bottom;
                if (bounds.contains(position)) {
                    return bounds;
                }
            }
            return null;
        }

        private boolean enabled(int column) {
            column = this.convertColumnIndexToModel(column);
            int[] nArray = this.columns;
            int n = 0;
            while (n < nArray.length) {
                int c = nArray[n];
                if (c == column) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public int convertColumnIndexToModel(int viewColumnIndex) {
            if (viewColumnIndex < 0) {
                return viewColumnIndex;
            }
            return this.header.getColumnModel().getColumn(viewColumnIndex).getModelIndex();
        }

        public Component getSubcomponent() {
            TableColumn tc = this.header.getColumnModel().getColumn(this.column);
            TableCellRenderer renderer = tc.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.header.getDefaultRenderer();
            }
            if (renderer == null) {
                return null;
            }
            return renderer.getTableCellRendererComponent(this.header.getTable(), tc.getHeaderValue(), false, false, -1, this.column);
        }

        public void columnAdded(TableColumnModelEvent e) {
            this.fireStateChanged();
        }

        public void columnMarginChanged(ChangeEvent e) {
            this.fireStateChanged();
        }

        public void columnMoved(TableColumnModelEvent e) {
            this.fireStateChanged();
        }

        public void columnRemoved(TableColumnModelEvent e) {
            this.fireStateChanged();
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
            this.fireStateChanged();
        }
    }

    private static class JTreeAdapter
    extends Adapter
    implements TreeModelListener,
    TreeExpansionListener,
    TreeSelectionListener {
        private JTree tree;
        private int row;

        public JTreeAdapter(JTree tree) {
            super(tree);
            this.tree = tree;
            if (tree.getModel() != null) {
                tree.getModel().addTreeModelListener(this);
            }
            tree.addTreeExpansionListener(this);
            tree.addTreeSelectionListener(this);
        }

        public JComponent getComponent() {
            return this.tree;
        }

        public Rectangle getContainingBounds(Point position) {
            this.row = this.tree.getRowForLocation(position.x, position.y);
            if (this.row >= 0) {
                int vrx1;
                int boundsx1;
                Rectangle bounds = this.tree.getRowBounds(this.row);
                Rectangle vr = this.tree.getVisibleRect();
                Rectangle cont = (Rectangle)bounds.clone();
                if (vr.x > bounds.x) {
                    cont.x = vr.x;
                    cont.width -= vr.x - bounds.x;
                }
                if ((boundsx1 = bounds.x + bounds.width) > (vrx1 = vr.x + vr.width)) {
                    int diff = boundsx1 - vrx1;
                    cont.width -= diff;
                }
                if (cont.contains(position)) {
                    return cont;
                }
            }
            return null;
        }

        public Component getSubcomponent() {
            Object value = this.tree.getPathForRow(this.row).getLastPathComponent();
            return this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, value, this.tree.isRowSelected(this.row), this.tree.isExpanded(this.row), this.tree.getModel().isLeaf(value), this.row, this.tree.getLeadSelectionRow() == this.row);
        }

        public void treeNodesChanged(TreeModelEvent e) {
            this.fireStateChanged();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.fireStateChanged();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.fireStateChanged();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.fireStateChanged();
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            this.fireStateChanged();
        }

        public void treeExpanded(TreeExpansionEvent event) {
            this.fireStateChanged();
        }

        public void valueChanged(TreeSelectionEvent e) {
            this.fireStateChanged();
        }
    }

    private static class JListAdapter
    extends Adapter
    implements ListDataListener,
    ListSelectionListener {
        private JList list;
        private int row;

        public JListAdapter(JList list) {
            super(list);
            this.list = list;
            list.getModel().addListDataListener(this);
            list.addListSelectionListener(this);
        }

        public JComponent getComponent() {
            return this.list;
        }

        public Rectangle getContainingBounds(Point position) {
            Rectangle bounds;
            this.row = this.list.locationToIndex(position);
            if (this.row >= 0 && (bounds = this.list.getCellBounds(this.row, this.row)).contains(position) && bounds.contains(position)) {
                return bounds;
            }
            return null;
        }

        public Component getSubcomponent() {
            return this.list.getCellRenderer().getListCellRendererComponent(this.list, this.list.getModel().getElementAt(this.row), this.row, this.list.isSelectedIndex(this.row), this.list.hasFocus() && this.row == this.list.getLeadSelectionIndex());
        }

        public void contentsChanged(ListDataEvent e) {
            this.fireStateChanged();
        }

        public void intervalAdded(ListDataEvent e) {
            this.fireStateChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.fireStateChanged();
        }

        public void valueChanged(ListSelectionEvent e) {
            this.fireStateChanged();
        }

        public void ancestorAdded(AncestorEvent event) {
            this.fireStateChanged();
        }
    }
}

