/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public final class ExpansionTreeTip {
    protected Popup _clipPopup;
    protected PopupComponent _popupComp;
    protected ClipHandler ch;
    protected int _popRow;
    protected JTree _tree;
    private ModelRepaintListener _modelListener;
    private MouseAWTEventListener _awtEL;

    private void $init$() {
        this._popupComp = new PopupComponent(null);
        this.ch = new ClipHandler(null);
        this._popRow = -1;
        this._modelListener = new ModelRepaintListener(null);
        this._awtEL = new MouseAWTEventListener(null);
    }

    public ExpansionTreeTip(JTree tree) {
        this.$init$();
        if (tree == null) {
            throw new IllegalArgumentException("Attempting to construct ExpansionTreeTip with null tree");
        }
        this._tree = tree;
        this._popupComp.addMouseListener(new 1());
        this.installListeners();
    }

    public void hidePopup() {
        if (this._clipPopup != null) {
            this._clipPopup.hide();
            this._popRow = -1;
            this._clipPopup = null;
            if (this._awtEL != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this._awtEL);
            }
            if (this._modelListener != null) {
                this._tree.getModel().removeTreeModelListener(this._modelListener);
            }
        }
    }

    protected void installListeners() {
        this._tree.addMouseMotionListener(this.ch);
        this._tree.addAncestorListener(this.ch);
        this._tree.addTreeSelectionListener(this.ch);
        this._tree.addFocusListener(this.ch);
        this._tree.addTreeExpansionListener(this.ch);
        this._tree.addMouseListener(this.ch);
    }

    public void uninstall() {
        this._tree.removeMouseMotionListener(this.ch);
        this._tree.removeAncestorListener(this.ch);
        this._tree.removeTreeSelectionListener(this.ch);
        this._tree.removeFocusListener(this.ch);
        this._tree.removeTreeExpansionListener(this.ch);
        this._tree.removeMouseListener(this.ch);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._awtEL);
        if (this._tree.getModel() != null) {
            this._tree.getModel().removeTreeModelListener(this._modelListener);
        }
        this._tree = null;
        this._popupComp = null;
        this._clipPopup = null;
    }

    private void _maybeShow(Point treePoint) {
        this.hidePopup();
        TreePath tp = this._tree.getClosestPathForLocation(treePoint.x, treePoint.y);
        Rectangle nearestBounds = this._tree.getPathBounds(tp);
        if (nearestBounds == null) {
            return;
        }
        if (nearestBounds.y + nearestBounds.height > this._tree.getVisibleRect().y + this._tree.getVisibleRect().height) {
            return;
        }
        if (nearestBounds.y < this._tree.getVisibleRect().y) {
            return;
        }
        Rectangle clipBounds = this._tree.getVisibleRect();
        if (!clipBounds.contains(nearestBounds)) {
            int clipWidth = nearestBounds.width;
            int offset = 0;
            Point popPoint = new Point(nearestBounds.x, nearestBounds.y);
            this._popupComp.setBorder(null);
            if (this._isPopupLightweight(nearestBounds)) {
                clipWidth = nearestBounds.width - (this._tree.getVisibleRect().width - nearestBounds.x) - this._tree.getVisibleRect().x;
                offset = clipWidth - nearestBounds.width;
                popPoint.x = this._tree.getVisibleRect().x + this._tree.getVisibleRect().width;
                this._popupComp.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, UIManager.getColor("Separator.foreground")));
            }
            if (clipWidth > 0) {
                SwingUtilities.convertPointToScreen(popPoint, this._tree);
                this._popupComp.setPaintDetails(tp, offset);
                Insets insets = this._popupComp.getInsets();
                this._popupComp.setPreferredSize(new Dimension(clipWidth + insets.right, nearestBounds.height + insets.top + insets.bottom));
                this._clipPopup = PopupFactory.getSharedInstance().getPopup(this._tree, this._popupComp, popPoint.x, popPoint.y - insets.top);
                this._clipPopup.show();
                this._popRow = this._tree.getRowForPath(tp);
                Toolkit.getDefaultToolkit().addAWTEventListener(this._awtEL, 32);
                this._tree.getModel().addTreeModelListener(this._modelListener);
            }
        }
    }

    private void _maybeHide(Point treePoint) {
        Rectangle vr;
        TreePath tp = this._tree.getClosestPathForLocation(treePoint.x, treePoint.y);
        Rectangle nearestBounds = this._tree.getPathBounds(tp);
        if (nearestBounds != null && !nearestBounds.contains(treePoint)) {
            this.hidePopup();
        }
        if (!(vr = this._tree.getVisibleRect()).contains(treePoint)) {
            this.hidePopup();
        }
    }

    private boolean _isPopupLightweight(Rectangle nearestBounds) {
        Point rightPoint = new Point(nearestBounds.x + nearestBounds.width, nearestBounds.y);
        SwingUtilities.convertPointToScreen(rightPoint, this._tree);
        Window w = SwingUtilities.windowForComponent(this._tree);
        if (w != null) {
            SwingUtilities.convertPointFromScreen(rightPoint, w);
            return w.contains(rightPoint);
        }
        return false;
    }

    static void mav$_maybeHide(ExpansionTreeTip expansionTreeTip, Point point) {
        expansionTreeTip._maybeHide(point);
    }

    static void mav$_maybeShow(ExpansionTreeTip expansionTreeTip, Point point) {
        expansionTreeTip._maybeShow(point);
    }

    final class 1
    extends MouseInputAdapter {
        public void mouseExited(MouseEvent mouseEvent) {
            Point p = mouseEvent.getPoint();
            p = SwingUtilities.convertPoint(ExpansionTreeTip.this._popupComp, p, ExpansionTreeTip.this._tree);
            if (!ExpansionTreeTip.this._tree.getVisibleRect().contains(p)) {
                ExpansionTreeTip.this.hidePopup();
            }
        }

        public void mousePressed(MouseEvent e) {
            this._forwardMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this._forwardMouseEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
            this._forwardMouseEvent(e);
        }

        private void _forwardMouseEvent(MouseEvent e) {
            Point p = SwingUtilities.convertPoint(ExpansionTreeTip.this._popupComp, e.getPoint(), ExpansionTreeTip.this._tree);
            MouseEvent evt = new MouseEvent(ExpansionTreeTip.this._tree, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
            ExpansionTreeTip.this._tree.dispatchEvent(evt);
        }
    }

    private class ModelRepaintListener
    implements TreeModelListener {
        private void rerender() {
            Point treePoint = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(treePoint, ExpansionTreeTip.this._tree);
            SwingUtilities.invokeLater(new 1(this, treePoint));
        }

        public void treeNodesChanged(TreeModelEvent e) {
            this.rerender();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.rerender();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.rerender();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.rerender();
        }

        private ModelRepaintListener() {
        }

        ModelRepaintListener(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ Point v$treePoint;
            final /* synthetic */ ModelRepaintListener this$0;

            public void run() {
                ExpansionTreeTip.mav$_maybeShow(this.this$0.ExpansionTreeTip.this, this.v$treePoint);
            }

            public 1(ModelRepaintListener modelRepaintListener, Point point) {
                this.v$treePoint = point;
                this.this$0 = modelRepaintListener;
            }
        }
    }

    private class MouseAWTEventListener
    implements AWTEventListener {
        public void eventDispatched(AWTEvent event) {
            if (ExpansionTreeTip.this._popupComp != null) {
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, ExpansionTreeTip.this._tree);
                ExpansionTreeTip.mav$_maybeHide(ExpansionTreeTip.this, p);
            }
        }

        private MouseAWTEventListener() {
        }

        MouseAWTEventListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ClipHandler
    extends MouseInputAdapter
    implements AncestorListener,
    TreeSelectionListener,
    FocusListener,
    TreeExpansionListener {
        public void mouseExited(MouseEvent e) {
            ExpansionTreeTip.mav$_maybeHide(ExpansionTreeTip.this, e.getPoint());
        }

        public void mouseMoved(MouseEvent e) {
            TreePath tp = ExpansionTreeTip.this._tree.getClosestPathForLocation(e.getX(), e.getY());
            Rectangle nearestBounds = ExpansionTreeTip.this._tree.getPathBounds(tp);
            if (nearestBounds == null) {
                return;
            }
            if (!nearestBounds.contains(e.getPoint())) {
                ExpansionTreeTip.this.hidePopup();
                return;
            }
            if (ExpansionTreeTip.this._popRow == ExpansionTreeTip.this._tree.getRowForPath(tp)) {
                return;
            }
            ExpansionTreeTip.mav$_maybeShow(ExpansionTreeTip.this, e.getPoint());
        }

        public void ancestorAdded(AncestorEvent e) {
        }

        public void ancestorRemoved(AncestorEvent e) {
        }

        public void ancestorMoved(AncestorEvent e) {
            ExpansionTreeTip.this.hidePopup();
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath tp = e.getNewLeadSelectionPath();
            int row = ExpansionTreeTip.this._tree.getRowForPath(tp);
            if (row != ExpansionTreeTip.this._popRow) {
                ExpansionTreeTip.this.hidePopup();
                return;
            }
            if (ExpansionTreeTip.this._popRow > -1 && ExpansionTreeTip.this._popupComp != null) {
                ExpansionTreeTip.this._popupComp.repaint();
            }
        }

        public void focusGained(FocusEvent e) {
            if (ExpansionTreeTip.this._popRow > -1 && ExpansionTreeTip.this._popupComp != null) {
                ExpansionTreeTip.this._popupComp.repaint();
            }
        }

        public void focusLost(FocusEvent e) {
            if (ExpansionTreeTip.this._popRow > -1 && ExpansionTreeTip.this._popupComp != null) {
                ExpansionTreeTip.this._popupComp.repaint();
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
            ExpansionTreeTip.this.hidePopup();
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            ExpansionTreeTip.this.hidePopup();
        }

        private ClipHandler() {
        }

        ClipHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PopupComponent
    extends JComponent {
        private TreePath _treePath;
        private int _paintOffset;

        public void setPaintDetails(TreePath treePath, int paintOffset) {
            this._treePath = treePath;
            this._paintOffset = paintOffset;
        }

        public void paint(Graphics g) {
            if (ExpansionTreeTip.this._tree == null || this._treePath == null) {
                return;
            }
            int row = ExpansionTreeTip.this._tree.getRowForPath(this._treePath);
            Rectangle rowBounds = ExpansionTreeTip.this._tree.getPathBounds(this._treePath);
            boolean isExpanded = ExpansionTreeTip.this._tree.isExpanded(this._treePath);
            boolean isLeaf = ExpansionTreeTip.this._tree.getModel().isLeaf(this._treePath.getLastPathComponent());
            boolean hasFocus = ExpansionTreeTip.this._tree.hasFocus() && row == ExpansionTreeTip.this._tree.getRowForPath(ExpansionTreeTip.this._tree.getLeadSelectionPath());
            Component component = ExpansionTreeTip.this._tree.getCellRenderer().getTreeCellRendererComponent(ExpansionTreeTip.this._tree, this._treePath.getLastPathComponent(), ExpansionTreeTip.this._tree.isRowSelected(row), isExpanded, isLeaf, row, hasFocus);
            g.setColor(ExpansionTreeTip.this._tree.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            SwingUtilities.paintComponent(g, component, ExpansionTreeTip.this._tree, this._paintOffset, this.getInsets().top, rowBounds.width, rowBounds.height);
            this.paintBorder(g);
        }

        private PopupComponent() {
        }

        PopupComponent(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

