/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;
import oracle.javatools.ui.internal.Exceptions;
import oracle.javatools.ui.search.PromptedTextField;

public final class ExtendedTextField
extends PromptedTextField {
    private LargerTextArea _textArea;
    private JScrollPane _textAreaScrollPane;
    private JDialog _dialog;
    private boolean _updatingCaret;
    private int _ellipsesWidth;
    private static final String ELLIPSES = "...";
    private static final int DIALOG_BORDER_GAP = 2;

    private void $init$() {
        this._updatingCaret = false;
        this._ellipsesWidth = 10;
    }

    public ExtendedTextField() {
        this.$init$();
        this.jbInit();
    }

    private void jbInit() {
        Font f = UIManager.getFont("TextField.font");
        this._ellipsesWidth = SwingUtilities.computeStringWidth(this.getFontMetrics(f), ELLIPSES);
        this.addFocusListener(new 1());
        this.getDocument().addDocumentListener(new 2());
        this.addCaretListener(new 3());
        this.addAncestorListener(new 4());
        this.addHierarchyListener(new 5());
        this._initLargerEditor();
    }

    public void addNotify() {
        super.addNotify();
        this._addLargeTextAreaToWindow();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._dialog != null) {
            this._dialog.dispose();
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        if (e.getOppositeComponent() != this._textArea) {
            super.processFocusEvent(e);
        }
    }

    private void _addLargeTextAreaToWindow() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof Frame) {
            this._dialog = new JDialog((Frame)window, false);
        } else if (window instanceof Dialog) {
            this._dialog = new JDialog((Dialog)window, false);
        } else {
            throw new UnsupportedOperationException("Extended TextField must be displayed in a Frame or a Dialog");
        }
        this._dialog.setUndecorated(true);
        this._dialog.getLayeredPane().putClientProperty("feedback.nofeedback", true);
        JPanel content = new JPanel(new BorderLayout());
        content.setOpaque(true);
        content.setBackground(UIManager.getColor("EditorPane.selectionBackground"));
        this._dialog.getContentPane().setLayout(new BorderLayout());
        this._dialog.getContentPane().add(content);
        content.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._textAreaScrollPane = new JScrollPane(this._textArea);
        this._textAreaScrollPane.setBorder(null);
        content.add(this._textAreaScrollPane);
        this._textArea.addFocusListener(new 6());
    }

    private void _initLargerEditor() {
        this._textArea = new LargerTextArea();
        this._textArea.setLineWrap(true);
        this._textArea.setFont(this.getFont());
        this._textArea.setDocument(this.getDocument());
        this._textArea.setTabSize(0);
        this._textArea.setBorder(null);
    }

    private void _updateLargerEditorVisibility() {
        if (this._updatingCaret || !this.isShowing()) {
            return;
        }
        if (this._dialog != null && this._dialog.isVisible()) {
            if (this._shouldShowLargerEditor()) {
                this._updateLargerEditorSize();
            } else {
                this._hideLargerEditor();
            }
        } else if (this._shouldShowLargerEditor()) {
            this._showLargerEditor();
        }
    }

    private boolean _shouldShowLargerEditor() {
        BoundedRangeModel brm = this.getHorizontalVisibility();
        return brm.getValue() > brm.getMinimum() || brm.getExtent() < brm.getMaximum() - 1;
    }

    private void _showLargerEditor() {
        this._textAreaScrollPane.setVerticalScrollBarPolicy(21);
        this._textArea.setCaretPosition(this.getCaretPosition());
        this._textArea.setSelectionStart(this.getSelectionStart());
        this._textArea.setSelectionEnd(this.getSelectionEnd());
        this._textArea.setForeground(this.getForeground());
        this._textArea.setBackground(this.getBackground());
        this._textArea.setFont(this.getFont());
        this._dialog.setBounds((int)this.getLocationOnScreen().getX() - 2, (int)this.getLocationOnScreen().getY() - 2, this.getWidth() + 2, this.getHeight() + 2);
        this._dialog.setVisible(true);
        this._textArea.requestFocus();
        SwingUtilities.invokeLater(new 7());
    }

    private void _updateLargerEditorSize() {
        if (this._dialog == null || !this.isShowing()) {
            return;
        }
        if (!this._textAreaScrollPane.getVerticalScrollBar().isVisible()) {
            this._textAreaScrollPane.setVerticalScrollBarPolicy(21);
        }
        int rows = Math.min(6, this._textArea.getWrappedLineCount());
        int height = this._textArea.getInsets().top + this._textArea.getInsets().bottom + this._textArea.getMargin().top + this._textArea.getMargin().bottom + 2 + 2;
        int y = (int)this.getLocationOnScreen().getY() - this._textAreaScrollPane.getLocation().y + 1;
        int x = (int)this.getLocationOnScreen().getX() - this._textAreaScrollPane.getLocation().x;
        this._dialog.setBounds(x, y, this.getWidth() + 2, height += rows * this._textArea.getRowHeight());
        this._dialog.getRootPane().setSize(this._dialog.getWidth(), this._dialog.getHeight());
        this._dialog.getLayeredPane().setSize(this._dialog.getWidth(), this._dialog.getHeight());
        this._dialog.getContentPane().setSize(this._dialog.getWidth(), this._dialog.getHeight());
        this._textAreaScrollPane.setSize(this._dialog.getWidth() - 2 - 2, this._dialog.getHeight() - 2 - 2);
        this._dialog.getContentPane().doLayout();
        this._textAreaScrollPane.setVerticalScrollBarPolicy(20);
    }

    private void _hideLargerEditor() {
        this._updatingCaret = true;
        if (this._dialog != null) {
            this.setCaretPosition(this._textArea.getCaretPosition());
            this._dialog.setVisible(false);
        }
        this._updatingCaret = false;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._textArea != null) {
            this._textArea.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._textArea != null) {
            this._textArea.setBackground(color);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this._textArea != null) {
            this._textArea.setFont(font);
        }
    }

    public void setText(String text) {
        this._updatingCaret = true;
        super.setText(text);
        this.setCaretPosition(0);
        this._updatingCaret = false;
    }

    public JTextArea getLargerTextArea() {
        return this._textArea;
    }

    public BoundedRangeModel getHorizontalVisibility() {
        BoundedRangeModel visibility = super.getHorizontalVisibility();
        visibility.setValue(visibility.getMinimum());
        return visibility;
    }

    public void setScrollOffset(int scrollOffset) {
    }

    public void scrollRectToVisible(Rectangle r) {
    }

    public void setBorder(Border border) {
        Border rightGapBorder = BorderFactory.createEmptyBorder(0, 0, 0, this._ellipsesWidth);
        Border newBorder = border != null ? BorderFactory.createCompoundBorder(border, rightGapBorder) : rightGapBorder;
        super.setBorder(newBorder);
    }

    protected void paintComponent(Graphics g) {
        if (this._shouldShowLargerEditor()) {
            super.paintComponent(g);
            FontMetrics fm = g.getFontMetrics();
            int ascent = fm.getMaxAscent();
            int descent = fm.getMaxDescent();
            int baseline = this.getSize().height / 2 - descent / 2 + ascent / 2;
            g.drawString(ELLIPSES, this.getWidth() - this._ellipsesWidth, baseline);
        } else {
            super.paintComponent(g);
        }
    }

    static void mav$_updateLargerEditorSize(ExtendedTextField extendedTextField) {
        extendedTextField._updateLargerEditorSize();
    }

    static JScrollPane ra$_textAreaScrollPane(ExtendedTextField extendedTextField) {
        return extendedTextField._textAreaScrollPane;
    }

    static LargerTextArea ra$_textArea(ExtendedTextField extendedTextField) {
        return extendedTextField._textArea;
    }

    static void mav$_hideLargerEditor(ExtendedTextField extendedTextField) {
        extendedTextField._hideLargerEditor();
    }

    static boolean mav$_shouldShowLargerEditor(ExtendedTextField extendedTextField) {
        return extendedTextField._shouldShowLargerEditor();
    }

    static void mav$_updateLargerEditorVisibility(ExtendedTextField extendedTextField) {
        extendedTextField._updateLargerEditorVisibility();
    }

    static boolean ra$_updatingCaret(ExtendedTextField extendedTextField) {
        return extendedTextField._updatingCaret;
    }

    final class 1
    extends FocusAdapter {
        public void focusGained(FocusEvent e) {
            if (e.getOppositeComponent() != ExtendedTextField.ra$_textArea(ExtendedTextField.this) && ExtendedTextField.mav$_shouldShowLargerEditor(ExtendedTextField.this)) {
                ExtendedTextField.mav$_updateLargerEditorVisibility(ExtendedTextField.this);
            }
        }
    }

    final class oracle.javatools.ui.ExtendedTextField$2
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            if (ExtendedTextField.ra$_updatingCaret(ExtendedTextField.this)) {
                return;
            }
            SwingUtilities.invokeLater(new 1());
        }

        public void removeUpdate(DocumentEvent e) {
            if (ExtendedTextField.ra$_updatingCaret(ExtendedTextField.this)) {
                return;
            }
            SwingUtilities.invokeLater(new 2());
        }

        public void changedUpdate(DocumentEvent e) {
            if (ExtendedTextField.ra$_updatingCaret(ExtendedTextField.this)) {
                return;
            }
            SwingUtilities.invokeLater(new 3());
        }

        final class 1
        implements Runnable {
            public void run() {
                ExtendedTextField.mav$_updateLargerEditorVisibility(ExtendedTextField.this);
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                ExtendedTextField.mav$_updateLargerEditorVisibility(ExtendedTextField.this);
            }
        }

        final class 3
        implements Runnable {
            public void run() {
                ExtendedTextField.mav$_updateLargerEditorVisibility(ExtendedTextField.this);
            }
        }
    }

    final class 3
    implements CaretListener {
        public void caretUpdate(CaretEvent e) {
            ExtendedTextField.mav$_updateLargerEditorVisibility(ExtendedTextField.this);
        }
    }

    final class 4
    implements AncestorListener {
        public void ancestorAdded(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
            ExtendedTextField.mav$_hideLargerEditor(ExtendedTextField.this);
        }

        public void ancestorMoved(AncestorEvent event) {
            ExtendedTextField.mav$_hideLargerEditor(ExtendedTextField.this);
        }
    }

    final class 5
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & (long)4) != 0L) {
                ExtendedTextField.mav$_hideLargerEditor(ExtendedTextField.this);
            }
        }
    }

    final class 6
    extends FocusAdapter {
        public void focusLost(FocusEvent e) {
            Component oppComp = e.getOppositeComponent();
            if (oppComp != null && SwingUtilities.getWindowAncestor(oppComp) != SwingUtilities.getWindowAncestor(ExtendedTextField.ra$_textArea(ExtendedTextField.this))) {
                ExtendedTextField.mav$_hideLargerEditor(ExtendedTextField.this);
            }
        }
    }

    final class 7
    implements Runnable {
        public void run() {
            ExtendedTextField.mav$_updateLargerEditorSize(ExtendedTextField.this);
            ExtendedTextField.ra$_textAreaScrollPane(ExtendedTextField.this).setVerticalScrollBarPolicy(20);
        }
    }

    private class LargerTextArea
    extends JTextArea {
        public LargerTextArea() {
            1 hideAction = new 1();
            String HIDE = "hideAction";
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 64), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 64), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(10, 64), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 128), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 128), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(10, 128), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 512), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 512), hideAction);
            this.getInputMap().put(KeyStroke.getKeyStroke(10, 512), hideAction);
            this.getActionMap().put("hideAction", hideAction);
        }

        public int getRowHeight() {
            return super.getRowHeight();
        }

        public int getWrappedLineCount() {
            try {
                int rowStart = Utilities.getRowStart(this, this.getLineEndOffset(this.getLineCount() - 1));
                int rowY = this.modelToView((int)rowStart).y;
                int wrappedRowCount = rowY / this.getRowHeight();
                int n = wrappedRowCount + 1;
                return n;
            }
            catch (BadLocationException e) {
                Exceptions.swallow(e);
            }
            catch (NullPointerException e) {
                Exceptions.swallow(e);
            }
            return 1;
        }

        final class 1
        extends AbstractAction {
            public void actionPerformed(ActionEvent e) {
                ExtendedTextField.this.requestFocus();
            }
        }
    }
}

