/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Font;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontManager;
import sun.font.PhysicalFont;

public final class Fonts {
    private Fonts() {
    }

    public static Font deriveFont(Font originalFont, int style, float size) {
        try {
            Font.class.getDeclaredConstructor(Font.class);
            Font font = originalFont.deriveFont(style, size);
            return font;
        }
        catch (NoSuchMethodException e) {
            Font font = Fonts.deriveFontIn15(originalFont, style, size);
            return font;
        }
    }

    private static Font deriveFontIn15(Font originalFont, int style, float size) {
        Font newFont = Fonts.newFont(originalFont.getName(), style, size);
        boolean created = Fonts.isCreated(originalFont);
        Fonts.setCreated(newFont, created);
        Font2DHandle handle = Fonts.getFont2DHandle(originalFont);
        if (handle == null) {
            return originalFont.deriveFont(style, size);
        }
        if (handle.font2D instanceof CompositeFont) {
            created = true;
        }
        if (created) {
            if (handle.font2D instanceof CompositeFont && handle.font2D.getStyle() != style) {
                Fonts.setFont2DHandle(newFont, Fonts.getNewComposite(null, style, handle));
            } else {
                Fonts.setFont2DHandle(newFont, handle);
            }
        }
        return newFont;
    }

    private static void setFont2DHandle(Font font, Font2DHandle handle) {
        try {
            Field f = Font.class.getDeclaredField("font2DHandle");
            f.setAccessible(true);
            f.set(font, handle);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Font2DHandle getFont2DHandle(Font font) {
        try {
            Field f = Font.class.getDeclaredField("font2DHandle");
            f.setAccessible(true);
            Font2DHandle font2DHandle = (Font2DHandle)f.get(font);
            return font2DHandle;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void setCreated(Font font, boolean created) {
        try {
            Field f = Font.class.getDeclaredField("createdFont");
            f.setAccessible(true);
            f.set(font, created);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean isCreated(Font font) {
        try {
            Field f = Font.class.getDeclaredField("createdFont");
            f.setAccessible(true);
            boolean bl = (Boolean)f.get(font);
            return bl;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Font newFont(String name, int style, float size) {
        try {
            Constructor ctor = Font.class.getDeclaredConstructor(String.class, Integer.TYPE, Float.TYPE);
            ctor.setAccessible(true);
            Font font = (Font)ctor.newInstance(name, style, Float.valueOf(size));
            return font;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Font2DHandle getNewComposite(String family, int style, Font2DHandle handle) {
        Font2D newFont;
        if (!(handle.font2D instanceof CompositeFont)) {
            return handle;
        }
        CompositeFont oldComp = (CompositeFont)handle.font2D;
        PhysicalFont oldFont = oldComp.getSlotFont(0);
        if (family == null) {
            family = oldFont.getFamilyName(null);
        }
        if (style == -1) {
            style = oldComp.getStyle();
        }
        if (!((newFont = FontManager.findFont2D(family, style, 0)) instanceof PhysicalFont)) {
            newFont = oldFont;
        }
        PhysicalFont physicalFont = (PhysicalFont)newFont;
        CompositeFont dialog2D = (CompositeFont)FontManager.findFont2D("dialog", style, 0);
        if (dialog2D == null) {
            return handle;
        }
        CompositeFont compFont = Fonts.newCompositeFont(physicalFont, dialog2D);
        Font2DHandle newHandle = new Font2DHandle(compFont);
        return newHandle;
    }

    private static CompositeFont newCompositeFont(PhysicalFont physical, CompositeFont font) {
        try {
            Constructor ctor = CompositeFont.class.getDeclaredConstructor(PhysicalFont.class, CompositeFont.class);
            ctor.setAccessible(true);
            CompositeFont compositeFont = (CompositeFont)ctor.newInstance(physical, font);
            return compositeFont;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

