/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.HeaderEvent;
import oracle.javatools.ui.HeaderListener;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.internal.StretchIcon;
import oracle.javatools.ui.plaf.IconicButtonUI;

public final class Header
extends JComponent {
    private static final StretchIcon _subsubBackgroundH = new StretchIcon(new ImageIcon(Header.class.getResource("/oracle/javatools/ui/images/headerbg.png")), new Insets(3, 3, 3, 3));
    private static final StretchIcon _subsubBackgroundV = new StretchIcon(new ImageIcon(Header.class.getResource("/oracle/javatools/ui/images/headerbgv.png")), new Insets(3, 3, 3, 3));
    private final ControlBar _toolbar;
    private final JButton _disclosureIcon;
    private final RotatingLabel _labelAndIcon;
    private final RotatingLabel _rollupTextLabel;
    private final JButton _helpIcon;
    private String _helpTopicId;
    private Level _level;
    private boolean _expanded;
    private Orientation _orientation;
    private final Collection<HeaderListener> _listeners;
    private boolean _expandable;
    private static int _approximateButtonSize = -1;
    private static final Dimension ZERO_DIM = new Dimension(0, 0);
    private static final int BASE_PADDING = 3;
    private static final int MIN_ACTION_GAP = 15;

    private void $init$() {
        this._toolbar = new ControlBar();
        this._disclosureIcon = new JButton();
        this._labelAndIcon = new RotatingLabel();
        this._rollupTextLabel = new RotatingLabel();
        this._helpIcon = new JButton();
        this._expanded = true;
        this._orientation = Orientation.HORIZONTAL;
        this._listeners = new CopyOnWriteArrayList<HeaderListener>();
        this._expandable = true;
    }

    public Header() {
        this.$init$();
        this.setExpanded(true);
        this.setLevel(Level.PAGE);
        this.setOrientation(Orientation.HORIZONTAL);
        this._toolbar.setBorder(BorderFactory.createEmptyBorder());
        this._toolbar.setOpaque(false);
        this._toolbar.setRollover(true);
        this._toolbar.setAlignment(4);
        this._disclosureIcon.setIcon(this.getExpansionIcon(true));
        this._disclosureIcon.addFocusListener(new 1());
        this.add(this._disclosureIcon);
        this.add(this._labelAndIcon);
        this.add(this._helpIcon);
        this.add(this._rollupTextLabel);
        this.add(this._toolbar);
        this.configureExpandAndCollapseActions();
        this.setOpaque(false);
        this._helpIcon.setIcon(OracleIcons.getIcon((String)"help.png"));
        this._helpIcon.setVisible(false);
        this._helpIcon.setToolTipText(UIBundle.get("HELP"));
        this.configureButton(this._disclosureIcon);
        this._disclosureIcon.setFocusPainted(false);
        this._disclosureIcon.setContentAreaFilled(false);
        this._disclosureIcon.setBorder(null);
        this.configureButton(this._helpIcon);
        this._toolbar.setVisible(false);
        this._rollupTextLabel.setForeground(new Color(96, 96, 96));
    }

    private void configureExpandAndCollapseActions() {
        2 ml = new 2();
        this._labelAndIcon.addMouseListener(ml);
        this._disclosureIcon.addActionListener(new 3());
        4 expandAction = new 4("expand");
        5 collapseAction = new 5("collapse");
        this.getActionMap().put("expand", expandAction);
        this.getActionMap().put("collapse", collapseAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0), "collapse");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0), "expand");
    }

    public void setMinimumChars(int minimumChars) {
        if (minimumChars < 0) {
            throw new IllegalArgumentException("minimumChars is " + minimumChars + ". Must not be less than zero.");
        }
        if (minimumChars != RotatingLabel.ra$_minimumChars(this._labelAndIcon)) {
            int old = RotatingLabel.ra$_minimumChars(this._labelAndIcon);
            RotatingLabel.wa$_minimumChars(this._labelAndIcon, minimumChars);
            this.invalidate();
            this.validate();
            this.repaint();
            this.firePropertyChange("minimumChars", old, minimumChars);
        }
    }

    public int getMinimumChars() {
        return RotatingLabel.ra$_minimumChars(this._labelAndIcon);
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation is null");
        }
        Orientation old = this._orientation;
        if (old != orientation) {
            this._orientation = orientation;
            this._labelAndIcon.setOrientation(orientation);
            this._rollupTextLabel.setOrientation(orientation);
            this._toolbar.setOrientation(orientation == Orientation.HORIZONTAL ? 0 : 1);
            this._toolbar.setAlignment(orientation == Orientation.HORIZONTAL ? 4 : 3);
            this.resetInsets(this.getLevel());
            this.invalidate();
            this.validate();
            this.firePropertyChange("orientation", (Object)old, (Object)orientation);
        }
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setHelpTopicId(String helpTopicId) {
        String oldTopic = this._helpTopicId;
        this._helpTopicId = helpTopicId;
        this._helpIcon.setVisible(helpTopicId != null);
        this.firePropertyChange("helpTopicId", oldTopic, helpTopicId);
    }

    public String getHelpTopicId() {
        return this._helpTopicId;
    }

    public void addActionControl(Component actionControl) {
        if (actionControl == null) {
            throw new NullPointerException("actionControl is null");
        }
        this._toolbar.add(actionControl);
        this._toolbar.setVisible(true);
    }

    public void addActionControl(Action action) {
        if (action == null) {
            throw new NullPointerException("action is null");
        }
        this.addActionControl(new JButton(action));
    }

    public void removeActionControl(Action action) {
        int i = 0;
        while (i < this._toolbar.getComponentCount()) {
            Component c = this._toolbar.getComponent(i);
            if (c instanceof AbstractButton && ((AbstractButton)c).getAction() == action) {
                this.removeActionControl(c);
            }
            ++i;
        }
    }

    public void removeActionControl(Component actionControl) {
        int index = Header.indexOfComponent(this._toolbar, actionControl);
        if (index >= 0) {
            this._toolbar.remove(index);
        }
        this._toolbar.setVisible(this._toolbar.getComponentCount() > 0);
    }

    private static int indexOfComponent(Container container, Component component) {
        int i = 0;
        while (i < container.getComponentCount()) {
            if (container.getComponent(i) == component) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        String oldLabel = this._labelAndIcon.getText();
        this._labelAndIcon.setText(text);
        this.updateAccessibleDescription();
        if (!oldLabel.equals(text)) {
            this.firePropertyChange("text", oldLabel, text);
            this.revalidate();
            this.repaint();
        }
    }

    private void updateAccessibleDescription() {
        String tooltip = this._labelAndIcon.getText();
        if (tooltip == null) {
            tooltip = "";
        }
        tooltip = tooltip + " (" + (this._expanded ? UIBundle.get("DISCLOSE_HIDE_CONTENTS") : UIBundle.get("DISCLOSE_SHOW_CONTENTS")) + ")";
        this._disclosureIcon.setToolTipText(tooltip);
    }

    public String getText() {
        return this._labelAndIcon.getText();
    }

    public void setRollupStatusText(String rollupStatusText) {
        String oldLabel = this._rollupTextLabel.getText();
        this._rollupTextLabel.setText(rollupStatusText == null ? "" : rollupStatusText);
        this._rollupTextLabel.setVisible(!this.isExpanded() && rollupStatusText != null && rollupStatusText.length() != 0);
        this.firePropertyChange("rollupStatusText", oldLabel, rollupStatusText);
        this.revalidate();
        this.repaint();
    }

    public String getRollupStatusText() {
        return this._rollupTextLabel.getText();
    }

    public void setExpandable(boolean expandable) {
        if (this._expandable != expandable) {
            this._disclosureIcon.setVisible(expandable);
            if (!expandable) {
                this.setExpanded(true);
            }
            this._expandable = expandable;
            this.firePropertyChange("expandable", expandable ^ true, expandable);
        }
    }

    public boolean isExpandable() {
        return this._expandable;
    }

    public void setIcon(Icon icon) {
        Icon oldIcon = this._labelAndIcon.getIcon();
        if (oldIcon != icon) {
            this._labelAndIcon.setIcon(icon);
            this.firePropertyChange("icon", oldIcon, icon);
            this.repaint();
        }
    }

    public Icon getIcon() {
        return this._labelAndIcon.getIcon();
    }

    public void setExpanded(boolean expanded) {
        if (!this.isExpandable()) {
            return;
        }
        if (this._expanded != expanded) {
            this._expanded = expanded;
            this._disclosureIcon.setIcon(this.getExpansionIcon(expanded));
            if (expanded) {
                this.fireHeaderExpanded();
            } else {
                this.fireHeaderCollapsed();
            }
            this.updateAccessibleDescription();
            this._rollupTextLabel.setVisible(expanded ^ true);
            this.repaint();
            this.firePropertyChange("expanded", expanded ^ true, expanded);
        }
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void addHeaderListener(HeaderListener headerListener) {
        if (headerListener == null) {
            throw new NullPointerException("headerListener is null");
        }
        this._listeners.add(headerListener);
    }

    public void removeHeaderListener(HeaderListener headerListener) {
        this._listeners.remove(headerListener);
    }

    protected final void fireHeaderExpanded() {
        HeaderEvent event = new HeaderEvent(this);
        for (HeaderListener l : this._listeners) {
            l.headerExpanded(event);
        }
    }

    protected final void fireHeaderCollapsed() {
        HeaderEvent event = new HeaderEvent(this);
        for (HeaderListener l : this._listeners) {
            l.headerCollapsed(event);
        }
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (level != this._level) {
            Level oldSize = level;
            this._level = level;
            this.setExpandable(level != Level.PAGE);
            this._labelAndIcon.setFont(this.getTitleFont(level));
            this.resetInsets(level);
            this.firePropertyChange("headerSize", (Object)oldSize, (Object)level);
            this.revalidate();
            this.repaint();
        }
    }

    private void resetInsets(Level level) {
        Insets insets = Level.mav$getInsets(level);
        if (this.getOrientation() == Orientation.VERTICAL) {
            insets = new Insets(insets.left, insets.bottom, insets.right, insets.top);
        }
        this.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
    }

    public Level getLevel() {
        return this._level;
    }

    protected void paintComponent(Graphics g) {
        this.paintBackground(g);
        super.paintComponent(g);
    }

    public Dimension getMinimumSize() {
        int disclosureWidth = this.isExpandable() ? this._disclosureIcon.getMinimumSize().width : 0;
        int disclosureHeight = this.isExpandable() ? this._disclosureIcon.getMinimumSize().width : 0;
        Dimension labelMs = this._labelAndIcon.getMinimumSize();
        Dimension helpMs = this._helpIcon.getMinimumSize();
        Dimension rollupMs = this._rollupTextLabel.getMinimumSize();
        Dimension cbMs = this._toolbar.getMinimumSize();
        return this.calculateSize(disclosureWidth, disclosureHeight, labelMs, helpMs, rollupMs, cbMs);
    }

    private Dimension calculateSize(int disclosureWidth, int disclosureHeight, Dimension labelPs, Dimension helpPs, Dimension rollupPs, Dimension cbPs) {
        boolean horizontal = this.getOrientation() == Orientation.HORIZONTAL;
        Dimension size = new Dimension();
        Insets insets = this.getInsets();
        size.width = insets.left + insets.right;
        size.height = insets.top + insets.bottom;
        if (horizontal) {
            size.width += disclosureWidth;
        } else {
            size.height += disclosureHeight;
        }
        if (horizontal) {
            if (this.isExpandable()) {
                size.width += 3;
            }
            size.width += labelPs.width;
        } else {
            if (this.isExpandable()) {
                size.height += 3;
            }
            size.height += labelPs.height;
        }
        if (this.getHelpTopicId() != null) {
            if (horizontal) {
                size.width += 3;
                size.width += helpPs.width;
            } else {
                size.height += 3;
                size.height += helpPs.height;
            }
        }
        if (this.isRollupTextVisible()) {
            if (horizontal) {
                size.width += 3;
                size.width += rollupPs.width;
            } else {
                size.height += 3;
                size.height += rollupPs.height;
            }
        }
        if (this._toolbar.isVisible()) {
            if (horizontal) {
                size.width += 15;
            } else {
                size.height += 15;
            }
        }
        if (this._toolbar.isVisible()) {
            if (horizontal) {
                size.width += cbPs.width;
            } else {
                size.height += cbPs.height;
            }
        }
        if (horizontal) {
            size.height = size.height + Header.max(size.height, disclosureHeight, labelPs.height, this.getHelpTopicId() == null ? 0 : helpPs.height, !this.isRollupTextVisible() ? 0 : rollupPs.height, !this._toolbar.isVisible() ? 0 : cbPs.height);
        } else {
            size.width = size.width + Header.max(size.width, disclosureWidth, labelPs.width, this.getHelpTopicId() == null ? 0 : helpPs.width, !this.isRollupTextVisible() ? 0 : rollupPs.width, !this._toolbar.isVisible() ? 0 : cbPs.width);
        }
        if (this.getLevel() == Level.SUBSUB) {
            if (horizontal) {
                size.height = Math.max(size.height, Header.getApproximateButtonSize());
            } else {
                size.width = Math.max(size.width, Header.getApproximateButtonSize());
            }
        }
        return size;
    }

    private static int getApproximateButtonSize() {
        if (_approximateButtonSize >= 0) {
            return _approximateButtonSize;
        }
        JToolBar tb = new JToolBar();
        JButton b = new JButton();
        b.setIcon(OracleIcons.getIcon((String)"add.png"));
        tb.add(b);
        Dimension preferredSize = b.getPreferredSize();
        _approximateButtonSize = Math.max(preferredSize.width, preferredSize.height);
        return _approximateButtonSize += 3;
    }

    private boolean isRollupTextVisible() {
        return this._rollupTextLabel.isVisible() && this._rollupTextLabel.getText() != "";
    }

    public Dimension getPreferredSize() {
        int disclosureWidth = this.isExpandable() ? this._disclosureIcon.getPreferredSize().width : 0;
        int disclosureHeight = this.isExpandable() ? this._disclosureIcon.getPreferredSize().width : 0;
        Dimension labelPs = this._labelAndIcon.getPreferredSize();
        Dimension helpPs = this._helpIcon.getPreferredSize();
        Dimension rollupPs = this._rollupTextLabel.getPreferredSize();
        Dimension cbPs = this._toolbar.getPreferredSize();
        return this.calculateSize(disclosureWidth, disclosureHeight, labelPs, helpPs, rollupPs, cbPs);
    }

    public void doLayout() {
        int spaceForLabelAndToolbar;
        int disclosureWidth;
        boolean horizontal;
        Insets insets = this.getInsets();
        int pw = this.getWidth() - (insets.left + insets.right);
        int ph = this.getHeight() - (insets.top + insets.bottom);
        boolean bl = horizontal = this.getOrientation() == Orientation.HORIZONTAL;
        int n = this.isExpandable() ? (horizontal ? this._disclosureIcon.getPreferredSize().width : pw) : (disclosureWidth = 0);
        int disclosureHeight = this.isExpandable() ? (horizontal ? ph : this._disclosureIcon.getPreferredSize().height) : 0;
        Dimension labelPs = this._labelAndIcon.getPreferredSize();
        Dimension labelMs = this._labelAndIcon.getMinimumSize();
        Dimension rollupMs = this.isRollupTextVisible() ? this._rollupTextLabel.getMinimumSize() : ZERO_DIM;
        Dimension rollupPs = this.isRollupTextVisible() ? this._rollupTextLabel.getPreferredSize() : ZERO_DIM;
        Dimension helpPs = this._helpIcon.getPreferredSize();
        Dimension cbPs = this._toolbar.isVisible() ? this._toolbar.getPreferredSize() : ZERO_DIM;
        Dimension cbMs = this._toolbar.isVisible() ? this._toolbar.getMinimumSize() : ZERO_DIM;
        int x = insets.left;
        int y = insets.top;
        if (this.isExpandable()) {
            if (horizontal) {
                this._disclosureIcon.setBounds(x, insets.top + (ph - disclosureHeight) / 2, disclosureWidth, disclosureHeight);
                x += disclosureWidth + 3;
            } else {
                this._disclosureIcon.setBounds(insets.left + (pw - disclosureWidth) / 2, y, disclosureWidth, disclosureHeight);
                y += disclosureHeight + 3;
            }
        }
        int toolbarSize = 0;
        int titleSize = 0;
        int rollupSize = 0;
        int n2 = spaceForLabelAndToolbar = horizontal ? pw - this._disclosureIcon.getWidth() : ph - this._disclosureIcon.getHeight();
        if (this.getHelpTopicId() != null) {
            spaceForLabelAndToolbar -= 3;
            spaceForLabelAndToolbar -= horizontal ? helpPs.width : helpPs.height;
        }
        if (this._toolbar.isVisible()) {
            spaceForLabelAndToolbar -= 3;
        }
        if (this.isRollupTextVisible()) {
            spaceForLabelAndToolbar -= 3;
        }
        int[] minSpans = new int[]{horizontal ? cbMs.width : cbMs.height, horizontal ? labelMs.width : labelMs.height, horizontal ? rollupMs.width : rollupMs.height};
        int[] prefSpans = new int[]{horizontal ? cbPs.width : cbPs.height, horizontal ? labelPs.width : labelPs.height, horizontal ? rollupPs.width : rollupPs.height};
        int[] allocations = new int[3];
        Header.allocateSpanSpace(minSpans, prefSpans, spaceForLabelAndToolbar, allocations);
        toolbarSize = allocations[0];
        titleSize = allocations[1];
        rollupSize = allocations[2];
        this._labelAndIcon.setBounds(horizontal ? x : insets.left + (pw - labelPs.width) / 2, horizontal ? insets.top + (ph - labelPs.height) / 2 : y, horizontal ? titleSize : labelPs.width, horizontal ? labelPs.height : titleSize);
        if (horizontal) {
            x += titleSize;
        } else {
            y += titleSize;
        }
        if (this.getHelpTopicId() != null) {
            if (horizontal) {
                x += 3;
            } else {
                y += 3;
            }
            this._helpIcon.setBounds(horizontal ? x : insets.left + (pw - helpPs.width) / 2, horizontal ? insets.top + (pw - helpPs.height) / 2 : y, helpPs.width, helpPs.height);
            if (horizontal) {
                x += helpPs.width;
            } else {
                y += helpPs.height;
            }
        }
        if (this.isRollupTextVisible()) {
            if (horizontal) {
                x += 3;
            } else {
                y += 3;
            }
            this._rollupTextLabel.setBounds(horizontal ? x : insets.left + (pw - rollupPs.width) / 2, horizontal ? insets.top + (ph - rollupPs.height) / 2 : y, horizontal ? rollupSize : rollupPs.width, horizontal ? rollupPs.height : rollupSize);
            if (horizontal) {
                x += rollupSize;
            } else {
                y += rollupSize;
            }
        }
        if (this._toolbar.isVisible()) {
            if (horizontal) {
                x += 3;
            } else {
                y += 3;
            }
            this._toolbar.setBounds(horizontal ? x : insets.left + (pw - cbPs.width) / 2, horizontal ? insets.top + (ph - cbPs.height) / 2 : y, horizontal ? toolbarSize : cbPs.width, horizontal ? cbPs.height : toolbarSize);
        }
    }

    private static void allocateSpanSpace(int[] inMinimumSpans, int[] inPreferredSpans, int inSpanSize, int[] outAllocatedSpans) {
        int count = inMinimumSpans.length;
        if (inPreferredSpans.length != count || outAllocatedSpans.length != count) {
            throw new IllegalArgumentException("inMinimumSpans, inPreferredSpans, and outAllocatedSpans must all be the same length");
        }
        int preferredSpan = Header.sum(inPreferredSpans);
        int preferredSpanDelta = inSpanSize - preferredSpan;
        if (preferredSpanDelta >= 0) {
            int i = 0;
            while (i < count) {
                outAllocatedSpans[i] = inPreferredSpans[i];
                ++i;
            }
            outAllocatedSpans[0] = outAllocatedSpans[0] + preferredSpanDelta;
        } else {
            int minimumSpan = Header.sum(inMinimumSpans);
            int minimumSpanDelta = inSpanSize - minimumSpan;
            if (minimumSpanDelta < 0) {
                minimumSpanDelta = 0;
            }
            int i = 0;
            while (i < count) {
                int spaceAllocation = Math.min(minimumSpanDelta, inPreferredSpans[i] - inMinimumSpans[i]);
                outAllocatedSpans[i] = inMinimumSpans[i] + spaceAllocation;
                if ((minimumSpanDelta -= spaceAllocation) < 0) {
                    minimumSpanDelta = 0;
                }
                ++i;
            }
        }
    }

    private static int sum(int[] ints) {
        int result = 0;
        int i = 0;
        while (i < ints.length) {
            result += ints[i];
            ++i;
        }
        return result;
    }

    private static int max(int ... ints) {
        if (ints.length == 0) {
            throw new IllegalArgumentException("Need at least one int");
        }
        int cMax = Integer.MIN_VALUE;
        int[] nArray = ints;
        int n = 0;
        while (n < nArray.length) {
            int i = nArray[n];
            if (i > cMax) {
                cMax = i;
            }
            ++n;
        }
        return cMax;
    }

    public AccessibleContext getAccessibleContext() {
        return this._disclosureIcon.getAccessibleContext();
    }

    private void configureButton(AbstractButton button) {
        if (button.getIcon() != null) {
            IconicButtonUI.install(button);
        }
    }

    private Font getTitleFont(Level size) {
        Font labelFont = UIManager.getFont("Label.font");
        if (size == Level.SUBSUB || size == Level.DIALOG) {
            return labelFont;
        }
        Font newFont = labelFont.deriveFont(1);
        return newFont;
    }

    private Icon getExpansionIcon(boolean expanded) {
        return expanded ? OracleIcons.getIcon((String)"blafplus/disclosure_expanded.png") : OracleIcons.getIcon((String)"blafplus/disclosure_collapsed.png");
    }

    public String toString() {
        return String.format("%s [text=%s, level=%s, expanded=%s, icon=%s, helpTopicId=%s]", new Object[]{Header.class.getName(), this.getText(), this.getLevel(), this.isExpanded(), this.getIcon(), this.getHelpTopicId()});
    }

    private void paintBackground(Graphics g) {
        Level.mav$getBackgroundPainter(this.getLevel()).paint(g, this);
    }

    static StretchIcon ra$_subsubBackgroundH() {
        return _subsubBackgroundH;
    }

    static StretchIcon ra$_subsubBackgroundV() {
        return _subsubBackgroundV;
    }

    static JButton ra$_disclosureIcon(Header header) {
        return header._disclosureIcon;
    }

    static RotatingLabel ra$_labelAndIcon(Header header) {
        return header._labelAndIcon;
    }

    final class 1
    implements FocusListener {
        private void update() {
            Header.ra$_labelAndIcon(Header.this).setSimulatedFocusPainted(Header.ra$_disclosureIcon(Header.this).isEnabled() && Header.ra$_disclosureIcon(Header.this).isVisible() && Header.ra$_disclosureIcon(Header.this).hasFocus());
        }

        public void focusGained(FocusEvent e) {
            this.update();
        }

        public void focusLost(FocusEvent e) {
            this.update();
        }
    }

    final class 2
    extends MouseAdapter {
        public void mouseReleased(MouseEvent me) {
            if (SwingUtilities.isLeftMouseButton(me) && Header.this.isExpandable()) {
                Header.ra$_disclosureIcon(Header.this).doClick();
                Header.ra$_disclosureIcon(Header.this).requestFocus();
            }
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Header.this.setExpanded(Header.this.isExpanded() ^ true);
        }
    }

    final class 4
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            Header.this.setExpanded(true);
        }

        public 4(String string) {
            super(string);
        }
    }

    final class 5
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            Header.this.setExpanded(false);
        }

        public 5(String string) {
            super(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Orientation
    extends Enum<Orientation> {
        private static final /* synthetic */ Orientation[] $v;
        public static final /* enum */ Orientation HORIZONTAL;
        public static final /* enum */ Orientation VERTICAL;

        public static Orientation valueOf(String string) {
            return Enum.valueOf(Orientation.class, string);
        }

        public static final Orientation[] values() {
            return (Orientation[])$v.clone();
        }

        static {
            Orientation[] orientationArray = new Orientation[2];
            orientationArray[1] = VERTICAL = new Orientation("VERTICAL", 1);
            orientationArray[0] = HORIZONTAL = new Orientation("HORIZONTAL", 0);
            $v = orientationArray;
        }

        private Orientation(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Level
    extends Enum<Level> {
        private static final /* synthetic */ Level[] $v;
        public static final /* enum */ Level PAGE;
        public static final /* enum */ Level SUB;
        public static final /* enum */ Level SUBSUB;
        public static final /* enum */ Level DIALOG;
        private BackgroundPainter _painter;
        private Insets _insets;

        public static Level valueOf(String string) {
            return Enum.valueOf(Level.class, string);
        }

        public static final Level[] values() {
            return (Level[])$v.clone();
        }

        static {
            Level[] levelArray = new Level[4];
            levelArray[3] = DIALOG = new Level("DIALOG", 3, (BackgroundPainter)new SubBackgroundPainter(null), new Insets(3, 0, 3, 0));
            levelArray[2] = SUBSUB = new Level("SUBSUB", 2, (BackgroundPainter)new SubSubBackgroundPainter(null), new Insets(2, 5, 2, 8));
            levelArray[1] = SUB = new Level("SUB", 1, (BackgroundPainter)new SubBackgroundPainter(null), new Insets(3, 5, 3, 5));
            levelArray[0] = PAGE = new Level("PAGE", 0, (BackgroundPainter)new PageBackgroundPainter(null), new Insets(2, 5, 10, 5));
            $v = levelArray;
        }

        private Level(String painter, int insets, BackgroundPainter backgroundPainter, Insets insets2) {
            this._painter = painter;
            this._insets = (Insets)insets;
        }

        private BackgroundPainter getBackgroundPainter() {
            return this._painter;
        }

        private Insets getInsets() {
            return this._insets;
        }

        static BackgroundPainter mav$getBackgroundPainter(Level level) {
            return level.getBackgroundPainter();
        }

        static Insets mav$getInsets(Level level) {
            return level.getInsets();
        }
    }

    private static abstract class BackgroundPainter {
        public void paint(Graphics g, Header header) {
        }

        private BackgroundPainter() {
        }

        BackgroundPainter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class PageBackgroundPainter
    extends BackgroundPainter {
        private PageBackgroundPainter() {
            super(null);
        }

        PageBackgroundPainter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class SubSubBackgroundPainter
    extends BackgroundPainter {
        public void paint(Graphics g, Header c) {
            if (c.getOrientation() == Orientation.HORIZONTAL) {
                Header.ra$_subsubBackgroundH().paintIcon(c, g, 0, 0, c.getWidth(), c.getHeight());
            } else {
                Header.ra$_subsubBackgroundV().paintIcon(c, g, 0, 0, c.getWidth(), c.getHeight());
            }
            super.paint(g, c);
        }

        private SubSubBackgroundPainter() {
            super(null);
        }

        SubSubBackgroundPainter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class SubBackgroundPainter
    extends BackgroundPainter {
        private static final Color LINE_COLOR = new Color(169, 173, 181);

        public void paint(Graphics g, Header c) {
            int ox = c.getInsets().left;
            int oy = c.getInsets().top;
            int owidth = c.getWidth() - ox - c.getInsets().right;
            int oheight = c.getHeight() - oy - c.getInsets().bottom;
            g.setColor(LINE_COLOR);
            g.drawLine(ox, oy + oheight, ox + owidth, oy + oheight);
            super.paint(g, c);
        }

        private SubBackgroundPainter() {
            super(null);
        }

        SubBackgroundPainter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class RotatingLabel
    extends JComponent {
        private int _minimumChars;
        private Icon _icon;
        private String _text;
        private Orientation _orientation;
        private Border _focusBorder;
        private boolean _simulatedFocus;

        private void $init$() {
            this._minimumChars = 15;
            this._text = "";
            this._orientation = Orientation.HORIZONTAL;
            this._focusBorder = null;
            this._simulatedFocus = false;
        }

        RotatingLabel() {
            this.$init$();
            ToolTipManager.sharedInstance().registerComponent(this);
            JLabel reference = new JLabel();
            this.setFont(reference.getFont());
            this.setForeground(reference.getForeground());
            this.setBackground(reference.getBackground());
            this.setOpaque(false);
            this.updateUI();
        }

        public void setSimulatedFocusPainted(boolean focusPainted) {
            if (focusPainted != this._simulatedFocus) {
                this._simulatedFocus = focusPainted;
                this.repaint();
            }
        }

        public boolean isSimulatedFocusPainted() {
            return this._simulatedFocus;
        }

        public void updateUI() {
            this._focusBorder = UIManager.getBorder("List.focusCellHighlightBorder");
        }

        public String getToolTipText(MouseEvent me) {
            boolean horizontal;
            Dimension ps = this.getPreferredSize();
            boolean bl = horizontal = this._orientation == Orientation.HORIZONTAL;
            if (horizontal && this.getWidth() < ps.width || !horizontal && this.getHeight() < ps.height) {
                return this.getText();
            }
            return super.getToolTipText(me);
        }

        public void setIcon(Icon icon) {
            this._icon = icon;
        }

        public Icon getIcon() {
            return this._icon;
        }

        public void setText(String text) {
            this._text = text;
        }

        public String getText() {
            return this._text;
        }

        public void setOrientation(Orientation orientation) {
            this._orientation = orientation;
        }

        public Orientation getOrientation() {
            return this._orientation;
        }

        public Dimension getMinimumSize() {
            Dimension sz = this.calculatePreferredSize(this._minimumChars);
            Dimension ps = this.getPreferredSize();
            return new Dimension(Math.min(sz.width, ps.width), Math.min(sz.height, ps.height));
        }

        public Dimension getPreferredSize() {
            return this.calculatePreferredSize(-1);
        }

        private Dimension calculatePreferredSize(int visibleCharCount) {
            int iconWidth;
            Insets insets = this.getInsets();
            Dimension size = new Dimension();
            size.width = insets.left + insets.right;
            size.height = insets.top + insets.bottom;
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int textHeight = this.getText() == null || this.getText() == "" ? 0 : fm.getHeight();
            int textWidth = 0;
            if (this.getText() != null && this.getText() != "") {
                if (visibleCharCount == -1) {
                    textWidth = fm.stringWidth(this.getText());
                } else {
                    int ellipsisWidth = fm.stringWidth("...");
                    String truncated = this.getText().length() < visibleCharCount ? this.getText() : this.getText().substring(0, visibleCharCount);
                    textWidth = ellipsisWidth + fm.stringWidth(truncated);
                }
            }
            boolean horizontal = this.getOrientation() == Orientation.HORIZONTAL;
            int iconHeight = this.getIcon() == null ? 0 : this.getIcon().getIconHeight();
            int n = iconWidth = this.getIcon() == null ? 0 : this.getIcon().getIconWidth();
            if (horizontal) {
                size.height = Math.max(size.height, Math.max(iconHeight, textHeight));
                size.width = size.width + iconWidth + (iconWidth != 0 && textWidth != 0 ? 3 : 0) + textWidth;
            } else {
                size.width = Math.max(size.width, Math.max(iconWidth, textHeight));
                size.height = size.height + iconHeight + (iconHeight != 0 && textHeight != 0 ? 3 : 0) + textWidth;
            }
            return size;
        }

        public void paintComponent(Graphics g) {
            Insets insets = this.getInsets();
            Dimension size = this.getSize();
            int pw = size.width - (insets.left + insets.right);
            int ph = size.height - (insets.top + insets.bottom);
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int textWidth = this.getText() == null ? 0 : fm.stringWidth(this.getText());
            int textHeight = fm.getHeight();
            boolean horizontal = this.getOrientation() == Orientation.HORIZONTAL;
            int iconWidth = this.getIcon() == null ? 0 : this.getIcon().getIconWidth();
            int iconHeight = this.getIcon() == null ? 0 : this.getIcon().getIconHeight();
            int remainingSpace = horizontal ? pw : ph;
            g.setColor(this.getForeground());
            g.setFont(this.getFont());
            if (this.getIcon() != null) {
                int iconX = horizontal ? insets.left : pw / 2 - iconWidth / 2;
                int iconY = horizontal ? ph / 2 - iconHeight / 2 : insets.top;
                this.getIcon().paintIcon(this, g, iconX, iconY);
                remainingSpace -= horizontal ? iconWidth : iconHeight;
                remainingSpace -= 3;
            }
            int textX = horizontal ? insets.left + iconWidth + (iconWidth == 0 ? 0 : 3) : insets.top + iconHeight + (iconHeight == 0 ? 0 : 3);
            int textY = horizontal ? ph / 2 - textHeight / 2 : pw / 2 - textHeight / 2;
            String s = this.getText();
            if (textWidth > remainingSpace) {
                int elipsisWidth = fm.stringWidth("...");
                if (elipsisWidth <= remainingSpace) {
                    int sw = elipsisWidth;
                    int nChars = 0;
                    int max = this.getText().length();
                    while (nChars < max) {
                        if ((sw += fm.charWidth(this.getText().charAt(nChars))) > remainingSpace) break;
                        ++nChars;
                    }
                    s = this.getText().substring(0, nChars) + "...";
                } else {
                    return;
                }
            }
            int actualStringWidth = fm.stringWidth(s);
            if (horizontal) {
                GraphicUtils.drawString((Graphics)g, (String)s, (int)textX, (int)(textY + fm.getAscent()));
                if (this._focusBorder != null && this.isSimulatedFocusPainted()) {
                    this._focusBorder.paintBorder(this, g, textX, textY, actualStringWidth, textHeight);
                }
            } else {
                AffineTransform transformDefault = ((Graphics2D)g).getTransform();
                Object aaDefault = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                try {
                    AffineTransform at = new AffineTransform();
                    at.rotate(1.5707963267948966);
                    at.translate(0.0, -(textY + (pw / 2 + textHeight / 2)));
                    ((Graphics2D)g).transform(at);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.drawString(s, textX, textY + fm.getAscent());
                    if (this._focusBorder != null && this.isSimulatedFocusPainted()) {
                        this._focusBorder.paintBorder(this, g, textX, textY + 1, actualStringWidth, textHeight);
                    }
                }
                finally {
                    ((Graphics2D)g).setTransform(transformDefault);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaDefault);
                }
            }
        }

        static int ra$_minimumChars(RotatingLabel rotatingLabel) {
            return rotatingLabel._minimumChars;
        }

        static void wa$_minimumChars(RotatingLabel rotatingLabel, int n) {
            rotatingLabel._minimumChars = n;
        }
    }
}

