/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderEvent;
import oracle.javatools.ui.HeaderListener;
import oracle.javatools.ui.TransparentPanel;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HeaderPanel<T extends JComponent>
extends JPanel {
    private final Header _header;
    private JPanel _contentPanel;
    private MultiLineLabel _hintText;
    private T _hostedComponent;
    private CollapseMode _collapseMode;
    private boolean _paintComponentBorder;
    private boolean _indented;
    private static final int ANIMATION_DURATION = 250;
    private static final float ANIMATION_ACCELERATION = 1.0f;
    private boolean _animationEnabled;
    private float _collapsePercentage;
    private transient TimingController _animationTimer;

    private void $init$() {
        this._header = new Header();
        this._hintText = new MultiLineLabel();
        this._hostedComponent = new JPanel();
        this._paintComponentBorder = true;
        this._indented = false;
        this._animationEnabled = true;
        this._collapsePercentage = 0.0f;
    }

    public HeaderPanel(T hostedComponent) {
        this(hostedComponent, false);
    }

    public HeaderPanel(T hostedComponent, boolean allowOpaqueComponents) {
        this.$init$();
        this._contentPanel = allowOpaqueComponents ? new JPanel() : new TransparentPanel();
        this.add(this._header);
        this.add(this._contentPanel);
        this._contentPanel.setLayout(new BorderLayout());
        this._contentPanel.add((Component)this._hintText, "North");
        this._hintText.setVisible(false);
        this._hintText.setTextWrapper(WordWrapper.getTextWrapper());
        this._hintText.setPreferredAspectRatio(0.0f);
        this._hintText.setForeground(Colors.HINT_TEXT);
        this._hintText.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        if (hostedComponent != null && !allowOpaqueComponents) {
            ((JComponent)hostedComponent).setOpaque(false);
        }
        this.setOpaque(false);
        this.setHostedComponent(hostedComponent);
        this.setCollapseMode(CollapseMode.COLLAPSE_UP);
        this.setComponentBorderPainted(false);
        this.setComponentIndented(true);
        this._header.addHeaderListener(new 1());
    }

    public HeaderPanel() {
        this(null);
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        if (this._animationEnabled != animationEnabled) {
            this._animationEnabled = animationEnabled;
            this.firePropertyChange("animationEnabled", animationEnabled ^ true, animationEnabled);
        }
    }

    public boolean isAnimationEnabled() {
        return this._animationEnabled;
    }

    private void expand() {
        if (this._animationTimer != null) {
            this._animationTimer.stop();
        }
        ((JComponent)this._hostedComponent).setVisible(true);
    }

    private void collapse() {
        if (this.isAnimationEnabled()) {
            2 tgt = new 2();
            this._animationTimer = new TimingController(new Cycle(250, 5), new Envelope(1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.HOLD), (TimingTarget)tgt);
            this._animationTimer.setAcceleration(1.0f);
            this._animationTimer.start();
        } else {
            this.setCollapsePercentage(0.0f);
            ((JComponent)this._hostedComponent).setVisible(false);
            this.revalidate();
        }
    }

    private void updateBorder() {
        int padLeft = this._indented ? 20 : 3;
        int padRight = 3;
        int padTop = this._paintComponentBorder ? 3 : 8;
        int padBottom = 3;
        ((JComponent)this.getHostedComponent()).setBorder(BorderFactory.createEmptyBorder(padTop, padLeft, padBottom, padRight));
        Insets headerInsets = this.getHeader().getInsets();
        int spaceAboveHint = 6;
        if ((spaceAboveHint -= headerInsets.bottom) < 0) {
            spaceAboveHint = 0;
        }
        this._hintText.setBorder(BorderFactory.createEmptyBorder(spaceAboveHint, headerInsets.left, 0, 0));
        this._contentPanel.setBorder(BorderFactory.createEmptyBorder());
    }

    public void setStaticHelpText(String staticHelpText) {
        String oldText = this._hintText.getText();
        if (!staticHelpText.equals(oldText)) {
            this._hintText.setText(staticHelpText);
            this._hintText.setVisible(true);
            this.repaint();
            this.firePropertyChange("staticHelpText", oldText, staticHelpText);
        }
    }

    public String getStaticHelpText() {
        return this._hintText.getText();
    }

    public void setComponentIndented(boolean indented) {
        if (this._indented != indented) {
            this._indented = indented;
            this.updateBorder();
            this.firePropertyChange("componentIndented", indented ^ true, indented);
        }
    }

    public boolean isComponentIndented() {
        return this._indented;
    }

    public void setComponentBorderPainted(boolean paintComponentBorder) {
        if (this._paintComponentBorder != paintComponentBorder) {
            this._paintComponentBorder = paintComponentBorder;
            this.updateBorder();
            this.firePropertyChange("componentBorderPainted", paintComponentBorder ^ true, paintComponentBorder);
        }
    }

    public boolean isComponentBorderPainted() {
        return this._paintComponentBorder;
    }

    public void setCollapseMode(CollapseMode collapseMode) {
        if (collapseMode == null) {
            throw new NullPointerException("collapseModel is null");
        }
        CollapseMode oldMode = this._collapseMode;
        if (this._collapseMode != collapseMode) {
            this._collapseMode = collapseMode;
            this.revalidate();
            this.firePropertyChange("collapseMode", (Object)oldMode, (Object)collapseMode);
        }
    }

    public CollapseMode getCollapseMode() {
        return this._collapseMode;
    }

    public void setHostedComponent(T c) {
        if (this._hostedComponent == c) {
            return;
        }
        if (this._hostedComponent != null) {
            this._contentPanel.remove((Component)this._hostedComponent);
        }
        if (c != null) {
            this._hostedComponent = c;
            this._contentPanel.add((Component)this._hostedComponent, "Center");
            ((JComponent)c).setVisible(this._header.isExpanded());
            this.updateBorder();
        }
    }

    public T getHostedComponent() {
        return this._hostedComponent;
    }

    public Header getHeader() {
        return this._header;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Rectangle headerBounds = new Rectangle();
        Rectangle componentBounds = new Rectangle();
        this.calculateBounds(headerBounds, componentBounds);
        Dimension size = new Dimension();
        size.width = insets.left + insets.right;
        size.height = insets.top + insets.bottom;
        if (this._header.isExpanded() || this._collapseMode == CollapseMode.COLLAPSE_UP) {
            size.width = size.width + Math.max(headerBounds.width, this._header.isExpanded() ? componentBounds.width : 0);
            size.height += headerBounds.height + componentBounds.height;
        } else {
            size.width += headerBounds.width + componentBounds.width;
            size.height += Math.max(headerBounds.height, componentBounds.height);
        }
        return size;
    }

    @Override
    public void doLayout() {
        Rectangle headerBounds = new Rectangle();
        Rectangle componentBounds = new Rectangle();
        Insets insets = this.getInsets();
        this.calculateBounds(headerBounds, componentBounds);
        if (this._collapseMode == CollapseMode.COLLAPSE_UP || this._header.isExpanded()) {
            headerBounds.width = this.getWidth() - insets.left - insets.right;
        }
        if (this._header.isExpanded() || this._collapseMode == CollapseMode.COLLAPSE_UP && (double)this.getCollapsePercentage() > 0.0) {
            componentBounds.width = this.getWidth() - insets.left - insets.right;
        }
        if (this._header.isExpanded() || this._collapseMode != CollapseMode.COLLAPSE_UP && (double)this.getCollapsePercentage() > 0.0) {
            componentBounds.height = this.getHeight() - insets.top - insets.bottom - headerBounds.height;
        }
        this._header.setBounds(headerBounds);
        this._contentPanel.setBounds(componentBounds);
    }

    private void calculateBounds(Rectangle headerBounds, Rectangle componentBounds) {
        Insets insets = this.getInsets();
        Dimension headerMinSize = this._header.getMinimumSize();
        Dimension headerSize = this._header.getPreferredSize();
        Dimension componentSize = this._contentPanel.getPreferredSize();
        boolean collapseUp = this._collapseMode == CollapseMode.COLLAPSE_UP;
        componentBounds.width = Math.max(componentSize.width, headerMinSize.width);
        componentBounds.height = componentSize.height;
        if (this._header.isExpanded()) {
            headerBounds.width = Math.max(componentSize.width, headerMinSize.width);
            headerBounds.height = headerSize.height;
        } else {
            headerBounds.width = collapseUp ? componentBounds.width : headerSize.width;
            headerBounds.height = headerSize.height;
        }
        if (!this._header.isExpanded()) {
            if ((double)this.getCollapsePercentage() == 0.0) {
                componentBounds.width = 0;
                componentBounds.height = 0;
            } else {
                componentBounds.width = collapseUp ? componentBounds.width : (int)(((double)componentBounds.width - (double)headerBounds.width) * (double)this.getCollapsePercentage());
                int n = componentBounds.height = collapseUp ? (int)((double)componentBounds.height * (double)this.getCollapsePercentage()) : Math.max(headerBounds.height, (int)((double)componentBounds.height * (double)this.getCollapsePercentage()));
            }
        }
        if (this._header.isExpanded()) {
            headerBounds.x = insets.left;
            headerBounds.y = insets.top;
            componentBounds.x = insets.left;
            componentBounds.y = insets.top + headerBounds.height;
        } else if (this._collapseMode == CollapseMode.COLLAPSE_UP) {
            headerBounds.x = insets.left;
            headerBounds.y = insets.top;
            componentBounds.x = insets.left;
            componentBounds.y = insets.top + headerBounds.height;
        } else if (this._collapseMode == CollapseMode.COLLAPSE_LEFT) {
            headerBounds.x = insets.left;
            headerBounds.y = insets.top;
            componentBounds.x = insets.left + headerBounds.width;
            componentBounds.y = insets.top;
        } else if (this._collapseMode == CollapseMode.COLLAPSE_RIGHT) {
            headerBounds.x = insets.left + componentBounds.width;
            headerBounds.y = insets.top;
            componentBounds.x = insets.left;
            componentBounds.y = insets.top;
        }
    }

    private void setCollapsePercentage(float value) {
        this._collapsePercentage = value;
        this.revalidate();
    }

    private float getCollapsePercentage() {
        return this._collapsePercentage;
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this._paintComponentBorder) {
            boolean collapsingLeftOrRight;
            if (!this._header.isExpanded() && this.getCollapsePercentage() == 0.0f) {
                return;
            }
            Insets insets = this.getInsets();
            g.setColor(Colors.FLAT_EDITOR_BORDER);
            boolean bl = collapsingLeftOrRight = this._collapseMode != CollapseMode.COLLAPSE_UP && this.getCollapsePercentage() > 0.0f;
            if (collapsingLeftOrRight) {
                g.drawLine(insets.left, insets.top, this.getWidth() - insets.right - 1, insets.top);
            }
            g.drawLine(insets.left, insets.top + (collapsingLeftOrRight ? 0 : 5), insets.left, this.getHeight() - insets.bottom - 1);
            g.drawLine(insets.left, this.getHeight() - insets.bottom - 1, this.getWidth() - insets.right, this.getHeight() - insets.bottom - 1);
            g.drawLine(this.getWidth() - insets.right - 1, insets.top + (collapsingLeftOrRight ? 0 : 5), this.getWidth() - insets.right - 1, this.getHeight() - insets.bottom - 1);
        }
    }

    static void mav$setCollapsePercentage(HeaderPanel headerPanel, float f) {
        headerPanel.setCollapsePercentage(f);
    }

    static JComponent ra$_hostedComponent(HeaderPanel headerPanel) {
        return headerPanel._hostedComponent;
    }

    static void wa$_animationTimer(HeaderPanel headerPanel, TimingController timingController) {
        headerPanel._animationTimer = timingController;
    }

    static CollapseMode ra$_collapseMode(HeaderPanel headerPanel) {
        return headerPanel._collapseMode;
    }

    static Header ra$_header(HeaderPanel headerPanel) {
        return headerPanel._header;
    }

    static void mav$collapse(HeaderPanel headerPanel) {
        headerPanel.collapse();
    }

    static void mav$expand(HeaderPanel headerPanel) {
        headerPanel.expand();
    }

    final class 1
    implements HeaderListener {
        public void headerExpanded(HeaderEvent event) {
            Header.Orientation o = HeaderPanel.ra$_collapseMode(HeaderPanel.this) == CollapseMode.COLLAPSE_UP ? Header.Orientation.HORIZONTAL : (HeaderPanel.ra$_header(HeaderPanel.this).isExpanded() ? Header.Orientation.HORIZONTAL : Header.Orientation.VERTICAL);
            HeaderPanel.ra$_header(HeaderPanel.this).setOrientation(o);
            HeaderPanel.mav$expand(HeaderPanel.this);
            HeaderPanel.this.revalidate();
        }

        public void headerCollapsed(HeaderEvent event) {
            Header.Orientation o = HeaderPanel.ra$_collapseMode(HeaderPanel.this) == CollapseMode.COLLAPSE_UP ? Header.Orientation.HORIZONTAL : (HeaderPanel.ra$_header(HeaderPanel.this).isExpanded() ? Header.Orientation.HORIZONTAL : Header.Orientation.VERTICAL);
            HeaderPanel.ra$_header(HeaderPanel.this).setOrientation(o);
            HeaderPanel.mav$setCollapsePercentage(HeaderPanel.this, 1.0f);
            HeaderPanel.this.revalidate();
            HeaderPanel.mav$collapse(HeaderPanel.this);
        }
    }

    final class 2
    implements TimingTarget {
        public void end() {
            HeaderPanel.ra$_hostedComponent(HeaderPanel.this).setVisible(false);
            HeaderPanel.wa$_animationTimer(HeaderPanel.this, null);
        }

        public void begin() {
        }

        public void timingEvent(long l, long l1, float f) {
            HeaderPanel.mav$setCollapsePercentage(HeaderPanel.this, 1.0f - f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CollapseMode
    extends Enum<CollapseMode> {
        private static final /* synthetic */ CollapseMode[] $v;
        public static final /* enum */ CollapseMode COLLAPSE_UP;
        public static final /* enum */ CollapseMode COLLAPSE_LEFT;
        public static final /* enum */ CollapseMode COLLAPSE_RIGHT;

        public static CollapseMode valueOf(String string) {
            return Enum.valueOf(CollapseMode.class, string);
        }

        public static final CollapseMode[] values() {
            return (CollapseMode[])$v.clone();
        }

        static {
            CollapseMode[] collapseModeArray = new CollapseMode[3];
            collapseModeArray[2] = COLLAPSE_RIGHT = new CollapseMode("COLLAPSE_RIGHT", 2);
            collapseModeArray[1] = COLLAPSE_LEFT = new CollapseMode("COLLAPSE_LEFT", 1);
            collapseModeArray[0] = COLLAPSE_UP = new CollapseMode("COLLAPSE_UP", 0);
            $v = collapseModeArray;
        }

        private CollapseMode(String string2, int n2) {
        }
    }
}

