/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import oracle.javatools.ui.MouseHoverListener;

public class MouseHoverSupport {
    private Timer timer;
    private Point hoverPoint;
    private int hoverZone;
    private Component comp;
    public final int MOUSE_HOVERED;
    private ArrayList<MouseHoverListener> listeners;

    private void $init$() {
        this.hoverZone = 2;
        this.MOUSE_HOVERED = 520;
        this.listeners = new ArrayList();
    }

    public MouseHoverSupport(Component comp, int duration, boolean repeat) {
        this.$init$();
        this.comp = comp;
        Listener l = new Listener(null);
        comp.addMouseMotionListener(l);
        comp.addMouseListener(l);
        this.timer = new Timer(duration, new 1());
        this.timer.setRepeats(repeat);
    }

    public void addMouseHoverListener(MouseHoverListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeMouseHoverListener(MouseHoverListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    private void timerUpdate() {
        Point location = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(location, this.comp);
        if (location.x <= this.comp.getWidth() && location.y <= this.comp.getHeight() && location.x >= 0 && location.y >= 0) {
            MouseEvent me = new MouseEvent(this.comp, 520, System.currentTimeMillis(), 0, this.hoverPoint.x, this.hoverPoint.y, 0, false);
            for (MouseHoverListener l : this.listeners) {
                l.mouseHovered(me);
            }
            if (!this.timer.isRepeats()) {
                this.hoverStop();
            }
        } else {
            this.hoverStop();
        }
    }

    private void hoverStop() {
        this.timer.stop();
        this.hoverPoint = null;
    }

    static void mav$hoverStop(MouseHoverSupport mouseHoverSupport) {
        mouseHoverSupport.hoverStop();
    }

    static Point ra$hoverPoint(MouseHoverSupport mouseHoverSupport) {
        return mouseHoverSupport.hoverPoint;
    }

    static void wa$hoverPoint(MouseHoverSupport mouseHoverSupport, Point point) {
        mouseHoverSupport.hoverPoint = point;
    }

    static Timer ra$timer(MouseHoverSupport mouseHoverSupport) {
        return mouseHoverSupport.timer;
    }

    static int ra$hoverZone(MouseHoverSupport mouseHoverSupport) {
        return mouseHoverSupport.hoverZone;
    }

    static void mav$timerUpdate(MouseHoverSupport mouseHoverSupport) {
        mouseHoverSupport.timerUpdate();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            MouseHoverSupport.mav$timerUpdate(MouseHoverSupport.this);
        }
    }

    private class Listener
    extends MouseInputAdapter {
        public void mouseMoved(MouseEvent me) {
            if (MouseHoverSupport.ra$hoverPoint(MouseHoverSupport.this) == null) {
                MouseHoverSupport.wa$hoverPoint(MouseHoverSupport.this, me.getPoint());
                MouseHoverSupport.ra$timer(MouseHoverSupport.this).start();
            } else if (MouseHoverSupport.ra$hoverPoint(MouseHoverSupport.this).distance(me.getPoint()) > (double)MouseHoverSupport.ra$hoverZone(MouseHoverSupport.this)) {
                MouseHoverSupport.wa$hoverPoint(MouseHoverSupport.this, me.getPoint());
                MouseHoverSupport.ra$timer(MouseHoverSupport.this).restart();
            }
        }

        public void mouseExited(MouseEvent me) {
            MouseHoverSupport.mav$hoverStop(MouseHoverSupport.this);
        }

        public void mousePressed(MouseEvent me) {
            MouseHoverSupport.mav$hoverStop(MouseHoverSupport.this);
        }

        public void mouseClicked(MouseEvent me) {
            MouseHoverSupport.mav$hoverStop(MouseHoverSupport.this);
        }

        public void mouseReleased(MouseEvent me) {
            MouseHoverSupport.mav$hoverStop(MouseHoverSupport.this);
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

