/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.Icon;

public class PolygonIcon
extends Polygon
implements Icon {
    private Color color;
    private int top;
    private int left;
    private int bottom;
    private int right;

    public PolygonIcon() {
    }

    public PolygonIcon(int[] xpoints, int[] ypoints, int npoints) {
        this.addPoints(xpoints, ypoints, npoints);
    }

    public PolygonIcon(Color color) {
        this.setColor(color);
    }

    public PolygonIcon(Color color, int[] xpoints, int[] ypoints, int npoints) {
        this.setColor(color);
        this.addPoints(xpoints, ypoints, npoints);
    }

    public PolygonIcon(int top, int left, int bottom, int right) {
        this.setMargin(top, left, bottom, right);
    }

    public PolygonIcon(int top, int left, int bottom, int right, int[] xpoints, int[] ypoints, int npoints) {
        this.setMargin(top, left, bottom, right);
        this.addPoints(xpoints, ypoints, npoints);
    }

    public PolygonIcon(Color color, int top, int left, int bottom, int right) {
        this.setColor(color);
        this.setMargin(top, left, bottom, right);
    }

    public PolygonIcon(Color color, int top, int left, int bottom, int right, int[] xpoints, int[] ypoints, int npoints) {
        this.setColor(color);
        this.setMargin(top, left, bottom, right);
        this.addPoints(xpoints, ypoints, npoints);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void addPoints(int[] xpoints, int[] ypoints, int npoints) {
        int i = 0;
        while (i < npoints) {
            this.addPoint(xpoints[i], ypoints[i]);
            ++i;
        }
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public int getIconHeight() {
        return this.top + this.getBounds().height + this.bottom;
    }

    public int getIconWidth() {
        return this.left + this.getBounds().width + this.right;
    }

    public Color getColor() {
        return this.color;
    }

    protected Color getColor(Component c) {
        return c.getForeground();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color color = this.getColor();
        if (color == null) {
            color = this.getColor(c);
        }
        Color oldColor = g.getColor();
        g.translate(x + this.left, y + this.top);
        g.setColor(color);
        g.fillPolygon(this);
        g.drawPolygon(this);
        g.translate(-x - this.left, -y - this.top);
        g.setColor(oldColor);
    }
}

