/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public final class TranslucentIcon
implements Icon {
    private final Icon _baseIcon;
    private float _alpha;
    private Composite _composite;

    private void $init$() {
        this._alpha = 1.0f;
    }

    public TranslucentIcon(Icon baseIcon) {
        this.$init$();
        if (baseIcon == null) {
            throw new NullPointerException("baseIcon is null");
        }
        this._baseIcon = baseIcon;
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("Alpha must be between 0.0 and 1.0: " + alpha);
        }
        if (this._alpha != alpha) {
            this._alpha = alpha;
            this._composite = AlphaComposite.getInstance(3, alpha);
        }
    }

    public float getAlpha() {
        return this._alpha;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this._alpha == 1.0f) {
            this._baseIcon.paintIcon(c, g, x, y);
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Composite old = g2d.getComposite();
        g2d.setComposite(this._composite);
        try {
            this._baseIcon.paintIcon(c, g, x, y);
        }
        finally {
            g2d.setComposite(old);
        }
    }

    public int getIconWidth() {
        return this._baseIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this._baseIcon.getIconHeight();
    }
}

