/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TruncatingTreeCellRenderer<T>
implements TreeCellRenderer {
    private int _maxChars;
    private boolean _truncateInMiddle;
    private final TruncatedLabelComponent _component;

    private void $init$() {
        this._maxChars = 40;
        this._truncateInMiddle = true;
        this._component = new TruncatedLabelComponent();
    }

    public final void setMaximumCharacters(int maxChars) {
        if (maxChars <= 0) {
            throw new IllegalArgumentException("maxChars must be > 0");
        }
        this._maxChars = maxChars;
    }

    public final int getMaximumCharacters() {
        return this._maxChars;
    }

    public final void setTruncateInMiddle(boolean truncateInMiddle) {
        this._truncateInMiddle = truncateInMiddle;
    }

    public final boolean isTruncateInMiddle() {
        return this._truncateInMiddle;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            this._component.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this._component.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this._component.setBackground(tree.getBackground());
            this._component.setForeground(tree.getForeground());
        }
        if (hasFocus) {
            this._component.setFocusBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
        } else {
            this._component.setFocusBorder(null);
        }
        this._component.setPaintFocusAroundIcon(UIManager.getBoolean("Tree.drawsFocusBorderAroundIcon"));
        this._component.setText(this.getText(tree, value, selected, expanded, leaf, row));
        this._component.setIcon(this.getIcon(tree, value, selected, expanded, leaf, row));
        return this._component;
    }

    protected String getText(JTree tree, T value, boolean selected, boolean expanded, boolean leaf, int row) {
        return String.valueOf(value);
    }

    protected Icon getIcon(JTree tree, T value, boolean selected, boolean expanded, boolean leaf, int row) {
        if (leaf) {
            return UIManager.getIcon("Tree.leafIcon");
        }
        if (expanded) {
            return UIManager.getIcon("Tree.openIcon");
        }
        return UIManager.getIcon("Tree.closedIcon");
    }

    protected static final String truncate(String text, int maxChars, boolean truncateInMiddle) {
        if (text == null) {
            return "";
        }
        int excessChars = text.length() - maxChars;
        if (excessChars > 0) {
            StringBuffer result = new StringBuffer(maxChars + 3);
            if (truncateInMiddle) {
                double midpoint = (double)text.length() / 2.0;
                double midexcess = (double)excessChars / 2.0;
                int endOfFirstHalf = (int)(midpoint - midexcess);
                result.append(text.substring(0, endOfFirstHalf));
                result.append("...");
                result.append(text.substring(endOfFirstHalf + excessChars));
            } else {
                result.append(text.substring(0, maxChars));
                result.append("...");
            }
            return result.toString();
        }
        return text;
    }

    public static void main(String[] args) {
    }

    public TruncatingTreeCellRenderer() {
        this.$init$();
    }

    static int ra$_maxChars(TruncatingTreeCellRenderer truncatingTreeCellRenderer) {
        return truncatingTreeCellRenderer._maxChars;
    }

    static boolean ra$_truncateInMiddle(TruncatingTreeCellRenderer truncatingTreeCellRenderer) {
        return truncatingTreeCellRenderer._truncateInMiddle;
    }

    public class TruncatedLabelComponent
    extends JLabel {
        private final int ICON_TEXT_GAP;
        private final Insets TEXT_RECT_INSETS;
        private Border _focusBorder;
        private boolean _paintFocusAroundIcon;

        private void $init$() {
            this.ICON_TEXT_GAP = 3;
            this.TEXT_RECT_INSETS = new Insets(0, 1, 0, 4);
            this._focusBorder = null;
            this._paintFocusAroundIcon = false;
        }

        public void setFocusBorder(Border focusBorder) {
            this._focusBorder = focusBorder;
        }

        public void setPaintFocusAroundIcon(boolean paintFocusAroundIcon) {
            this._paintFocusAroundIcon = paintFocusAroundIcon;
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            String text = this.getText();
            Icon icon = this.getIcon();
            String truncatedText = TruncatingTreeCellRenderer.truncate(text, TruncatingTreeCellRenderer.ra$_maxChars(TruncatingTreeCellRenderer.this), TruncatingTreeCellRenderer.ra$_truncateInMiddle(TruncatingTreeCellRenderer.this));
            int iconWidth = icon == null ? 0 : icon.getIconWidth();
            int iconHeight = icon == null ? 0 : icon.getIconHeight();
            int iconTextGap = icon == null ? 0 : 3;
            Dimension size = new Dimension();
            size.width = insets.left + insets.right + iconWidth + iconTextGap + fm.stringWidth(truncatedText) + this.TEXT_RECT_INSETS.left + this.TEXT_RECT_INSETS.right;
            size.height = insets.top + insets.bottom + Math.max(iconHeight, fm.getHeight() + this.TEXT_RECT_INSETS.top + this.TEXT_RECT_INSETS.bottom);
            return size;
        }

        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            Insets insets = this.getInsets();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            String text = this.getText();
            Icon icon = this.getIcon();
            String truncatedText = TruncatingTreeCellRenderer.truncate(text, TruncatingTreeCellRenderer.ra$_maxChars(TruncatingTreeCellRenderer.this), TruncatingTreeCellRenderer.ra$_truncateInMiddle(TruncatingTreeCellRenderer.this));
            int ew = this.getWidth() - insets.left - insets.right;
            int eh = this.getHeight() - insets.top - insets.bottom;
            int x = insets.left;
            if (icon != null) {
                int iconRectY = insets.top + (eh - icon.getIconHeight()) / 2;
                icon.paintIcon(this, g, x, iconRectY);
                x += icon.getIconWidth() + 3;
            }
            int textWidth = fm.stringWidth(truncatedText) + this.TEXT_RECT_INSETS.left + this.TEXT_RECT_INSETS.right;
            int textRectY = insets.top + (eh - fm.getHeight()) / 2;
            g.setColor(this.getBackground());
            g.fillRect(x, 0, textWidth, this.getHeight());
            if (this._focusBorder != null) {
                this._focusBorder.paintBorder(this, g, x, this._paintFocusAroundIcon ? insets.left : 0, this._paintFocusAroundIcon ? ew : textWidth, eh);
            }
            g.setColor(this.getForeground());
            g.drawString(truncatedText, x + this.TEXT_RECT_INSETS.left, textRectY + fm.getAscent());
        }

        public TruncatedLabelComponent() {
            this.$init$();
        }
    }
}

