/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.balloon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.border.Border;

class BalloonBorder
implements Border {
    private static boolean shadowEnabled = true;
    private static int shadowSize = 5;
    private static int shadowDistance = 5;
    private static float shadowOpacity = 0.6f;
    private static int shadowAngle = 45;
    private static int shadowDistanceX;
    private static int shadowDistanceY;
    private static final int POINTER_HEIGHT = 20;
    private static final int POINTER_WIDTH = 20;
    private static final int POINTER_INSET = 20;
    private static final int ARC = 18;
    private static final int HALF_ARC = 9;
    private static final Insets INSETS;
    private static final Insets INSETS_SHADOW;

    static {
        double angleRadians = Math.toRadians(shadowAngle);
        shadowDistanceX = (int)(Math.cos(angleRadians) * (double)shadowDistance);
        shadowDistanceY = (int)(Math.sin(angleRadians) * (double)shadowDistance);
        INSETS = new Insets(9, 9, 29, 9);
        INSETS_SHADOW = new Insets(9, 9, 29 + shadowSize, 9 + shadowSize);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private void applyShadow(BufferedImage image) {
        int aSum;
        int dstWidth = image.getWidth();
        int dstHeight = image.getHeight();
        int left = shadowSize - 1 >> 1;
        int right = shadowSize - left;
        int xStart = left;
        int xStop = dstWidth - right;
        int yStart = left;
        int yStop = dstHeight - right;
        int shadowRgb = Color.BLACK.getRGB() & 0xFFFFFF;
        int[] aHistory = new int[shadowSize];
        int historyIdx = 0;
        int[] dataBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int lastPixelOffset = right * dstWidth;
        float sumDivider = shadowOpacity / (float)shadowSize;
        int y = 0;
        int bufferOffset = 0;
        while (y < dstHeight) {
            aSum = 0;
            historyIdx = 0;
            int x = 0;
            while (x < shadowSize) {
                int a;
                aHistory[x] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++x;
                ++bufferOffset;
            }
            bufferOffset -= right;
            int x2 = xStart;
            while (x2 < xStop) {
                int a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + right] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++x2;
                ++bufferOffset;
            }
            bufferOffset = ++y * dstWidth;
        }
        int x = 0;
        int bufferOffset2 = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            int y2 = 0;
            while (y2 < shadowSize) {
                int a;
                aHistory[y2] = a = dataBuffer[bufferOffset2] >>> 24;
                aSum += a;
                ++y2;
                bufferOffset2 += dstWidth;
            }
            bufferOffset2 -= lastPixelOffset;
            int y3 = yStart;
            while (y3 < yStop) {
                int a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset2] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset2 + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++y3;
                bufferOffset2 += dstWidth;
            }
            bufferOffset2 = ++x;
        }
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int totalWidth, int totalHeight) {
        int width = shadowEnabled ? totalWidth - shadowSize : totalWidth;
        int height = shadowEnabled ? totalHeight - shadowSize : totalHeight;
        Graphics2D g2d = (Graphics2D)g;
        Area clip = new Area(new Rectangle(x, y, x + width, 9));
        clip.add(new Area(new Rectangle(x, y + 9, 9, y + height)));
        clip.add(new Area(new Rectangle(x, y + height - 9 - 20, x + width, y + height)));
        clip.add(new Area(new Rectangle(x + width - 9, y, x + width, y + height)));
        g2d.setClip(clip);
        if (shadowEnabled) {
            BufferedImage bi = new BufferedImage(totalWidth, totalHeight, 2);
            Graphics2D gShadow = bi.createGraphics();
            RoundRectangle2D.Double r = new RoundRectangle2D.Double(x, y, width, height - 20, 18.0, 18.0);
            GeneralPath p = new GeneralPath();
            p.moveTo(x + width - 1 - 20, y + height - 20);
            p.lineTo(x + width - 1 - 20, y + height);
            p.lineTo(x + width - 1 - 20 - 20, y + height - 20);
            gShadow.setColor(Color.BLACK);
            gShadow.fill(r);
            gShadow.fill(p);
            gShadow.dispose();
            this.applyShadow(bi);
            g2d.drawImage((Image)bi, x + shadowDistanceX, y + shadowDistanceY, null);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D.Double r = new RoundRectangle2D.Double(x, y, width - 1, height - 1 - 20, 18.0, 18.0);
        GeneralPath p = new GeneralPath();
        p.moveTo(x + width - 1 - 20, y + height - 1 - 20);
        p.lineTo(x + width - 1 - 20, y + height - 1);
        p.lineTo(x + width - 1 - 20 - 20, y + height - 1 - 20);
        g2d.setColor(c.getBackground());
        g2d.fill(r);
        g2d.setColor(c.getForeground());
        g2d.draw(r);
        g2d.setColor(c.getBackground());
        g2d.fill(p);
        g2d.setColor(c.getForeground());
        g2d.draw(p);
        g2d.setClip(null);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public Insets getBorderInsets(Component c) {
        return shadowEnabled ? INSETS_SHADOW : INSETS;
    }

    public Point getPointerLocation(Component c) {
        int width = shadowEnabled ? c.getWidth() - shadowSize : c.getWidth();
        int height = shadowEnabled ? c.getHeight() - shadowSize : c.getHeight();
        int x = width - 1 - 20;
        int y = height + shadowSize;
        return new Point(x, y);
    }

    BalloonBorder() {
    }
}

