/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.Border;
import oracle.javatools.ui.border.ShadowGradientPaint;

public final class ShadowBorder
implements Border {
    private int _arcSize;
    private int _xOffset;
    private int _yOffset;
    private int _growth;
    private double _shadeIntensity;
    private Color _color;

    private void $init$() {
        this._color = Color.BLACK;
    }

    public ShadowBorder() {
        this(20, 3, 3, 4, 1.0);
    }

    public ShadowBorder(int arcSize, int xOffset, int yOffset, int growth, double shadeIntensity) {
        this.$init$();
        this.setArcSize(arcSize);
        this.setXOffset(xOffset);
        this.setYOffset(yOffset);
        this.setGrowth(growth);
        this.setIntensity(shadeIntensity);
    }

    public void paintBorder(Component c, Graphics gAWT, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)gAWT;
        Insets insets = this.getBorderInsets(c);
        Rectangle2D.Double inRect = new Rectangle2D.Double(x + insets.left, y + insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom);
        Area inArea = new Area(inRect);
        int roundX = x + Math.max(0, this._xOffset);
        int roundY = y + Math.max(0, this._yOffset);
        int roundWidth = this._xOffset >= 0 ? width - this._xOffset : width + this._xOffset;
        int roundHeight = this._yOffset >= 0 ? height - this._yOffset : height + this._yOffset;
        RoundRectangle2D.Double roundRectangle = new RoundRectangle2D.Double(roundX, roundY, roundWidth, roundHeight, this._arcSize, this._arcSize);
        Area area = new Area(roundRectangle);
        area.subtract(inArea);
        this._color = Color.BLACK;
        ShadowGradientPaint gradientPaint = new ShadowGradientPaint(roundRectangle.getBounds2D(), this._arcSize, this._shadeIntensity, this._color);
        g.setPaint(gradientPaint);
        g.fill(area);
    }

    public Insets getBorderInsets(Component c) {
        int top = Math.max(0, -this._yOffset);
        int bottom = Math.max(0, this._growth + this._yOffset);
        int left = Math.max(0, -this._xOffset);
        int right = Math.max(0, this._growth + this._xOffset);
        Insets insets = new Insets(top, left, bottom, right);
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void setXOffset(int offset) {
        this._xOffset = offset;
    }

    public int getXOffset() {
        return this._xOffset;
    }

    public void setYOffset(int offset) {
        this._yOffset = offset;
    }

    public int getYOffset() {
        return this._yOffset;
    }

    public void setGrowth(int growth) {
        this._growth = growth;
    }

    public int getGrowth() {
        return this._growth;
    }

    public void setArcSize(int arcSize) {
        if (arcSize < 0) {
            throw new IllegalArgumentException("arcSize must be >= 0");
        }
        this._arcSize = arcSize;
    }

    public int getArcSize() {
        return this._arcSize;
    }

    public void setIntensity(double intensity) {
        if (intensity < 0.0 || intensity > 1.0) {
            throw new IllegalArgumentException("intensity " + intensity + " is not in the range 0 to 1.");
        }
        this._shadeIntensity = intensity;
    }

    public double getIntensity() {
        return this._shadeIntensity;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color == null ? Color.BLACK : color;
    }
}

