/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.UIManager;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import oracle.javatools.ui.simplestyle.StyledTextRenderer;

class BreadcrumbsButton
extends JButton {
    private int index;
    private StyledTextModel styledModel;

    private void $init$() {
        this.index = -1;
    }

    public BreadcrumbsButton(StyledTextModel styledModel, int index) {
        this.$init$();
        this.index = index;
        this.styledModel = styledModel;
        this.setRolloverEnabled(true);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 1, 5));
        this.setOpaque(false);
    }

    public int getIndex() {
        return this.index;
    }

    public void setText(StyledTextModel styledModel) {
        this.styledModel = styledModel;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.model.isRollover()) {
            g2.setColor(UIManager.getColor("TextArea.selectionBackground"));
            g2.fillRoundRect(1, 0, this.getWidth() - 3, this.getHeight() - 1, this.getHeight() - 1, this.getHeight() - 1);
        }
        if (this.hasFocus()) {
            g2.setColor(UIManager.getColor("ToggleButton.focus"));
            g2.drawRoundRect(1, 0, this.getWidth() - 3, this.getHeight() - 1, this.getHeight() - 1, this.getHeight() - 1);
        }
        if (this.model.isRollover()) {
            g2.setColor(UIManager.getColor("TextField.highlight"));
        } else {
            g2.setColor(UIManager.getColor("TextField.foreground"));
        }
        StyledTextRenderer.renderText(this, g, this.styledModel, this.getInsets().left + 2, this.getInsets().top);
    }

    public Dimension getPreferredSize() {
        Dimension d = StyledTextRenderer.getPreferredSize(this, this.styledModel);
        Insets insets = this.getInsets();
        d.width += insets.left + insets.right;
        d.height += insets.top + insets.bottom;
        return d;
    }
}

