/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsButton;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.JBreadcrumbs;

final class BreadcrumbsLayout
implements LayoutManager2 {
    private BreadcrumbsModel model;
    private Dimension size;
    private int _currentContentsWidth;

    private void $init$() {
        this._currentContentsWidth = 0;
    }

    public BreadcrumbsLayout(BreadcrumbsModel model) {
        this.$init$();
        this.model = model;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        this.invalidateLayout(comp.getParent());
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
        this.size = null;
    }

    public void addLayoutComponent(String name, Component comp) {
        this.invalidateLayout(comp.getParent());
    }

    public void removeLayoutComponent(Component comp) {
        this.invalidateLayout(comp.getParent());
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this.size == null) {
            this.layoutContainer(parent);
        }
        return this.size;
    }

    public Dimension minimumLayoutSize(Container parent) {
        if (this.size == null) {
            this.layoutContainer(parent);
        }
        return this.size;
    }

    public Dimension maximumLayoutSize(Container parent) {
        if (this.size == null) {
            this.layoutContainer(parent);
        }
        return this.size;
    }

    public void layoutContainer(Container parent) {
        try {
            int i = 0;
            while (i <= this.model.getBreadcrumbCount()) {
                if (this.layoutShorter(parent, i)) {
                    return;
                }
                ++i;
            }
        }
        finally {
            this.vAlignSeparators(parent);
        }
    }

    private boolean layoutShorter(Container parent, int crumbsToShorten) {
        int x = parent.getInsets().left + 2;
        int y = parent.getInsets().top;
        int h = 0;
        int xGap = 0;
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component c = parent.getComponent(i);
            if (c instanceof JBreadcrumbs.SeparatorButton) {
                y = parent.getHeight() / 2 - c.getHeight() / 2;
                c.setLocation(x, y);
                c.setSize(c.getPreferredSize());
                h = Math.max(h, c.getHeight());
                x += c.getPreferredSize().width + xGap;
            } else if (c instanceof BreadcrumbsButton) {
                BreadcrumbsButton bb = (BreadcrumbsButton)c;
                int crumbI = bb.getIndex();
                Breadcrumb crumb = this.model.getBreadcrumb(crumbI);
                if (crumbI < crumbsToShorten) {
                    bb.setText(crumb.getShortName());
                } else {
                    bb.setText(crumb.getLongName());
                }
                c.setLocation(x, y);
                c.setSize(c.getPreferredSize());
                h = Math.max(h, c.getHeight());
                x += c.getSize().width + xGap;
            }
            ++i;
        }
        this.size = new Dimension(x, h += parent.getInsets().top + parent.getInsets().bottom);
        this._currentContentsWidth = x;
        return x < parent.getSize().width;
    }

    public int getCurrentContentsWidth() {
        return this._currentContentsWidth;
    }

    private void vAlignSeparators(Container parent) {
        int y = this.size == null ? 2 : this.size.height / 2;
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component c = parent.getComponent(i);
            if (i % 2 == 0) {
                c.setLocation(c.getX(), y - c.getHeight() / 2);
            }
            ++i;
        }
    }
}

