/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.MouseHoverListener;
import oracle.javatools.ui.MouseHoverSupport;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsButton;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsLayout;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;

public class JBreadcrumbs
extends JPanel {
    private BreadcrumbsModel model;
    private ModelListener modelListener;
    private BreadcrumbsLayout layout;
    private JViewport viewport;
    private JPanel contentPanel;
    private ScrollPanel leftSP;
    private ScrollPanel rightSP;
    private LinkedList<BreadcrumbsListener> listeners;

    private void $init$() {
        this.modelListener = new ModelListener(null);
        this.viewport = new JViewport();
        this.contentPanel = new JPanel();
        this.listeners = new LinkedList();
    }

    public JBreadcrumbs() {
        this.$init$();
        this.init();
    }

    public void setModel(BreadcrumbsModel breadcrumbsModel) {
        if (this.model != null) {
            this.model.removeBreadcrumbsModelListener(this.modelListener);
        }
        this.model = breadcrumbsModel;
        this.layout = null;
        if (this.model != null) {
            this.layout = new BreadcrumbsLayout(this.model);
            this.contentPanel.setLayout(this.layout);
            this.model.addBreadcrumbsModelListener(this.modelListener);
            this.updateContents();
        }
    }

    public void addBreadcrumbsListener(BreadcrumbsListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeBreadcrumbsListener(BreadcrumbsListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    private void init() {
        this.setOpaque(false);
        this.contentPanel.add(new JLabel("Breadcrumbs will appear here..."));
        this.contentPanel.setOpaque(false);
        this.viewport.setOpaque(false);
        this.viewport.setView(this.contentPanel);
        this.setLayout(null);
        this.viewport.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.leftSP = new ScrollPanel(true);
        this.add(this.leftSP);
        this.rightSP = new ScrollPanel(false);
        this.add(this.rightSP);
        this.leftSP.setBounds(0, 0, 10, 10);
        this.add(this.viewport);
        this.leftSP.addMouseMotionListener(new 1());
        this.rightSP.addMouseMotionListener(new 2());
        new MouseHoverSupport(this.leftSP, 25, true).addMouseHoverListener(new 3());
        new MouseHoverSupport(this.rightSP, 25, true).addMouseHoverListener(new 4());
    }

    public void setBounds(int x, int y, int w, int h) {
        h = this.contentPanel.getPreferredSize().height + 2;
        int shift = this.viewport.getWidth() - w;
        super.setBounds(x, y, w, h);
        this.viewport.setBounds(0, 0, w, h);
        this.leftSP.setBounds(0, 0, 20, this.getHeight());
        this.rightSP.setBounds(this.getWidth() - 20, 0, 20, this.getHeight());
        this.updateViewOffset(-shift);
    }

    public Dimension getPreferredSize() {
        return this.contentPanel.getPreferredSize();
    }

    private void updateViewOffset(int adjustment) {
        Point p = this.viewport.getViewPosition();
        p.x -= adjustment;
        int overWidth = this.getWidth();
        if (this.layout != null) {
            overWidth -= this.layout.getCurrentContentsWidth();
        }
        p.x = Math.min(-overWidth, p.x);
        p.x = Math.max(0, p.x);
        this.viewport.setViewPosition(p);
        this.leftSP.setVisible(p.x > 0);
        this.rightSP.setVisible(p.x + overWidth < 0);
        if (adjustment != 0) {
            this.fireShowBeadcrumbPeek(null, null);
        }
    }

    private void hoverAt(BreadcrumbsButton bButton) {
        Breadcrumb crumb = this.model.getBreadcrumb(bButton.getIndex());
        Rectangle rect = SwingUtilities.convertRectangle(bButton, new Rectangle(bButton.getSize()), this);
        this.fireShowBeadcrumbPeek(crumb, rect);
    }

    private void updateContents() {
        this.contentPanel.removeAll();
        int i = 0;
        while (i < this.model.getBreadcrumbCount()) {
            BreadcrumbsButton button = new BreadcrumbsButton(this.model.getBreadcrumb(i).getLongName(), i);
            this.contentPanel.add((Component)button, this.contentPanel.getComponentCount());
            button.addActionListener(new 5());
            button.addMouseListener(new 6());
            if (i < this.model.getBreadcrumbCount() - 1) {
                SeparatorButton separator = new SeparatorButton(i);
                this.contentPanel.add((Component)separator, this.contentPanel.getComponentCount());
                separator.addActionListener(new 7());
            }
            MouseHoverSupport hoverSup = new MouseHoverSupport(button, 1000, false);
            hoverSup.addMouseHoverListener(new 8());
            this.repaint();
            ++i;
        }
        this.resetViewportPos();
    }

    private void resetViewportPos() {
        this.viewport.validate();
        int maxX = this.viewport.getViewSize().width - this.viewport.getExtentSize().width;
        this.viewport.setViewPosition(new Point(maxX, 0));
    }

    private void fireBeadcrumbClicked(int crumb) {
        for (BreadcrumbsListener l : this.listeners) {
            l.breadcrumbClicked(this.model.getBreadcrumb(crumb));
        }
    }

    private void fireBeadcrumbContextClicked(int crumb, Point p) {
        for (BreadcrumbsListener l : this.listeners) {
            l.breadcrumbContextClicked(this.model.getBreadcrumb(crumb), p);
        }
    }

    private void fireSeparatorClicked(Breadcrumb crumb, Rectangle r) {
        for (BreadcrumbsListener l : this.listeners) {
            l.separatorClicked(crumb, r);
        }
    }

    private void fireShowBeadcrumbPeek(Breadcrumb crumb, Rectangle r) {
        for (BreadcrumbsListener l : this.listeners) {
            l.showBreadcrumbPeek(crumb, r);
        }
    }

    private void fireHideBeadcrumbPeek() {
        for (BreadcrumbsListener l : this.listeners) {
            l.hideBreadcrumbPeek();
        }
    }

    static void mav$updateContents(JBreadcrumbs jBreadcrumbs) {
        jBreadcrumbs.updateContents();
    }

    static BreadcrumbsModel ra$model(JBreadcrumbs jBreadcrumbs) {
        return jBreadcrumbs.model;
    }

    static BreadcrumbsLayout ra$layout(JBreadcrumbs jBreadcrumbs) {
        return jBreadcrumbs.layout;
    }

    static void mav$fireBeadcrumbClicked(JBreadcrumbs jBreadcrumbs, int n) {
        jBreadcrumbs.fireBeadcrumbClicked(n);
    }

    static void mav$fireHideBeadcrumbPeek(JBreadcrumbs jBreadcrumbs) {
        jBreadcrumbs.fireHideBeadcrumbPeek();
    }

    static void mav$fireBeadcrumbContextClicked(JBreadcrumbs jBreadcrumbs, int n, Point point) {
        jBreadcrumbs.fireBeadcrumbContextClicked(n, point);
    }

    static void mav$fireSeparatorClicked(JBreadcrumbs jBreadcrumbs, Breadcrumb breadcrumb, Rectangle rectangle) {
        jBreadcrumbs.fireSeparatorClicked(breadcrumb, rectangle);
    }

    static void mav$hoverAt(JBreadcrumbs jBreadcrumbs, BreadcrumbsButton breadcrumbsButton) {
        jBreadcrumbs.hoverAt(breadcrumbsButton);
    }

    static ScrollPanel ra$leftSP(JBreadcrumbs jBreadcrumbs) {
        return jBreadcrumbs.leftSP;
    }

    static void mav$updateViewOffset(JBreadcrumbs jBreadcrumbs, int n) {
        jBreadcrumbs.updateViewOffset(n);
    }

    final class 1
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent me) {
            int adjust = (JBreadcrumbs.ra$leftSP(JBreadcrumbs.this).getWidth() - me.getX()) / 4;
            JBreadcrumbs.mav$updateViewOffset(JBreadcrumbs.this, adjust);
        }
    }

    final class 2
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent me) {
            int adjust = -me.getX() / 4;
            JBreadcrumbs.mav$updateViewOffset(JBreadcrumbs.this, adjust);
        }
    }

    final class 3
    implements MouseHoverListener {
        public void mouseHovered(MouseEvent me) {
            int adjust = (JBreadcrumbs.ra$leftSP(JBreadcrumbs.this).getWidth() - me.getX()) / 4;
            JBreadcrumbs.mav$updateViewOffset(JBreadcrumbs.this, adjust);
        }
    }

    final class 4
    implements MouseHoverListener {
        public void mouseHovered(MouseEvent me) {
            int adjust = -me.getX() / 4;
            JBreadcrumbs.mav$updateViewOffset(JBreadcrumbs.this, adjust);
        }
    }

    final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JBreadcrumbs.mav$fireBeadcrumbClicked(JBreadcrumbs.this, ((BreadcrumbsButton)e.getSource()).getIndex());
        }
    }

    final class 6
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), JBreadcrumbs.this);
            if (SwingUtilities.isRightMouseButton(e)) {
                JBreadcrumbs.mav$fireBeadcrumbContextClicked(JBreadcrumbs.this, ((BreadcrumbsButton)e.getSource()).getIndex(), p);
            }
        }

        public void mouseExited(MouseEvent e) {
            JBreadcrumbs.mav$fireHideBeadcrumbPeek(JBreadcrumbs.this);
        }
    }

    final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SeparatorButton separator = (SeparatorButton)e.getSource();
            Breadcrumb crumb = separator.getIndex() > 0 ? JBreadcrumbs.ra$model(JBreadcrumbs.this).getBreadcrumb(separator.getIndex()) : null;
            Rectangle rect = new Rectangle(separator.getLocation(), separator.getSize());
            JBreadcrumbs.mav$fireSeparatorClicked(JBreadcrumbs.this, crumb, rect);
        }
    }

    final class 8
    implements MouseHoverListener {
        public void mouseHovered(MouseEvent me) {
            BreadcrumbsButton bButton = (BreadcrumbsButton)me.getSource();
            JBreadcrumbs.mav$hoverAt(JBreadcrumbs.this, bButton);
        }
    }

    private class ModelListener
    implements BreadcrumbsModelListener {
        public void breadcrumbsUpdated() {
            JBreadcrumbs.mav$updateContents(JBreadcrumbs.this);
        }

        private ModelListener() {
        }

        ModelListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    class SeparatorButton
    extends JButton {
        int index;

        private void $init$() {
            this.index = -1;
        }

        public SeparatorButton(int index) {
            this.$init$();
            this.index = index;
            this.setRolloverEnabled(true);
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setIcon(OracleIcons.getIcon((String)"extras/right.gif"));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(6, 10));
        }

        public int getIndex() {
            return this.index;
        }

        public boolean hasChildren() {
            return JBreadcrumbs.ra$model(JBreadcrumbs.this).hasChildren(JBreadcrumbs.ra$model(JBreadcrumbs.this).getBreadcrumb(this.index));
        }
    }

    private class ScrollPanel
    extends JPanel {
        static final int FADE_W = 20;
        boolean isLeft;

        ScrollPanel(boolean isLeft) {
            this.isLeft = isLeft;
            this.setOpaque(false);
        }

        public Dimension getPreferredSize() {
            if (this.getParent() != null) {
                return new Dimension(20, this.getParent().getHeight());
            }
            return new Dimension(20, 15);
        }

        public void paint(Graphics g) {
            super.paint(g);
            int overWidth = JBreadcrumbs.ra$layout(JBreadcrumbs.this).getCurrentContentsWidth() - this.getWidth();
            if (overWidth > 0) {
                BufferedImage fadeImage = new BufferedImage(20, this.getHeight(), 2);
                Graphics2D imageG = fadeImage.createGraphics();
                Color bg = this.getBackground();
                GradientPaint grad = new GradientPaint(0.0f, 0.0f, new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 255), 20.0f, 0.0f, new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 0));
                imageG.setPaint(grad);
                imageG.fillRect(0, 0, 20, this.getHeight());
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
                if (this.isLeft) {
                    g.drawImage(fadeImage, 0, 0, null);
                } else {
                    g.drawImage(fadeImage, this.getWidth(), 0, -this.getWidth(), this.getHeight(), null);
                }
                imageG.dispose();
            }
        }
    }
}

