/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checktree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.checktree.PartialCheckUI;
import oracle.javatools.ui.checktree.TriStateButtonModel;
import oracle.javatools.ui.checktree.TriStateNode;

public class CheckboxTree
extends JTree {
    public CheckboxTree() {
        this._init();
    }

    public CheckboxTree(TreeModel model) {
        super(model);
        this._init();
    }

    public void setModel(TreeModel model) {
        super.setModel(model);
    }

    private void _init() {
        this.addKeyListener(new 1());
        this.setCellEditor(new CheckboxCellEditor());
        this.setCellRenderer(new CheckboxCellRenderer());
        this.setEditable(true);
    }

    final class 1
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            TreePath path = CheckboxTree.this.getSelectionPath();
            if (path != null && !CheckboxTree.this.isEditing()) {
                CheckboxTree.this.startEditingAtPath(path);
                if (e.getKeyCode() == 32) {
                    ((CheckboxCellEditor)CheckboxTree.this.getCellEditor()).setPressed(true);
                }
            }
        }
    }

    private class CheckboxIconLabel
    extends JPanel {
        protected JCheckBox checkbox;
        protected SelectableLabel label;

        private void $init$() {
            this.label = new SelectableLabel(null);
        }

        CheckboxIconLabel() {
            this.$init$();
            this.checkbox = this.createCheckBox();
            this.setLayout(new BorderLayout(2, 0));
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.label, "Center");
        }

        protected JCheckBox createCheckBox() {
            JCheckBox cb = new JCheckBox();
            cb.setUI((ButtonUI)PartialCheckUI.createUI(cb));
            return cb;
        }
    }

    private static class SelectableLabel
    extends JLabel {
        protected boolean isSelected;

        private void $init$() {
            this.isSelected = false;
        }

        public void paintComponent(Graphics g) {
            if (this.isSelected) {
                this.setOpaque(false);
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                g.setColor(UIManager.getColor("Tree.selectionBackground"));
                Insets i = this.getInsets();
                int x = i.left + this.getIcon().getIconWidth() + this.getIconTextGap() - 1;
                g.fillRect(x, i.top, this.getWidth() - x - i.right + 2, this.getHeight() - i.top - i.bottom);
            } else {
                this.setForeground(UIManager.getColor("Tree.foreground"));
            }
            super.paintComponent(g);
        }

        private SelectableLabel() {
            this.$init$();
        }

        SelectableLabel(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class CheckboxCellRenderer
    extends CheckboxIconLabel
    implements TreeCellRenderer {
        public CheckboxCellRenderer() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            this.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof TriStateNode) {
                TriStateNode node = (TriStateNode)value;
                this.checkbox.setModel(new TriStateButtonModel(node));
                this.label.setText(node.getLabel());
                this.label.setIcon(node.getIcon());
            }
            this.label.isSelected = selected;
            return this;
        }
    }

    private class CheckboxCellEditor
    extends CheckboxIconLabel
    implements TreeCellEditor {
        private JTree _tree;

        public CheckboxCellEditor() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            this.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (value instanceof TriStateNode) {
                TriStateNode node = (TriStateNode)value;
                this.checkbox.setModel(new TriStateButtonModel(node));
                this.label.setText(node.getLabel());
                this.label.setIcon(node.getIcon());
                this.label.isSelected = true;
            }
            this._tree = tree;
            return this;
        }

        public Object getCellEditorValue() {
            return this.checkbox.isSelected();
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public void addCellEditorListener(CellEditorListener l) {
        }

        public void removeCellEditorListener(CellEditorListener l) {
        }

        public void setPressed(boolean b) {
            this.checkbox.getModel().setPressed(b);
        }

        protected JCheckBox createCheckBox() {
            1 newCheckBox = new 1();
            return newCheckBox;
        }

        static JTree ra$_tree(CheckboxCellEditor checkboxCellEditor) {
            return checkboxCellEditor._tree;
        }

        final class 1
        extends JCheckBox {
            protected void processKeyEvent(KeyEvent event) {
                super.processKeyEvent(event);
                if (event.getKeyCode() == 112) {
                    return;
                }
                if (event.getSource() != CheckboxCellEditor.ra$_tree(CheckboxCellEditor.this)) {
                    CheckboxCellEditor.ra$_tree(CheckboxCellEditor.this).dispatchEvent(new KeyEvent(CheckboxCellEditor.ra$_tree(CheckboxCellEditor.this), event.getID(), event.getWhen(), event.getModifiers(), event.getKeyCode(), event.getKeyChar()));
                }
            }
        }
    }
}

