/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checktree;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import javax.swing.text.View;
import oracle.javatools.ui.checktree.TriStateButtonModel;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

final class PartialCheckUI
extends BasicCheckBoxUI {
    private static final PartialCheckUI ui = new PartialCheckUI();
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();

    public static ComponentUI createUI(JComponent b) {
        return ui;
    }

    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        Insets i = c.getInsets();
        size = b.getSize(size);
        PartialCheckUI.viewRect.x = i.left;
        PartialCheckUI.viewRect.y = i.top;
        PartialCheckUI.viewRect.width = PartialCheckUI.size.width - (i.right + PartialCheckUI.viewRect.x);
        PartialCheckUI.viewRect.height = PartialCheckUI.size.height - (i.bottom + PartialCheckUI.viewRect.y);
        PartialCheckUI.iconRect.height = 0;
        PartialCheckUI.iconRect.width = 0;
        PartialCheckUI.iconRect.y = 0;
        PartialCheckUI.iconRect.x = 0;
        PartialCheckUI.textRect.height = 0;
        PartialCheckUI.textRect.width = 0;
        PartialCheckUI.textRect.y = 0;
        PartialCheckUI.textRect.x = 0;
        Icon altIcon = b.getIcon();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, PartialCheckUI.size.width, PartialCheckUI.size.height);
        }
        if (model instanceof TriStateButtonModel && Themes.isThemed() && ((TriStateButtonModel)model).getNodeState() == TriStateNode.NodeState.PARTIAL) {
            ThemeProperties properties = Themes.getActiveTheme().getPartProperties("checkbox.partial");
            altIcon = properties.getIcon("image");
        }
        if (altIcon == null) {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
        }
        if (altIcon == null) {
            altIcon = b.getIcon();
        }
        if (altIcon == null) {
            altIcon = this.getDefaultIcon();
        }
        altIcon.paintIcon(c, g, PartialCheckUI.iconRect.x, PartialCheckUI.iconRect.y);
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
            if (b.hasFocus() && b.isFocusPainted() && PartialCheckUI.textRect.width > 0 && PartialCheckUI.textRect.height > 0) {
                this.paintFocus(g, textRect, size);
            }
        }
    }

    PartialCheckUI() {
    }
}

