/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checktree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TriStateNode
extends DefaultMutableTreeNode
implements Comparable {
    private NodeState nodeState;
    private ArrayList<PropertyChangeListener> _pcListeners;
    public static final String PROP_STATE_CHANGE = "PROP_STATE_CHANGE";

    private void $init$() {
        this.nodeState = NodeState.NO;
        this._pcListeners = new ArrayList();
    }

    public TriStateNode(Object userData) {
        super(userData);
        this.$init$();
    }

    public void setNodeState(NodeState nodeState) {
        this.setNodeState(nodeState, true, true);
    }

    public void setNodeState(NodeState nodeState, boolean propagateStateUp, boolean propagateStateDown) {
        this.nodeState = nodeState;
        if (propagateStateDown) {
            this.propagateChangeDown(nodeState);
        }
        if (propagateStateUp) {
            this.propagateChangeUp(nodeState);
        }
        this.firePropertyChange(PROP_STATE_CHANGE, null, (Object)nodeState);
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    private void propagateChangeUp(NodeState state) {
        if (this.getParent() == null) {
            return;
        }
        TriStateNode parent = (TriStateNode)this.getParent();
        boolean hasYes = false;
        boolean hasNo = false;
        boolean hasPartial = false;
        int i = 0;
        while (i < parent.getChildCount()) {
            TriStateNode childNode = (TriStateNode)parent.getChildAt(i);
            if (childNode.getNodeState() == NodeState.YES) {
                hasYes = true;
            } else if (childNode.getNodeState() == NodeState.NO) {
                hasNo = true;
            } else if (childNode.getNodeState() == NodeState.PARTIAL) {
                hasPartial = true;
            }
            ++i;
        }
        if (hasYes && hasNo) {
            parent.setNodeState(NodeState.PARTIAL, true, false);
        } else if (hasPartial) {
            parent.setNodeState(NodeState.PARTIAL, true, false);
        } else if (hasNo && !hasYes && !hasPartial) {
            parent.setNodeState(NodeState.NO, true, false);
        } else if (hasYes && !hasNo && !hasPartial) {
            parent.setNodeState(NodeState.YES, true, false);
        }
    }

    private void propagateChangeDown(NodeState state) {
        int i = 0;
        while (i < this.getChildCount()) {
            TriStateNode childNode = (TriStateNode)this.getChildAt(i);
            childNode.setNodeState(state, false, true);
            ++i;
        }
    }

    public void sort() {
        if (this.children == null || this.children.size() < 2) {
            return;
        }
        Collections.sort(this.children);
        for (TriStateNode child : this.children) {
            child.sort();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (!this._pcListeners.contains(pcl)) {
            this._pcListeners.add(pcl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._pcListeners.remove(pcl);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, name, oldValue, newValue);
        for (PropertyChangeListener pcl : this._pcListeners) {
            pcl.propertyChange(pce);
        }
    }

    public Icon getIcon() {
        return null;
    }

    public String getLabel() {
        return this.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NodeState
    extends Enum<NodeState> {
        private static final /* synthetic */ NodeState[] $v;
        public static final /* enum */ NodeState NO;
        public static final /* enum */ NodeState YES;
        public static final /* enum */ NodeState PARTIAL;

        public static NodeState valueOf(String string) {
            return Enum.valueOf(NodeState.class, string);
        }

        public static final NodeState[] values() {
            return (NodeState[])$v.clone();
        }

        static {
            NodeState[] nodeStateArray = new NodeState[3];
            nodeStateArray[2] = PARTIAL = new NodeState("PARTIAL", 2);
            nodeStateArray[1] = YES = new NodeState("YES", 1);
            nodeStateArray[0] = NO = new NodeState("NO", 0);
            $v = nodeStateArray;
        }

        private NodeState(String string2, int n2) {
        }
    }
}

