/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.util.LinkedList;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;

public class CheckComboModel
extends DefaultTableModel
implements ComboBoxModel {
    public static final int COLUMN_SEL = 0;
    public static final int COLUMN_ITEM = 1;
    private ListModel _listModel;
    private ListSelectionModel _selModel;

    public CheckComboModel(ListModel listModel, ListSelectionModel selModel) {
        super(listModel.getSize(), 2);
        this._listModel = listModel;
        this._selModel = selModel;
    }

    public Object[] getSelectedItem() {
        LinkedList selList = new LinkedList();
        int i = this._selModel.getMinSelectionIndex();
        while (i <= this._selModel.getMaxSelectionIndex()) {
            if (this._selModel.isSelectedIndex(i)) {
                selList.add(this._listModel.getElementAt(i));
            }
            ++i;
        }
        return selList.toArray();
    }

    public void setSelectedItem(Object anItem) {
        if (anItem instanceof Object[]) {
            Object[] objectArray = (Object[])anItem;
            int n = 0;
            while (n < objectArray.length) {
                Object obj = objectArray[n];
                int i = 0;
                while (i < this._listModel.getSize()) {
                    if (this._listModel.getElementAt(i) == obj) {
                        this._selModel.addSelectionInterval(i, i);
                    }
                    ++i;
                }
                ++n;
            }
        }
    }

    public void addListDataListener(ListDataListener l) {
    }

    public void removeListDataListener(ListDataListener l) {
    }

    public Object getElementAt(int index) {
        return this._listModel.getElementAt(index);
    }

    public int getSize() {
        return this._listModel.getSize();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        if (this._listModel == null) {
            return 0;
        }
        return this._listModel.getSize();
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this._selModel.isSelectedIndex(row);
            }
            case 1: {
                return this._listModel.getElementAt(row);
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public void setValueAt(Object aValue, int row, int column) {
    }

    ListModel getListModel() {
        return this._listModel;
    }

    ListSelectionModel getSelectionModel() {
        return this._selModel;
    }
}

