/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.javatools.ui.combo.CheckComboModel;
import oracle.javatools.ui.combo.JCustomComboBox;

public class JCheckCombo
extends JCustomComboBox {
    private TableCombo _table;
    private ListSelectionModel _selList;
    private JScrollPane _sp;

    public JCheckCombo() {
        this._init();
    }

    public JCheckCombo(ListModel listModel, ListSelectionModel selModel) {
        this._init();
        this.setModel(listModel, selModel);
    }

    public void setModel(ListModel listModel, ListSelectionModel selModel) {
        CheckComboModel model = new CheckComboModel(listModel, selModel);
        this.setModel(model);
    }

    public void setModel(CheckComboModel model) {
        this._selList = model.getSelectionModel();
        super.setModel(model);
        this._table.setModel(model);
        int colWidth = UIManager.getIcon("CheckBox.icon").getIconWidth();
        this._table.getColumnModel().getColumn(0).setMaxWidth(colWidth);
    }

    public void setCellRenderer(TableCellRenderer aRenderer) {
        this._table.setCellRenderer(aRenderer);
    }

    private void _init() {
        JPanel panel = new JPanel(new BorderLayout());
        this._table = new TableCombo(null);
        this._table.setRowSelectionAllowed(true);
        this._table.setTableHeader(null);
        this._table.setShowHorizontalLines(false);
        this._table.setShowVerticalLines(false);
        this._table.setShowGrid(false);
        this._table.setSelectionMode(0);
        this._sp = new JScrollPane(this._table, 20, 30);
        panel.add((Component)this._sp, "North");
        this.setPopupComponent(panel);
        this._table.addMouseMotionListener(new ListMouseListener(null));
        this._table.addMouseListener(new TableClickListener(null));
        this.addKeyListener(new CheckComboKeyListener(null));
    }

    public void firePopupMenuWillBecomeVisible() {
        Dimension newD = new Dimension(this.getWidth() - this._sp.getVerticalScrollBar().getWidth() - 6, this._table.getRowHeight() * 8);
        this._sp.getViewport().setPreferredSize(newD);
        Object selObj = this.getSelectedItem();
        ((CheckComboModel)this.getModel()).setSelectedItem(selObj);
        super.firePopupMenuWillBecomeVisible();
    }

    private void _toggleSelection(int index) {
        if (this._selList.isSelectedIndex(index)) {
            this._selList.removeSelectionInterval(index, index);
        } else {
            this._selList.addSelectionInterval(index, index);
        }
        this._table.repaint();
        this.repaint();
    }

    static TableCombo ra$_table(JCheckCombo jCheckCombo) {
        return jCheckCombo._table;
    }

    static void mav$_toggleSelection(JCheckCombo jCheckCombo, int n) {
        jCheckCombo._toggleSelection(n);
    }

    private class ListMouseListener
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent e) {
            int index = JCheckCombo.ra$_table(JCheckCombo.this).rowAtPoint(e.getPoint());
            JCheckCombo.ra$_table(JCheckCombo.this).getSelectionModel().setSelectionInterval(index, index);
        }

        private ListMouseListener() {
        }

        ListMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TableClickListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            int index = JCheckCombo.ra$_table(JCheckCombo.this).rowAtPoint(e.getPoint());
            JCheckCombo.mav$_toggleSelection(JCheckCombo.this, index);
        }

        private TableClickListener() {
        }

        TableClickListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CheckComboKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 40) {
                int newSel = JCheckCombo.ra$_table(JCheckCombo.this).getSelectedRow() + 1;
                if (newSel < JCheckCombo.ra$_table(JCheckCombo.this).getRowCount()) {
                    JCheckCombo.ra$_table(JCheckCombo.this).getSelectionModel().setSelectionInterval(newSel, newSel);
                    JCheckCombo.ra$_table(JCheckCombo.this).scrollRectToVisible(JCheckCombo.ra$_table(JCheckCombo.this).getCellRect(newSel, 2, true));
                }
            } else if (e.getKeyCode() == 38) {
                int newSel = JCheckCombo.ra$_table(JCheckCombo.this).getSelectedRow() - 1;
                if (newSel >= 0) {
                    JCheckCombo.ra$_table(JCheckCombo.this).getSelectionModel().setSelectionInterval(newSel, newSel);
                    JCheckCombo.ra$_table(JCheckCombo.this).scrollRectToVisible(JCheckCombo.ra$_table(JCheckCombo.this).getCellRect(newSel, 2, true));
                }
            } else if (e.getKeyCode() == 32 && e.getModifiers() != 0) {
                int sel = JCheckCombo.ra$_table(JCheckCombo.this).getSelectedRow();
                JCheckCombo.mav$_toggleSelection(JCheckCombo.this, sel);
            }
        }

        private CheckComboKeyListener() {
        }

        CheckComboKeyListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TableCombo
    extends JTable {
        private TableCellRenderer _renderer;

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return new DefaultCellEditor(new JCheckBox());
            }
            return super.getCellEditor(row, column);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 0) {
                return new CheckBoxCellRenderer();
            }
            if (this._renderer != null) {
                return this._renderer;
            }
            return super.getCellRenderer(row, column);
        }

        public void setCellRenderer(TableCellRenderer renderer) {
            this._renderer = renderer;
        }

        private TableCombo() {
        }

        TableCombo(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxCellRenderer() {
            this.setOpaque(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            }
            return this;
        }
    }
}

