/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.javatools.ui.combo.FixListComboModel;
import oracle.javatools.ui.combo.JCustomComboBox;

public class JFixListCombo
extends JCustomComboBox {
    private JList _scrollList;
    private JList _fixList;
    private JScrollPane _sp;
    private boolean _fixListBelow;

    public JFixListCombo() {
        this.$init$();
        this._init();
    }

    public JFixListCombo(ListModel scrollModel, ListModel fixedModel) {
        this.$init$();
        this._init();
        this.setModel(scrollModel, fixedModel);
    }

    public void setModel(ListModel scrollModel, ListModel fixedModel) {
        FixListComboModel flcModel = new FixListComboModel(this._scrollList, this._fixList, this._fixListBelow);
        super.setModel(flcModel);
        this._scrollList.setModel(scrollModel);
        this._fixList.setModel(fixedModel);
    }

    public void setRenderer(ListCellRenderer aRenderer) {
        super.setRenderer(aRenderer);
        if (this._fixList != null) {
            this._fixList.setCellRenderer(aRenderer);
            this._scrollList.setCellRenderer(aRenderer);
        }
    }

    private void _init() {
        JPanel panel = new JPanel(new BorderLayout());
        this._scrollList = new JList();
        this._fixList = new JList();
        this._sp = new JScrollPane(this._scrollList, 20, 30);
        this.setPopupComponent(panel);
        this._addListsToPopup();
        ListMouseListener lml = new ListMouseListener(null);
        this._fixList.addMouseMotionListener(lml);
        this._scrollList.addMouseMotionListener(lml);
        ListClickListener lcl = new ListClickListener(null);
        this._fixList.addMouseListener(lcl);
        this._scrollList.addMouseListener(lcl);
        SingleListSelectionListener slsl = new SingleListSelectionListener(null);
        this._fixList.addListSelectionListener(slsl);
        this._scrollList.addListSelectionListener(slsl);
    }

    private void _addListsToPopup() {
        JComponent panel = this.getPopupComponent();
        if (this._fixListBelow) {
            panel.add((Component)this._sp, "North");
            panel.add((Component)this._fixList, "South");
        } else {
            panel.add((Component)this._fixList, "North");
            panel.add((Component)this._sp, "South");
        }
    }

    public boolean getFixListBelow() {
        return this._fixListBelow;
    }

    public void setFixListBelow(boolean fixListBelow) {
        if (fixListBelow == this._fixListBelow) {
            return;
        }
        this._fixListBelow = fixListBelow;
        this.getPopupComponent().removeAll();
        this._addListsToPopup();
        ((FixListComboModel)this.getModel()).setFixListBelow(this._fixListBelow);
    }

    public void firePopupMenuWillBecomeVisible() {
        Dimension d = this._sp.getViewport().getPreferredSize();
        Dimension newD = new Dimension(this.getWidth() - this._sp.getVerticalScrollBar().getWidth() - 6, d.height);
        this._sp.getViewport().setPreferredSize(newD);
        Object selObj = this.getSelectedItem();
        ((FixListComboModel)this.getModel()).setSelectedItem(selObj);
        super.firePopupMenuWillBecomeVisible();
    }

    private void $init$() {
        this._fixListBelow = true;
    }

    static JList ra$_fixList(JFixListCombo jFixListCombo) {
        return jFixListCombo._fixList;
    }

    static JList ra$_scrollList(JFixListCombo jFixListCombo) {
        return jFixListCombo._scrollList;
    }

    private class ListMouseListener
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent e) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            list.setSelectedIndex(index);
        }

        private ListMouseListener() {
        }

        ListMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ListClickListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (e.getSource() == JFixListCombo.ra$_fixList(JFixListCombo.this)) {
                index += JFixListCombo.ra$_scrollList(JFixListCombo.this).getModel().getSize();
            }
            JFixListCombo.this.setSelectedIndex(index);
            JFixListCombo.this.hidePopup();
        }

        private ListClickListener() {
        }

        ListClickListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SingleListSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == JFixListCombo.ra$_scrollList(JFixListCombo.this) && JFixListCombo.ra$_scrollList(JFixListCombo.this).getSelectedIndex() >= 0) {
                JFixListCombo.ra$_fixList(JFixListCombo.this).clearSelection();
            }
            if (e.getSource() == JFixListCombo.ra$_fixList(JFixListCombo.this) && JFixListCombo.ra$_fixList(JFixListCombo.this).getSelectedIndex() >= 0) {
                JFixListCombo.ra$_scrollList(JFixListCombo.this).clearSelection();
            }
        }

        private SingleListSelectionListener() {
        }

        SingleListSelectionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

