/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.combo.JCustomComboBox;
import oracle.javatools.ui.combo.TreeComboModel;
import oracle.javatools.ui.combo.TreeComboRenderer;

public class JTreeCombo
extends JCustomComboBox {
    private JTree _tree;
    private JScrollPane _sp;

    public JTreeCombo() {
        this._init();
    }

    public JTreeCombo(TreeModel treeModel) {
        this._init();
        this.setModel(treeModel);
    }

    public void setModel(TreeModel treeModel) {
        TreeComboModel treeComboModel = new TreeComboModel(this._tree);
        this._tree.setModel(treeModel);
        super.setModel(treeComboModel);
        this.expandAll();
    }

    public void setTreeComboRenderer(TreeComboRenderer renderer) {
        this._tree.setCellRenderer(renderer);
        this.setRenderer(renderer);
    }

    public void setRootVisible(boolean visible) {
        this._tree.setRootVisible(visible);
    }

    private void expandAll() {
        int i = 0;
        while (i < this._tree.getRowCount()) {
            this._tree.expandRow(i);
            ++i;
        }
    }

    public void firePopupMenuWillBecomeVisible() {
        Dimension d = this._sp.getViewport().getPreferredSize();
        Dimension newD = new Dimension(this.getWidth() - this._sp.getVerticalScrollBar().getWidth() - 6, Math.min(d.height, this._tree.getRowHeight() * 8));
        this._sp.getViewport().setPreferredSize(newD);
        Object selObj = this.getSelectedItem();
        ((TreeComboModel)this.getModel()).setSelectedItem(selObj);
        super.firePopupMenuWillBecomeVisible();
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object lastPathComponent;
        super.firePopupMenuWillBecomeInvisible();
        TreeComboModel comboModel = (TreeComboModel)this.getModel();
        TreePath path = this._tree.getSelectionPath();
        if (path != null && (lastPathComponent = path.getLastPathComponent()) != comboModel.getSelectedItem()) {
            comboModel.setSelectedItem(lastPathComponent);
            this.fireActionEvent();
        }
    }

    private void _init() {
        this._tree = new JTree();
        this._tree.addMouseListener(new TreeClickListener(null));
        this._tree.addMouseMotionListener(new TreeMouseListener(null));
        this.addKeyListener(new KeyExpandListener(null));
        this._sp = new JScrollPane(this._tree, 20, 30);
        this.setPopupComponent(this._sp);
    }

    public void updateUI() {
        super.updateUI();
    }

    static JTree ra$_tree(JTreeCombo jTreeCombo) {
        return jTreeCombo._tree;
    }

    private class KeyExpandListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 37) {
                TreePath tp = JTreeCombo.ra$_tree(JTreeCombo.this).getSelectionPath();
                JTreeCombo.ra$_tree(JTreeCombo.this).collapsePath(tp);
            }
            if (e.getKeyCode() == 39) {
                TreePath tp = JTreeCombo.ra$_tree(JTreeCombo.this).getSelectionPath();
                JTreeCombo.ra$_tree(JTreeCombo.this).expandPath(tp);
            }
        }

        private KeyExpandListener() {
        }

        KeyExpandListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TreeMouseListener
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent e) {
            TreePath path = JTreeCombo.ra$_tree(JTreeCombo.this).getPathForLocation(e.getX(), e.getY());
            JTreeCombo.ra$_tree(JTreeCombo.this).setSelectionPath(path);
        }

        private TreeMouseListener() {
        }

        TreeMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TreeClickListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            Object obj;
            TreePath path = JTreeCombo.ra$_tree(JTreeCombo.this).getPathForLocation(e.getX(), e.getY());
            if (path != null && (obj = path.getLastPathComponent()) != null) {
                JTreeCombo.this.setSelectedItem(obj);
                JTreeCombo.this.hidePopup();
            }
        }

        private TreeClickListener() {
        }

        TreeClickListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

