/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.combo.JCustomComboBox;
import oracle.javatools.ui.combo.TreeComboRenderer;
import oracle.javatools.ui.combo.TreeFixListComboModel;

public class JTreeFixListCombo
extends JCustomComboBox {
    private JTree _tree;
    private JList _fixList;
    private JScrollPane _sp;
    private boolean _fixListBelow;

    public JTreeFixListCombo() {
        this.$init$();
        this._init();
    }

    public JTreeFixListCombo(TreeModel treeModel, ListModel fixedModel) {
        this.$init$();
        this._init();
        this.setModel(treeModel, fixedModel);
    }

    public void setModel(TreeModel treeModel, ListModel fixedModel) {
        TreeFixListComboModel tflcModel = new TreeFixListComboModel(this._tree, this._fixList, this._fixListBelow);
        this._tree.setModel(treeModel);
        this._fixList.setModel(fixedModel);
        super.setModel(tflcModel);
        this.expandAll();
    }

    public void setTreeComboRenderer(TreeComboRenderer renderer) {
        this._tree.setCellRenderer(renderer);
        this.setRenderer((ListCellRenderer)renderer);
    }

    public void setRenderer(ListCellRenderer aRenderer) {
        super.setRenderer(aRenderer);
        if (this._fixList != null) {
            this._fixList.setCellRenderer(aRenderer);
        }
    }

    private void expandAll() {
        int i = 0;
        while (i < this._tree.getRowCount()) {
            this._tree.expandRow(i);
            ++i;
        }
    }

    public void firePopupMenuWillBecomeVisible() {
        Dimension d = this._sp.getViewport().getPreferredSize();
        Dimension newD = new Dimension(this.getWidth() - this._sp.getVerticalScrollBar().getWidth() - 6, Math.min(d.height, this._tree.getRowHeight() * 8));
        this._sp.getViewport().setPreferredSize(newD);
        Object selObj = this.getSelectedItem();
        ((TreeFixListComboModel)this.getModel()).setSelectedItem(selObj);
        super.firePopupMenuWillBecomeVisible();
    }

    private void _init() {
        this._tree = new JTree();
        this._fixList = new JList();
        this._tree.addMouseListener(new TreeClickListener(null));
        this._tree.addMouseMotionListener(new TreeMouseListener(null));
        this._fixList.addMouseListener(new ListClickListener(null));
        this._fixList.addMouseMotionListener(new ListMouseListener(null));
        this.addKeyListener(new KeyExpandListener(null));
        JPanel panel = new JPanel(new BorderLayout());
        this._sp = new JScrollPane(this._tree, 20, 30);
        this.setPopupComponent(panel);
        this._addListsToPopup();
        ListMouseListener lml = new ListMouseListener(null);
        this._fixList.addMouseMotionListener(lml);
        ListClickListener lcl = new ListClickListener(null);
        this._fixList.addMouseListener(lcl);
        SingleSelectionListener slsl = new SingleSelectionListener(null);
        this._fixList.addListSelectionListener(slsl);
        this._tree.addTreeSelectionListener(slsl);
    }

    private void _addListsToPopup() {
        JComponent panel = this.getPopupComponent();
        if (this._fixListBelow) {
            panel.add((Component)this._sp, "North");
            panel.add((Component)this._fixList, "South");
        } else {
            panel.add((Component)this._fixList, "North");
            panel.add((Component)this._sp, "South");
        }
    }

    public boolean getFixListBelow() {
        return this._fixListBelow;
    }

    public void setFixListBelow(boolean fixListBelow) {
        if (fixListBelow == this._fixListBelow) {
            return;
        }
        this._fixListBelow = fixListBelow;
        this.getPopupComponent().removeAll();
        this._addListsToPopup();
        ((TreeFixListComboModel)this.getModel()).setFixListBelow(fixListBelow);
    }

    private void $init$() {
        this._fixListBelow = true;
    }

    static JTree ra$_tree(JTreeFixListCombo jTreeFixListCombo) {
        return jTreeFixListCombo._tree;
    }

    static boolean ra$_fixListBelow(JTreeFixListCombo jTreeFixListCombo) {
        return jTreeFixListCombo._fixListBelow;
    }

    static JList ra$_fixList(JTreeFixListCombo jTreeFixListCombo) {
        return jTreeFixListCombo._fixList;
    }

    private class KeyExpandListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 37) {
                TreePath tp = JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).getSelectionPath();
                JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).collapsePath(tp);
            }
            if (e.getKeyCode() == 39) {
                TreePath tp = JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).getSelectionPath();
                JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).expandPath(tp);
            }
        }

        private KeyExpandListener() {
        }

        KeyExpandListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TreeMouseListener
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent e) {
            TreePath path = JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).getPathForLocation(e.getX(), e.getY());
            JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).setSelectionPath(path);
        }

        private TreeMouseListener() {
        }

        TreeMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class TreeClickListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            Object obj;
            TreePath path = JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).getPathForLocation(e.getX(), e.getY());
            if (path != null && (obj = path.getLastPathComponent()) != null) {
                JTreeFixListCombo.this.setSelectedItem(obj);
                JTreeFixListCombo.this.hidePopup();
            }
        }

        private TreeClickListener() {
        }

        TreeClickListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ListMouseListener
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent e) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            list.setSelectedIndex(index);
        }

        private ListMouseListener() {
        }

        ListMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ListClickListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (JTreeFixListCombo.ra$_fixListBelow(JTreeFixListCombo.this)) {
                index += JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).getRowCount();
            }
            JTreeFixListCombo.this.setSelectedIndex(index);
            JTreeFixListCombo.this.hidePopup();
        }

        private ListClickListener() {
        }

        ListClickListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SingleSelectionListener
    implements ListSelectionListener,
    TreeSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (JTreeFixListCombo.ra$_fixList(JTreeFixListCombo.this).getSelectedIndex() >= 0) {
                JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).clearSelection();
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (JTreeFixListCombo.ra$_tree(JTreeFixListCombo.this).getSelectionPath() != null) {
                JTreeFixListCombo.ra$_fixList(JTreeFixListCombo.this).clearSelection();
            }
        }

        private SingleSelectionListener() {
        }

        SingleSelectionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

