/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreePath;

public class TreeFixListComboModel
implements ComboBoxModel {
    private Object _selectedObject;
    private JTree _tree;
    private JList _fixList;
    private boolean _fixListBelow;

    public TreeFixListComboModel(JTree tree, JList fixList, boolean fixListBelow) {
        this._tree = tree;
        this._fixList = fixList;
        this._fixListBelow = fixListBelow;
    }

    public void setSelectedItem(Object anItem) {
        Object treeSelObj;
        this._selectedObject = anItem;
        TreePath selPath = this._tree.getSelectionPath();
        if (selPath != null && (treeSelObj = selPath.getLastPathComponent()) != null && treeSelObj == anItem) {
            return;
        }
        TreePath newSelPath = this.getTreePath(anItem);
        this._tree.setSelectionPath(newSelPath);
        this._tree.scrollPathToVisible(newSelPath);
        this._fixList.setSelectedValue(anItem, true);
    }

    public TreePath getTreePath(Object obj) {
        return this._findObject(obj, this._tree.getModel().getRoot(), new TreePath(this._tree.getModel().getRoot()));
    }

    private TreePath _findObject(Object findObj, Object node, TreePath pathToNode) {
        if (findObj == node) {
            return pathToNode;
        }
        int i = 0;
        while (i < this._tree.getModel().getChildCount(node)) {
            TreePath childPath;
            Object childNode = this._tree.getModel().getChild(node, i);
            TreePath tp = this._findObject(findObj, childNode, childPath = pathToNode.pathByAddingChild(childNode));
            if (tp != null) {
                return tp;
            }
            ++i;
        }
        return null;
    }

    public Object getSelectedItem() {
        return this._selectedObject;
    }

    public int getSize() {
        return this._tree.getRowCount() + this._fixList.getModel().getSize();
    }

    public Object getElementAt(int index) {
        int visibleTreeSize = this._tree.getRowCount();
        if (this._fixListBelow) {
            if (index < visibleTreeSize) {
                TreePath path = this._tree.getPathForRow(index);
                return path == null ? null : path.getLastPathComponent();
            }
            return this._fixList.getModel().getElementAt(index - visibleTreeSize);
        }
        int fixSize = this._fixList.getModel().getSize();
        if (index < fixSize) {
            return this._fixList.getModel().getElementAt(index);
        }
        TreePath path = this._tree.getPathForRow(index - fixSize);
        return path == null ? null : path.getLastPathComponent();
    }

    public boolean getFixListBelow() {
        return this._fixListBelow;
    }

    public void setFixListBelow(boolean fixListBelow) {
        if (fixListBelow == this._fixListBelow) {
            return;
        }
        this._fixListBelow = fixListBelow;
    }

    public void addListDataListener(ListDataListener l) {
    }

    public void removeListDataListener(ListDataListener l) {
    }
}

