/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.text.JTextComponent;
import oracle.javatools.ui.ghost.GhostButtonUI;
import oracle.javatools.ui.ghost.GhostScrollBarUI;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentConverter {
    public static void convertToGhost(JComponent component, UIConstants.Look look) {
        HashMap<String, Object> props = null;
        props = ComponentConverter.getLook(look);
        ComponentConverter.visit(component, props, look);
    }

    private static HashMap<String, Object> getLook(UIConstants.Look look) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("Foreground", UIConstants.getColor("ghost.text.foreground", look));
        props.put("Background", UIConstants.getColor("ghost.transparent", look));
        props.put("BackgroundNonSelectionColor", UIConstants.getColor("ghost.transparent", look));
        props.put("BackgroundSelectionColor", UIConstants.getColor("ghost.selection.background", look));
        props.put("textSelectionColor", UIConstants.getColor("ghost.selection.text", look));
        props.put("textNonSelectionColor", UIConstants.getColor("ghost.text.foreground", look));
        props.put("selectionColor", UIConstants.getColor("ghost.selection.background", look));
        props.put("selectedTextColor", UIConstants.getColor("ghost.selection.text", look));
        props.put("caretColor", UIConstants.getColor("ghost.caret.foreground", look));
        props.put("Opaque", Boolean.FALSE);
        return props;
    }

    private static void visit(JComponent c, Map<String, Object> props, UIConstants.Look look) {
        Object vetoAllProp = c.getClientProperty(UIConstants.VETO_HIERARCHY_CONVERSION);
        if (vetoAllProp != null && vetoAllProp == Boolean.TRUE) {
            return;
        }
        Object vetoProp = c.getClientProperty(UIConstants.VETO_CONVERSION);
        if (vetoProp == null || vetoProp != Boolean.TRUE) {
            c.putClientProperty(UIConstants.GHOST_LOOK, (Object)look);
            ComponentConverter.setProperties(c, props);
            ComponentConverter.convertSpecialCases(props, look, c);
        }
        Component[] componentArray = c.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component comp = componentArray[n];
            if (comp instanceof JComponent) {
                ComponentConverter.visit((JComponent)comp, props, look);
                vetoProp = ((JComponent)comp).getClientProperty(UIConstants.VETO_CONVERSION);
                if (vetoProp == null || vetoProp != Boolean.TRUE) {
                    ComponentConverter.convertSpecialCases(props, look, comp);
                }
            }
            ++n;
        }
    }

    private static void convertSpecialCases(Map<String, Object> props, UIConstants.Look look, Component comp) {
        if (comp instanceof JLabel && ((JComponent)comp).getClientProperty(UIConstants.INSTRUCTION_LABEL) == Boolean.TRUE) {
            ((JLabel)comp).setForeground(UIConstants.getColor("ghost.instruction.foreground", look));
        } else if (comp instanceof JTree) {
            JTree tree = (JTree)comp;
            JComponent renderer = (JComponent)((Object)tree.getCellRenderer());
            ComponentConverter.setProperties(renderer, props);
        } else if (comp instanceof JList) {
            JList list = (JList)comp;
            JComponent renderer = (JComponent)((Object)list.getCellRenderer());
            ComponentConverter.setProperties(renderer, props);
        } else if (comp instanceof JTextComponent) {
            JTextComponent textComp = (JTextComponent)comp;
            textComp.setBackground(UIManager.getColor("TextArea.background"));
            textComp.setOpaque(true);
        } else if (comp instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)comp;
            sp.getVerticalScrollBar().setUI((ScrollBarUI)GhostScrollBarUI.createUI(sp.getVerticalScrollBar()));
            sp.getHorizontalScrollBar().setUI((ScrollBarUI)GhostScrollBarUI.createUI(sp.getHorizontalScrollBar()));
        } else if (comp instanceof JButton && !(comp.getParent() instanceof JToolBar)) {
            JButton button = (JButton)comp;
            button.setBorder(null);
            button.setBorderPainted(false);
            button.setUI((ButtonUI)GhostButtonUI.createUI(button));
            if (button.getIcon() != null && (button.getText() == null || "".equals(button.getText()))) {
                button.setRolloverEnabled(true);
                button.putClientProperty(UIConstants.ICON_BUTTON, Boolean.TRUE);
            }
        } else if (comp instanceof AbstractButton && comp.getParent() instanceof JToolBar) {
            AbstractButton button = (AbstractButton)comp;
            button.setBackground(Color.DARK_GRAY);
            button.setBorderPainted(true);
            button.setContentAreaFilled(true);
        }
    }

    private static void setProperties(JComponent c, Map<String, Object> props) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(c.getClass());
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            for (String key : props.keySet()) {
                PropertyDescriptor[] propertyDescriptorArray = pds;
                int n = 0;
                while (n < propertyDescriptorArray.length) {
                    PropertyDescriptor pd = propertyDescriptorArray[n];
                    if (pd.getName().equalsIgnoreCase(key)) {
                        Object value = props.get(key);
                        try {
                            pd.getWriteMethod().invoke((Object)c, value);
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n;
                }
            }
        }
        catch (IntrospectionException e) {
            Exceptions.swallow(e);
        }
    }
}

