/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;

public class GhostList
implements ItemSelectable {
    private JList list;
    private GhostPointingPalette gp;
    private List<ItemListener> itemListeners;

    private void $init$() {
        this.itemListeners = new ArrayList<ItemListener>();
    }

    public GhostList(Object[] items) {
        this.$init$();
        this.init(items);
    }

    private void init(Object[] items) {
        this.list = new JList<Object>(items);
        this.list.setVisibleRowCount(Math.min(20, items.length));
        this.list.addMouseMotionListener(new 1());
        this.list.addMouseListener(new 2());
        this.list.addKeyListener(new 3());
    }

    public void setVisible(JLayeredPane layeredPane, JComponent comp, Rectangle rect, boolean visible) {
        if (visible) {
            this.gp = new GhostPointingPalette();
            this.gp.setLayout(new BorderLayout(10, 10));
            JScrollPane sp = new JScrollPane(this.list);
            sp.setBorder(null);
            this.gp.add(sp);
            this.gp.setHideOnLoseFocus(true);
            this.gp.setCloseVisible(false);
            this.gp.setMovable(false);
            this.gp.setResizable(false);
            this.gp.setPointing(comp, rect);
            this.gp.pack();
            this.gp.setLook(UIConstants.Look.LIGHT);
            Dimension size = this.gp.getSize();
            Rectangle r = SwingUtilities.convertRectangle(comp, rect, layeredPane);
            Point location = new Point(r.x + rect.width / 2 - 20, r.y - size.height);
            this.gp.setLocation(location);
            this.gp.show(layeredPane, false, true);
        } else if (this.gp != null) {
            this.gp.fadeInOut(false);
            this.gp = null;
        }
    }

    private void select(int row) {
        this.gp.fadeInOut(false);
        this.gp = null;
        ItemEvent ie = new ItemEvent(this, 701, this.list.getModel().getElementAt(row), 1);
        List listClone = (List)((ArrayList)this.itemListeners).clone();
        for (ItemListener l : listClone) {
            l.itemStateChanged(ie);
        }
    }

    public void addItemListener(ItemListener l) {
        if (!this.itemListeners.contains(l)) {
            this.itemListeners.add(l);
        }
    }

    public void removeItemListener(ItemListener l) {
        if (this.itemListeners.contains(l)) {
            this.itemListeners.remove(l);
        }
    }

    public Object[] getSelectedObjects() {
        return this.list.getSelectedValues();
    }

    static JList ra$list(GhostList ghostList) {
        return ghostList.list;
    }

    static void mav$select(GhostList ghostList, int n) {
        ghostList.select(n);
    }

    final class 1
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent me) {
            int row = GhostList.ra$list(GhostList.this).locationToIndex(me.getPoint());
            if (GhostList.ra$list(GhostList.this).getCellBounds(row, row).contains(me.getPoint()) && GhostList.ra$list(GhostList.this).getSelectedIndex() != row) {
                GhostList.ra$list(GhostList.this).setSelectedIndex(row);
            }
        }
    }

    final class 2
    extends MouseAdapter {
        public void mouseClicked(MouseEvent me) {
            int row = GhostList.ra$list(GhostList.this).locationToIndex(me.getPoint());
            if (GhostList.ra$list(GhostList.this).getCellBounds(row, row).contains(me.getPoint())) {
                GhostList.mav$select(GhostList.this, row);
            }
        }
    }

    final class 3
    extends KeyAdapter {
        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 10 && GhostList.ra$list(GhostList.this).getSelectedIndex() != -1) {
                GhostList.mav$select(GhostList.this, GhostList.ra$list(GhostList.this).getSelectedIndex());
            }
        }
    }
}

