/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;
import oracle.javatools.ui.ghost.ComponentConverter;
import oracle.javatools.ui.ghost.GhostBorder;
import oracle.javatools.ui.ghost.UIConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GhostPalette
extends JLayeredPane {
    protected float fadeAmount;
    private Timer aniTimer;
    private static int FADE_DURATION = 125;
    private static int FADE_FRAMES = 10;
    private final ResizeL resizeListener;
    private final CloseButton closeButton;
    private final FocusTracker focusTracker;
    private boolean redirectToContent;
    private String titleText;
    private static String CONTROL_KEY = "CONTROL_KEY";
    private boolean hideOnLoseFocus;
    private boolean receivesFocus;
    private boolean isMovable;
    private boolean isResizable;
    private OwningL owningL;
    private long timeShownAt;
    protected final JPanel container;
    protected UIConstants.Look look;
    private JComponent owningComp;
    private List<JComponent> clearList;

    private void $init$() {
        this.fadeAmount = 0.0f;
        this.resizeListener = new ResizeL(null);
        this.closeButton = new CloseButton();
        this.focusTracker = new FocusTracker(null);
        this.redirectToContent = false;
        this.titleText = null;
        this.hideOnLoseFocus = true;
        this.receivesFocus = true;
        this.isMovable = true;
        this.isResizable = true;
        this.owningL = new OwningL(null);
        this.timeShownAt = -1;
        this.container = new JPanel(new BorderLayout(0, 2));
        this.look = UIConstants.Look.LIGHT;
        this.clearList = new ArrayList<JComponent>();
    }

    public GhostPalette() {
        this.$init$();
        this.init(null);
    }

    public GhostPalette(String title) {
        this.$init$();
        this.init(title);
    }

    public GhostPalette(JComponent owningComponent) {
        this.$init$();
        this.init(null);
        this.setOwningComponent(owningComponent);
    }

    private void init(String title) {
        this.setLayout(null);
        this.setOpaque(false);
        this.titleText = title;
        this.setBorder(new GhostBorder());
        this.container.setOpaque(false);
        this.closeButton.setSize(20, 20);
        this.add((Component)this.closeButton, new Integer(JLayeredPane.POPUP_LAYER - 10));
        this.container.setFocusCycleRoot(true);
        this.add(this.container);
        this.addMouseListener(this.resizeListener);
        this.addMouseMotionListener(this.resizeListener);
        this.addHierarchyListener(new 1());
        this.setBackground(UIConstants.getColor("ghost.panel.background", UIConstants.Look.LIGHT));
        this.closeButton.addMouseListener(new 2());
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, true);
        String ESCAPE_KEY = "ESCAPE_KEY";
        this.container.getInputMap(2).put(escape, ESCAPE_KEY);
        this.container.getActionMap().put(ESCAPE_KEY, new 3());
        this.redirectToContent = true;
    }

    public void allowTemporaryHide() {
        KeyStroke hide = KeyStroke.getKeyStroke(18, 512);
        KeyStroke hideCtrl = KeyStroke.getKeyStroke(18, 640);
        String HIDE_KEY = "HIDE_KEY";
        this.container.getInputMap(2).put(hide, HIDE_KEY);
        this.container.getInputMap(2).put(hideCtrl, HIDE_KEY);
        this.container.getActionMap().put(HIDE_KEY, new 4());
        KeyStroke showUp = KeyStroke.getKeyStroke(18, 0, true);
        KeyStroke showUpShift = KeyStroke.getKeyStroke(18, 64, true);
        KeyStroke showUpCtrl = KeyStroke.getKeyStroke(18, 128, true);
        String SHOW_UP_KEY = "SHOW_UP_KEY";
        this.container.getInputMap(2).put(showUp, SHOW_UP_KEY);
        this.container.getInputMap(2).put(showUpShift, SHOW_UP_KEY);
        this.container.getInputMap(2).put(showUpCtrl, SHOW_UP_KEY);
        this.container.getActionMap().put(SHOW_UP_KEY, new 5());
    }

    public JComponent getOwningComponent() {
        return this.owningComp;
    }

    public void setOwningComponent(JComponent owningComponent) {
        if (this.owningComp != null) {
            this.owningComp.removeComponentListener(this.owningL);
            this.owningComp.removeAncestorListener(this.owningL);
        }
        this.owningComp = owningComponent;
        if (this.owningComp != null) {
            this.owningComp.addComponentListener(this.owningL);
            this.owningComp.addAncestorListener(this.owningL);
        }
    }

    public void setHideOnControlUp(boolean hide) {
        KeyStroke control = KeyStroke.getKeyStroke(17, 0, true);
        if (hide) {
            this.container.getInputMap(2).put(control, CONTROL_KEY);
            this.container.getActionMap().put(CONTROL_KEY, new 6());
        } else {
            this.container.getInputMap(2).remove(control);
            this.container.getActionMap().remove(CONTROL_KEY);
        }
    }

    public void hidePanel() {
        this.setVisible(false);
        this.dispose();
    }

    public void registerTransparentComponent(JComponent comp) {
        if (!this.clearList.contains(comp)) {
            this.clearList.add(comp);
        }
    }

    public void unregisterTransparentComponent(JComponent comp) {
        this.clearList.remove(comp);
    }

    List<JComponent> getTransparentComponents() {
        return new ArrayList<JComponent>(this.clearList);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        Border b = this.getBorder();
        if (b != null) {
            Insets i = b.getBorderInsets(this);
            this.container.setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
        } else {
            this.container.setBounds(0, 0, w, h);
        }
    }

    public void setCloseVisible(boolean visible) {
        this.closeButton.setVisible(visible);
    }

    public boolean isCloseVisible() {
        return this.closeButton.isVisible();
    }

    public void setContentFocusable(boolean focusable) {
        this.container.setFocusCycleRoot(focusable);
    }

    private void positionCloseButton() {
        int x = this.getWidth() - 19 - 6;
        int y = 6;
        this.closeButton.setLocation(x, y);
    }

    private void updateChildUIs() {
        ComponentConverter.convertToGhost(this.container, this.look);
    }

    public void setLook(UIConstants.Look look) {
        this.look = look;
        this.container.setBackground(UIConstants.getColor("ghost.panel.background", look));
    }

    public UIConstants.Look getLook() {
        return this.look;
    }

    public JComponent getContentPanel() {
        return this.container;
    }

    public void show(JLayeredPane layeredPane, boolean positionInLayer, boolean fadeIn) {
        this.timeShownAt = System.currentTimeMillis();
        this.positionPanel(layeredPane, positionInLayer);
        this.makeVisible(fadeIn);
    }

    protected void positionPanel(JLayeredPane layeredPane, boolean positionInLayer) {
        int x;
        if (positionInLayer) {
            this.positionInLayer(layeredPane);
        }
        int fh = layeredPane.getHeight();
        int fw = layeredPane.getWidth();
        int y = this.getY();
        if (y + this.getHeight() > fh) {
            y = Math.max(0, fh - this.getHeight());
        }
        if ((x = this.getX()) + this.getWidth() > fw) {
            x = Math.max(0, fw - this.getWidth());
        }
        if (y != this.getY() || x != this.getX()) {
            this.setLocation(x, y);
        }
        layeredPane.add((Component)this, new Integer(JLayeredPane.POPUP_LAYER - 3));
        this.positionCloseButton();
    }

    protected void makeVisible(boolean fadeIn) {
        if (fadeIn) {
            this.fadeInOut(true);
        } else {
            this.fadeAmount = 1.0f;
        }
        if (this.receivesFocus) {
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            focusManager.addPropertyChangeListener(this.focusTracker);
            this.container.transferFocus();
        }
    }

    private void positionInLayer(JLayeredPane layeredPane) {
        int x = layeredPane.getWidth() / 2 - this.getWidth() / 2;
        int y = 2 * (layeredPane.getHeight() / 5) - this.getHeight() / 2;
        y = Math.max(0, y);
        x = Math.max(0, x);
        this.setLocation(x, y);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(this.focusTracker);
    }

    protected void dispose() {
        Container parent;
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(this.focusTracker);
        if (this.owningComp != null) {
            this.owningComp.removeComponentListener(this.owningL);
            this.owningComp.removeAncestorListener(this.owningL);
            this.owningComp = null;
        }
        if ((parent = this.getParent()) != null) {
            parent.remove(this);
            parent.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public void fadeInOut(boolean visible) {
        int fadeStep = FADE_DURATION / FADE_FRAMES;
        long initialTime = System.currentTimeMillis();
        if (this.aniTimer == null) {
            this.aniTimer = new Timer(fadeStep, new 7(this, initialTime, visible));
            this.aniTimer.setCoalesce(true);
            if (!this.aniTimer.isRunning()) {
                this.aniTimer.restart();
            }
        }
    }

    protected void repaintVisible() {
        this.repaint();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.redirectToContent) {
            this.container.add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    @Override
    public void remove(Component comp) {
        if (this.redirectToContent) {
            this.container.remove(comp);
        } else {
            super.remove(comp);
        }
    }

    public void pack() {
        Dimension newSize = new Dimension(this.container.getPreferredSize().width, this.container.getPreferredSize().height);
        Insets borderInsets = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        newSize.height += borderInsets.top + borderInsets.bottom;
        newSize.width += borderInsets.left + borderInsets.right;
        this.setSize(newSize.width, newSize.height);
        this.setPreferredSize(new Dimension(newSize.width, newSize.height));
        this.validate();
    }

    @Override
    public void setLayout(LayoutManager manager) {
        if (this.redirectToContent) {
            this.container.setLayout(manager);
        } else {
            super.setLayout(manager);
        }
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (this.redirectToContent) {
            this.container.setVisible(true);
            this.container.add(comp, constraints);
        } else {
            super.add(comp, constraints);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.fadeAmount >= 0.0f && this.fadeAmount < 1.0f) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.getInstance(3, this.fadeAmount));
        }
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    public void setTitle(String titleText) {
        this.titleText = titleText;
    }

    public String getTitle() {
        return this.titleText;
    }

    float getFadeAmount() {
        return this.fadeAmount;
    }

    public void setReceivesFocus(boolean receivesFocus) {
        this.receivesFocus = receivesFocus;
    }

    public void setHideOnLoseFocus(boolean newhideOnLoseFocus) {
        this.hideOnLoseFocus = newhideOnLoseFocus;
    }

    public boolean isHideOnLoseFocus() {
        return this.hideOnLoseFocus;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setResizable(boolean isResizable) {
        this.isResizable = isResizable;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    static void mav$positionCloseButton(GhostPalette ghostPalette) {
        ghostPalette.positionCloseButton();
    }

    static boolean ra$isResizable(GhostPalette ghostPalette) {
        return ghostPalette.isResizable;
    }

    static boolean ra$isMovable(GhostPalette ghostPalette) {
        return ghostPalette.isMovable;
    }

    static boolean ra$hideOnLoseFocus(GhostPalette ghostPalette) {
        return ghostPalette.hideOnLoseFocus;
    }

    static FocusTracker ra$focusTracker(GhostPalette ghostPalette) {
        return ghostPalette.focusTracker;
    }

    static int ra$FADE_DURATION() {
        return FADE_DURATION;
    }

    static Timer ra$aniTimer(GhostPalette ghostPalette) {
        return ghostPalette.aniTimer;
    }

    static void wa$aniTimer(GhostPalette ghostPalette, Timer timer) {
        ghostPalette.aniTimer = timer;
    }

    static void mav$updateChildUIs(GhostPalette ghostPalette) {
        ghostPalette.updateChildUIs();
    }

    final class 1
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & (long)4) > 0L && GhostPalette.this.isShowing()) {
                GhostPalette.mav$updateChildUIs(GhostPalette.this);
            }
        }
    }

    final class 2
    extends MouseAdapter {
        private boolean possibleClick;

        private void $init$() {
            this.possibleClick = false;
        }

        public void mouseClicked(MouseEvent e) {
            GhostPalette.this.setVisible(false);
        }

        public void mousePressed(MouseEvent e) {
            this.possibleClick = true;
        }

        public void mouseExited(MouseEvent e) {
            this.possibleClick = false;
        }

        public void mouseReleased(MouseEvent e) {
            if (this.possibleClick) {
                GhostPalette.this.setVisible(false);
            }
            this.possibleClick = false;
        }

        public 2() {
            this.$init$();
        }
    }

    final class 3
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            GhostPalette.this.hidePanel();
        }
    }

    final class 4
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            GhostPalette.this.fadeAmount = 0.12f;
            GhostPalette.this.repaintVisible();
        }
    }

    final class 5
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            GhostPalette.this.fadeAmount = 1.0f;
            GhostPalette.this.repaintVisible();
        }
    }

    final class 6
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            GhostPalette.this.hidePanel();
        }
    }

    final class 7
    implements ActionListener {
        private final /* synthetic */ long v$initialTime;
        private final /* synthetic */ boolean v$visible;
        final /* synthetic */ GhostPalette this$0;

        public void actionPerformed(ActionEvent ae) {
            long elapsed = System.currentTimeMillis() - this.v$initialTime;
            this.this$0.fadeAmount = (float)elapsed / (float)GhostPalette.ra$FADE_DURATION();
            if (!this.v$visible) {
                this.this$0.fadeAmount = 1.0f - this.this$0.fadeAmount;
            }
            if (this.this$0.fadeAmount <= 0.0f) {
                this.this$0.fadeAmount = 0.0f;
                if (this.this$0.isShowing()) {
                    this.this$0.setVisible(false);
                    ((JLayeredPane)this.this$0.getParent()).paintImmediately(this.this$0.getBounds());
                    this.this$0.dispose();
                }
                GhostPalette.ra$aniTimer(this.this$0).stop();
                GhostPalette.wa$aniTimer(this.this$0, null);
            } else if (this.this$0.fadeAmount >= 1.0f) {
                this.this$0.fadeAmount = 1.0f;
                GhostPalette.ra$aniTimer(this.this$0).stop();
                GhostPalette.wa$aniTimer(this.this$0, null);
            }
            if (this.this$0.isShowing()) {
                this.this$0.repaintVisible();
            }
        }

        public 7(GhostPalette ghostPalette, long l, boolean bl) {
            this.v$visible = bl;
            this.v$initialTime = l;
            this.this$0 = ghostPalette;
        }
    }

    private class ResizeL
    extends MouseInputAdapter {
        private int resizeEdge;
        private Point dragPoint;
        private Point loc;

        private void $init$() {
            this.resizeEdge = -1;
        }

        public void mouseMoved(MouseEvent me) {
            int x = me.getX();
            int y = me.getY();
            int activeArea = 6;
            int rightEdge = GhostPalette.this.getWidth() - activeArea - 6;
            int footerOuter = GhostPalette.this.getHeight() - 6;
            int topOuter = 0;
            int topInner = topOuter + activeArea;
            int footerInner = footerOuter - activeArea;
            if (GhostPalette.ra$isResizable(GhostPalette.this) && (x < activeArea * 2 && y > topOuter && y < topInner || x < activeArea && y > topOuter && y < topInner + activeArea)) {
                this.resizeEdge = 8;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(6));
            } else if (GhostPalette.ra$isResizable(GhostPalette.this) && (x < activeArea * 2 && y > footerInner && y < footerOuter || x < activeArea && y > footerInner - activeArea && y < footerOuter)) {
                this.resizeEdge = 6;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(4));
            } else if (GhostPalette.ra$isResizable(GhostPalette.this) && (x > rightEdge - activeArea && x < GhostPalette.this.getWidth() - 6 && y > topOuter && y < topInner || x > rightEdge && y > topOuter && y < topInner + activeArea)) {
                this.resizeEdge = 2;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(7));
            } else if (GhostPalette.ra$isResizable(GhostPalette.this) && (x > rightEdge - activeArea * 2 && x < GhostPalette.this.getWidth() - 6 && y > footerInner && y < footerOuter || x > rightEdge && y > footerInner - activeArea && y < footerOuter)) {
                this.resizeEdge = 4;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(5));
            } else if (GhostPalette.ra$isResizable(GhostPalette.this) && y > topOuter && y < topInner) {
                this.resizeEdge = 1;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(8));
            } else if (GhostPalette.ra$isResizable(GhostPalette.this) && y > footerInner && y < footerOuter) {
                this.resizeEdge = 5;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(9));
            } else if (GhostPalette.ra$isResizable(GhostPalette.this) && x < activeArea && y < footerInner && y > topInner) {
                this.resizeEdge = 7;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (GhostPalette.ra$isResizable(GhostPalette.this) && x > rightEdge && x < GhostPalette.this.getWidth() - 6 && y < footerInner && y > topInner) {
                this.resizeEdge = 3;
                GhostPalette.this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (GhostPalette.ra$isMovable(GhostPalette.this)) {
                this.resizeEdge = 0;
                GhostPalette.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseExited(MouseEvent me) {
            if (this.loc == null) {
                this.resizeEdge = -1;
                GhostPalette.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mousePressed(MouseEvent me) {
            if (me.getButton() == 1) {
                Point mp = me.getPoint();
                SwingUtilities.convertPointToScreen(mp, GhostPalette.this);
                this.loc = GhostPalette.this.getLocationOnScreen();
                this.dragPoint = new Point(mp.x - this.loc.x, mp.y - this.loc.y);
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.getButton() == 1) {
                this.loc = null;
                this.dragPoint = null;
            }
        }

        public void mouseDragged(MouseEvent me) {
            Point mp = me.getPoint();
            SwingUtilities.convertPointToScreen(mp, GhostPalette.this);
            if (this.loc == null) {
                return;
            }
            int x = this.loc.x;
            int y = this.loc.y;
            int w = GhostPalette.this.getSize().width;
            int h = GhostPalette.this.getSize().height;
            switch (this.resizeEdge) {
                case 1: {
                    h += this.loc.y - mp.y;
                    this.loc.y = mp.y;
                    break;
                }
                case 8: {
                    h += this.loc.y - mp.y;
                    w += this.loc.x - mp.x;
                    this.loc.y = mp.y;
                    this.loc.x = mp.x;
                    break;
                }
                case 2: {
                    h += this.loc.y - mp.y;
                    w = mp.x - this.loc.x + 6;
                    this.loc.y = mp.y;
                    break;
                }
                case 3: {
                    w = mp.x - this.loc.x + 6;
                    break;
                }
                case 7: {
                    w += this.loc.x - mp.x;
                    this.loc.x = mp.x;
                    break;
                }
                case 4: {
                    w = mp.x - this.loc.x + 6;
                    h = mp.y - this.loc.y + 6;
                    break;
                }
                case 6: {
                    w += this.loc.x - mp.x;
                    h = mp.y - this.loc.y + 6;
                    this.loc.x = mp.x;
                    break;
                }
                case 5: {
                    h = mp.y - this.loc.y + 6;
                    break;
                }
                case 0: {
                    this.loc.y = mp.y - this.dragPoint.y;
                    this.loc.x = mp.x - this.dragPoint.x;
                }
            }
            if (w < GhostPalette.this.getMinimumSize().width) {
                w = GhostPalette.this.getSize().width;
                this.loc.x = x;
            }
            if (w > GhostPalette.this.getMaximumSize().width) {
                w = GhostPalette.this.getSize().width;
                this.loc.x = x;
            }
            if (h < GhostPalette.this.getMinimumSize().height) {
                h = GhostPalette.this.getSize().height;
                this.loc.y = y;
            }
            if (h > GhostPalette.this.getMaximumSize().height) {
                h = GhostPalette.this.getSize().height;
                this.loc.y = y;
            }
            SwingUtilities.convertPointFromScreen(this.loc, GhostPalette.this.getParent());
            Rectangle r = new Rectangle(this.loc.x, this.loc.y, w, h);
            if (this.resizeEdge != 0) {
                r = r.intersection(GhostPalette.this.getParent().getBounds());
            } else {
                r.x = Math.max(0, r.x);
                r.y = Math.max(0, r.y);
                r.x = Math.min(GhostPalette.this.getParent().getWidth() - r.width, r.x);
                r.y = Math.min(GhostPalette.this.getParent().getHeight() - r.height, r.y);
            }
            Rectangle oldR = GhostPalette.this.getBounds();
            GhostPalette.this.setBounds(r);
            GhostPalette.mav$positionCloseButton(GhostPalette.this);
            GhostPalette.this.revalidate();
            this.loc = GhostPalette.this.getLocationOnScreen();
            GhostPalette.this.repaint(oldR);
            GhostPalette.this.repaintVisible();
        }

        private ResizeL() {
            this.$init$();
        }

        ResizeL(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CloseButton
    extends AbstractButton {
        public CloseButton() {
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(24, 24));
            this.setIcon(this.getIcon("close.png"));
        }

        protected void paintComponent(Graphics g) {
            this.getIcon().paintIcon(this, g, 0, 0);
        }

        private ImageIcon getIcon(String filename) {
            try {
                ImageIcon icon;
                URL imageURL = this.getClass().getResource(filename);
                BufferedImage image = ImageIO.read(imageURL);
                ImageIcon imageIcon = icon = new ImageIcon(image);
                return imageIcon;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private class FocusTracker
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            Component c = (Component)e.getNewValue();
            if (e.getNewValue() != null && e.getNewValue() != SwingUtilities.windowForComponent(GhostPalette.this.container) && !SwingUtilities.isDescendingFrom(c, GhostPalette.this.container)) {
                if (GhostPalette.ra$hideOnLoseFocus(GhostPalette.this)) {
                    KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    focusManager.removePropertyChangeListener(GhostPalette.ra$focusTracker(GhostPalette.this));
                    GhostPalette.this.fadeInOut(false);
                } else {
                    GhostPalette.this.fadeAmount = 1.0f;
                }
            }
        }

        private FocusTracker() {
        }

        FocusTracker(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    protected class ContentPanel
    extends JPanel {
        public ContentPanel() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.putClientProperty(UIConstants.VETO_CONVERSION, true);
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            float alpha = 0.93f * GhostPalette.this.fadeAmount;
            g2.setComposite(AlphaComposite.getInstance(3, alpha));
            g.setColor(this.getBackground());
            g.fillRect(0, 0 - this.getInsets().top, this.getWidth(), this.getHeight() + this.getInsets().top + this.getInsets().bottom);
            super.paint(g);
        }
    }

    private class OwningL
    extends ComponentAdapter
    implements AncestorListener {
        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorAdded(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
            GhostPalette.this.dispose();
        }

        public void componentHidden() {
            GhostPalette.this.dispose();
        }

        private OwningL() {
        }

        OwningL(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

