/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.lang.ref.SoftReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;

public class GhostPointingPalette
extends GhostPalette {
    private Rectangle pointingRect;
    private JComponent pointingComp;
    private int pointWidth;
    private PointingCompListener pointingCompListener;
    private PointingLayer pointingLayer;
    private boolean showRect;
    private final SizeListener sizeListener;
    private static int INSET = 4;
    private static int ROUNDEDNESS = 5;

    private void $init$() {
        this.pointWidth = 15;
        this.pointingCompListener = new PointingCompListener(null);
        this.showRect = true;
        this.sizeListener = new SizeListener(null);
    }

    public GhostPointingPalette() {
        this.$init$();
        this.pointingLayer = new PointingLayer(null);
    }

    public void setPointing(JComponent pointComp, Point locationInComponent) {
        this.setPointing(pointComp, new Rectangle(locationInComponent));
    }

    public void setPointing(JComponent pointComp, Rectangle RectangleInComponent) {
        if (this.pointingComp != null) {
            this.pointingComp.removeComponentListener(this.pointingCompListener);
        }
        this.pointingRect = RectangleInComponent;
        this.pointingComp = pointComp;
        this.pointingComp.addComponentListener(this.pointingCompListener);
        this.pointingComp.addAncestorListener(this.pointingCompListener);
        this.setBorder(BorderFactory.createEmptyBorder(INSET, INSET, INSET, INSET));
    }

    public void repaint() {
        if (!this.isShowing()) {
            return;
        }
        super.repaint();
    }

    public void repaint(Rectangle r) {
        if (!this.isShowing()) {
            return;
        }
        super.repaint(r);
        r.grow(10, 10);
        this.pointingLayer.repaint(r);
    }

    public void setShowRectangle(boolean showRect) {
        this.showRect = showRect;
    }

    public void hidePanel() {
        JComponent focusComp = this.pointingComp;
        this.setVisible(false);
        this.dispose();
        if (focusComp != null) {
            focusComp.requestFocus();
        }
        focusComp = null;
    }

    private Point getClosestPoint() {
        if (this.pointingRect == null || this.pointingComp == null || !this.isShowing()) {
            return null;
        }
        int y = this.getLocationOnScreen().y + this.getHeight() / 2 < this.pointingComp.getLocationOnScreen().y + this.pointingRect.y + this.pointingRect.height / 2 ? this.pointingRect.y + 1 : this.pointingRect.y + this.pointingRect.height - 1;
        return new Point(this.pointingRect.x + this.pointingRect.width / 2, y);
    }

    protected void dispose() {
        super.dispose();
        if (this.pointingLayer != null) {
            if (this.pointingLayer.getParent() != null) {
                JComponent pointParent = (JComponent)this.pointingLayer.getParent();
                pointParent.removeComponentListener(this.sizeListener);
                pointParent.remove(this.pointingLayer);
                pointParent.repaint();
            }
            this.pointingLayer = null;
        }
        if (this.pointingComp != null) {
            this.pointingComp.removeComponentListener(this.pointingCompListener);
            this.pointingComp.removeAncestorListener(this.pointingCompListener);
        }
        this.pointingComp = null;
    }

    public void show(JLayeredPane layeredPane, boolean positionInLayer, boolean fadeIn) {
        if (this.pointingRect != null) {
            this.pointingLayer = new PointingLayer(null);
            this.pointingLayer.setLocation(0, 0);
            this.pointingLayer.setPreferredSize(layeredPane.getSize());
            this.pointingLayer.setSize(layeredPane.getSize());
            layeredPane.add((Component)this.pointingLayer, new Integer(JLayeredPane.POPUP_LAYER - 5));
            layeredPane.addComponentListener(this.sizeListener);
        }
        this.positionPanel(layeredPane, positionInLayer);
        this.makeVisible(fadeIn);
    }

    public void repaintVisible() {
        Rectangle r = PointingLayer.mav$createShape(this.pointingLayer, true).getBounds();
        r.grow(12, 12);
        this.pointingLayer.repaint(r);
    }

    static int ra$INSET() {
        return INSET;
    }

    static Point mav$getClosestPoint(GhostPointingPalette ghostPointingPalette) {
        return ghostPointingPalette.getClosestPoint();
    }

    static JComponent ra$pointingComp(GhostPointingPalette ghostPointingPalette) {
        return ghostPointingPalette.pointingComp;
    }

    static int ra$pointWidth(GhostPointingPalette ghostPointingPalette) {
        return ghostPointingPalette.pointWidth;
    }

    static int ra$ROUNDEDNESS() {
        return ROUNDEDNESS;
    }

    static Rectangle ra$pointingRect(GhostPointingPalette ghostPointingPalette) {
        return ghostPointingPalette.pointingRect;
    }

    static boolean ra$showRect(GhostPointingPalette ghostPointingPalette) {
        return ghostPointingPalette.showRect;
    }

    static PointingLayer ra$pointingLayer(GhostPointingPalette ghostPointingPalette) {
        return ghostPointingPalette.pointingLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PointingLayer
    extends JComponent {
        private SoftReference<BufferedImage> imgRef1;
        private SoftReference<BufferedImage> imgRef2;

        private BufferedImage getImage(SoftReference<BufferedImage> imgRef, int w, int h) {
            BufferedImage img = null;
            if (imgRef != null) {
                img = imgRef.get();
            }
            if (img == null || img.getWidth() != w || img.getHeight() != h) {
                img = new BufferedImage(w, h, 2);
                imgRef = new SoftReference<BufferedImage>(img);
            }
            Graphics2D g2 = img.createGraphics();
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, w, h);
            g2.setComposite(AlphaComposite.Src);
            return img;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Shape shape = this.createShape(true);
            if (shape == null) {
                return;
            }
            Rectangle shapeR = shape.getBounds();
            BufferedImage shapeImage = this.getImage(this.imgRef1, shapeR.width + 12, shapeR.height + 12);
            Graphics2D shapeG = shapeImage.createGraphics();
            shapeG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintBoundingBox(g2);
            this.paintShadow(g2, shape, shapeR, shapeImage, shapeG);
            shape = this.createShape(false);
            shapeG.translate(-shapeR.x, -shapeR.y);
            this.paintBackground(shapeG, shape);
            this.paintBoundary(shapeG, shape);
            this.paintClearAreas(shapeG);
            shapeG.translate(shapeR.x, shapeR.y);
            g2.setComposite(AlphaComposite.getInstance(3, 0.93f * GhostPointingPalette.this.fadeAmount));
            g2.drawImage(shapeImage, null, shapeR.x, shapeR.y);
            shapeG.dispose();
            g2.dispose();
        }

        private void paintBoundary(Graphics2D g2, Shape shape) {
            g2.setColor(UIConstants.getColor("ghost.panel.border", GhostPointingPalette.this.look));
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            g2.draw(shape);
        }

        private void paintClearAreas(Graphics2D shapeG) {
            shapeG.setComposite(AlphaComposite.Clear);
            for (JComponent comp : GhostPointingPalette.this.getTransparentComponents()) {
                Rectangle thatR = comp.getBounds();
                Rectangle thisR = SwingUtilities.convertRectangle(comp.getParent(), thatR, this);
                shapeG.fill(thisR);
            }
        }

        private void paintBoundingBox(Graphics2D g2) {
            if (GhostPointingPalette.ra$pointingRect(GhostPointingPalette.this) != null && GhostPointingPalette.ra$showRect(GhostPointingPalette.this)) {
                Stroke s = g2.getStroke();
                g2.setStroke(new BasicStroke(2.0f, 1, 1));
                g2.setColor(UIConstants.getColor("ghost.panel.border", GhostPointingPalette.this.look));
                g2.draw(SwingUtilities.convertRectangle(GhostPointingPalette.ra$pointingComp(GhostPointingPalette.this), GhostPointingPalette.ra$pointingRect(GhostPointingPalette.this), this));
                g2.setStroke(s);
            }
        }

        private void paintBackground(Graphics2D shapeG, Shape shape) {
            shapeG.setColor(UIConstants.getColor("ghost.panel.background", GhostPointingPalette.this.look));
            shapeG.fill(shape);
        }

        private void paintShadow(Graphics2D g2, Shape shape, Rectangle shapeR, BufferedImage shapeImage, Graphics2D shapeG) {
            shapeG.setColor(new Color(0, 0, 0));
            shapeG.translate(-shapeR.x + 6, -shapeR.y + 6);
            shapeG.fill(shape);
            shapeG.translate(shapeR.x - 6, shapeR.y - 6);
            float i = 0.04f;
            float[] elements = new float[]{i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i, i};
            Kernel myKernel = new Kernel(5, 5, elements);
            ConvolveOp simpleBlur = new ConvolveOp(myKernel);
            BufferedImage img2 = this.getImage(this.imgRef2, shapeImage.getWidth(), shapeImage.getHeight());
            Graphics2D img2g = img2.createGraphics();
            img2g.setComposite(AlphaComposite.getInstance(3, 0.93f * GhostPointingPalette.this.fadeAmount * 0.2f));
            img2g.drawImage(shapeImage, simpleBlur, 0, 0);
            img2g.setComposite(AlphaComposite.Clear);
            img2g.translate(-shapeR.x, -shapeR.y);
            img2g.fill(this.createShape(false));
            img2g.dispose();
            g2.drawImage(img2, null, shapeR.x, shapeR.y);
            shapeG.setComposite(AlphaComposite.Clear);
            shapeG.fillRect(0, 0, shapeImage.getWidth(), shapeImage.getHeight());
            shapeG.setComposite(AlphaComposite.Src);
        }

        private Shape createShape(boolean isShadow) {
            Insets i = GhostPointingPalette.this.getBorder().getBorderInsets(GhostPointingPalette.this);
            int width = GhostPointingPalette.this.getWidth() + i.left + i.right;
            int height = GhostPointingPalette.this.getHeight() + i.top + i.bottom;
            int x = GhostPointingPalette.this.getX() - i.left;
            int y = GhostPointingPalette.this.getY() - i.top;
            int x0 = x + GhostPointingPalette.ra$INSET();
            int x1 = x + width - GhostPointingPalette.ra$INSET();
            int y0 = y + GhostPointingPalette.ra$INSET();
            int y1 = y + height - GhostPointingPalette.ra$INSET();
            Point pointingPoint = GhostPointingPalette.mav$getClosestPoint(GhostPointingPalette.this);
            if (pointingPoint == null) {
                return null;
            }
            Point layerPoint = SwingUtilities.convertPoint(GhostPointingPalette.ra$pointingComp(GhostPointingPalette.this), pointingPoint, this);
            Rectangle vRect = GhostPointingPalette.ra$pointingComp(GhostPointingPalette.this).getVisibleRect();
            boolean isPointVisible = vRect.contains(pointingPoint);
            int xOffset = layerPoint.y < y0 && y0 - layerPoint.y < GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this) * 2 || layerPoint.y > y1 && layerPoint.y - y1 < GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this) * 2 ? layerPoint.x : (x0 + width / 2) / 3 + 2 * layerPoint.x / 3;
            int pointLeft = xOffset - GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this) / 2;
            pointLeft = Math.max(x0 + GhostPointingPalette.ra$ROUNDEDNESS(), pointLeft);
            pointLeft = Math.min(pointLeft, x1 - GhostPointingPalette.ra$ROUNDEDNESS() - GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this));
            int pointRight = pointLeft + GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this);
            int yOffset = layerPoint.x < x0 && x0 - layerPoint.x < GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this) * 2 || layerPoint.x > x1 && layerPoint.x - x1 < GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this) * 2 ? layerPoint.y : (y0 + height / 2) / 3 + 2 * layerPoint.y / 3;
            int pointTop = yOffset - GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this) / 2;
            pointTop = Math.max(y0 + GhostPointingPalette.ra$ROUNDEDNESS(), pointTop);
            pointTop = Math.min(pointTop, y1 - GhostPointingPalette.ra$ROUNDEDNESS() - GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this));
            int pointfooter = pointTop + GhostPointingPalette.ra$pointWidth(GhostPointingPalette.this);
            GeneralPath gp = new GeneralPath();
            gp.moveTo(x0 + GhostPointingPalette.ra$ROUNDEDNESS(), y0);
            if (isPointVisible && layerPoint.y < y0 && x0 - layerPoint.x <= y0 - layerPoint.y && layerPoint.x - x1 <= y0 - layerPoint.y) {
                gp.lineTo(pointLeft, y0);
                if (!isShadow) {
                    gp.lineTo(layerPoint.x, layerPoint.y);
                } else {
                    gp.lineTo(layerPoint.x - 6, layerPoint.y - 6);
                }
                gp.lineTo(pointRight, y0);
            }
            gp.lineTo(x1 - GhostPointingPalette.ra$ROUNDEDNESS(), y0);
            gp.quadTo(x1, y0, x1, y0 + GhostPointingPalette.ra$ROUNDEDNESS());
            if (isPointVisible && layerPoint.x > x1 && layerPoint.x - x1 > y0 - layerPoint.y && layerPoint.x - x1 > layerPoint.y - y1) {
                gp.lineTo(x1, pointTop);
                if (!isShadow) {
                    gp.lineTo(layerPoint.x, layerPoint.y);
                } else {
                    gp.lineTo(layerPoint.x - 6, layerPoint.y - 6);
                }
                gp.lineTo(x1, pointfooter);
            }
            gp.lineTo(x1, y1 - GhostPointingPalette.ra$ROUNDEDNESS());
            gp.quadTo(x1, y1, x1 - GhostPointingPalette.ra$ROUNDEDNESS(), y1);
            if (isPointVisible && layerPoint.y > y1 && x0 - layerPoint.x <= layerPoint.y - y1 && layerPoint.x - x1 <= layerPoint.y - y1) {
                gp.lineTo(pointRight, y1);
                if (!isShadow) {
                    gp.lineTo(layerPoint.x, layerPoint.y);
                } else {
                    gp.lineTo(layerPoint.x - 6, layerPoint.y - 6);
                }
                gp.lineTo(pointLeft, y1);
            }
            gp.lineTo(x0 + GhostPointingPalette.ra$ROUNDEDNESS(), y1);
            gp.quadTo(x0, y1, x0, y1 - GhostPointingPalette.ra$ROUNDEDNESS());
            if (isPointVisible && layerPoint.x < x0 && x0 - layerPoint.x > y0 - layerPoint.y && x0 - layerPoint.x > layerPoint.y - y1) {
                gp.lineTo(x0, pointfooter);
                if (!isShadow) {
                    gp.lineTo(layerPoint.x, layerPoint.y);
                } else {
                    gp.lineTo(layerPoint.x - 6, layerPoint.y - 6);
                }
                gp.lineTo(x0, pointTop);
            }
            gp.lineTo(x0, y0 + GhostPointingPalette.ra$ROUNDEDNESS());
            gp.quadTo(x0, y0, x0 + GhostPointingPalette.ra$ROUNDEDNESS(), y0);
            return gp;
        }

        private PointingLayer() {
        }

        static Shape mav$createShape(PointingLayer pointingLayer, boolean bl) {
            return pointingLayer.createShape(bl);
        }

        PointingLayer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PointingCompListener
    extends ComponentAdapter
    implements AncestorListener {
        public void componentMoved(ComponentEvent e) {
            if (!GhostPointingPalette.this.isMovable()) {
                GhostPointingPalette.this.fadeInOut(false);
            }
            GhostPointingPalette.this.repaintVisible();
        }

        public void componentHidden(ComponentEvent e) {
            GhostPointingPalette.this.dispose();
        }

        public void ancestorAdded(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
            GhostPointingPalette.this.dispose();
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        private PointingCompListener() {
        }

        PointingCompListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SizeListener
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ce) {
            if (GhostPointingPalette.ra$pointingLayer(GhostPointingPalette.this) != null) {
                GhostPointingPalette.ra$pointingLayer(GhostPointingPalette.this).setSize(GhostPointingPalette.ra$pointingLayer(GhostPointingPalette.this).getParent().getSize());
            }
        }

        private SizeListener() {
        }

        SizeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

