/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import oracle.javatools.ui.plaf.IconicButtonUI;

public final class FlatToolBarUI
extends ToolBarUI {
    private final ToolBarUI _delegate;
    private final Map<AbstractButton, Map<String, Object>> _oldButtonProperties;
    private ContainerListener _containerListener;
    private final PropertyChangeListener _buttonPropertyChangeListener;

    private void $init$() {
        this._delegate = (ToolBarUI)UIManager.getUI(new JToolBar());
        this._oldButtonProperties = new HashMap<AbstractButton, Map<String, Object>>();
        this._buttonPropertyChangeListener = new ButtonChangeListener(null);
    }

    public boolean contains(JComponent c, int x, int y) {
        return this._delegate.contains(c, x, y);
    }

    public Accessible getAccessibleChild(JComponent c, int i) {
        return this._delegate.getAccessibleChild(c, i);
    }

    public int getAccessibleChildrenCount(JComponent c) {
        return this._delegate.getAccessibleChildrenCount(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this._delegate.getMaximumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this._delegate.getMinimumSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        return this._delegate.getPreferredSize(c);
    }

    public void installUI(JComponent c) {
        this._delegate.installUI(c);
        JToolBar toolBar = (JToolBar)c;
        this.installDefaults(toolBar);
        this.installListeners(toolBar);
    }

    public void paint(Graphics g, JComponent c) {
        this._delegate.paint(g, c);
    }

    public void uninstallUI(JComponent c) {
        this._delegate.uninstallUI(c);
        JToolBar toolBar = (JToolBar)c;
        this.uninstallListeners(toolBar);
    }

    public void update(Graphics g, JComponent c) {
        this._delegate.update(g, c);
    }

    private void installDefaults(JToolBar toolBar) {
        if (toolBar.getBorder() == null || toolBar.getBorder() instanceof UIResource) {
            toolBar.setBorder(BorderFactory.createEmptyBorder());
        }
        toolBar.setOpaque(false);
        toolBar.setRollover(false);
    }

    private void installListeners(JToolBar toolBar) {
        this._containerListener = new ToolBarContainerListener(null);
        toolBar.addContainerListener(this._containerListener);
    }

    private void uninstallListeners(JToolBar toolBar) {
        toolBar.removeContainerListener(this._containerListener);
        this._containerListener = null;
    }

    private void customizeButton(AbstractButton button) {
        HashMap<String, Object> buttonProperties = new HashMap<String, Object>();
        buttonProperties.put("border", button.getBorder());
        buttonProperties.put("borderPainted", button.isBorderPainted());
        buttonProperties.put("contentAreaFilled", button.isContentAreaFilled());
        buttonProperties.put("opaque", button.isOpaque());
        buttonProperties.put("cursor", button.getCursor());
        this._oldButtonProperties.put(button, buttonProperties);
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        IconicButtonUI.updateCursor(button);
        button.addPropertyChangeListener("enabled", this._buttonPropertyChangeListener);
    }

    private void decustomizeButton(AbstractButton button) {
        button.removePropertyChangeListener("enabled", this._buttonPropertyChangeListener);
    }

    public FlatToolBarUI() {
        this.$init$();
    }

    static void mav$decustomizeButton(FlatToolBarUI flatToolBarUI, AbstractButton abstractButton) {
        flatToolBarUI.decustomizeButton(abstractButton);
    }

    static void mav$customizeButton(FlatToolBarUI flatToolBarUI, AbstractButton abstractButton) {
        flatToolBarUI.customizeButton(abstractButton);
    }

    private class ToolBarContainerListener
    implements ContainerListener {
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof AbstractButton) {
                FlatToolBarUI.mav$customizeButton(FlatToolBarUI.this, (AbstractButton)e.getChild());
            }
        }

        public void componentRemoved(ContainerEvent e) {
            if (e.getChild() instanceof AbstractButton) {
                FlatToolBarUI.mav$decustomizeButton(FlatToolBarUI.this, (AbstractButton)e.getChild());
            }
        }

        private ToolBarContainerListener() {
        }

        ToolBarContainerListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class ButtonChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            IconicButtonUI.updateCursor((AbstractButton)evt.getSource());
        }

        private ButtonChangeListener() {
        }

        ButtonChangeListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

