/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.search.SearchProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFieldHarness
extends TransparentPanel {
    private final JList _list;
    private SearchField _searchField;
    private final JPanel _options;
    private final JLabel _style;
    private final JRadioButton _filter;
    private final JRadioButton _search;
    private final JRadioButton _find;
    private final JCheckBox _categories;
    private final JCheckBox _extraItems;
    private final JCheckBox _buttonsInField;
    private final JLabel _searchSpeedLabel;
    private final JSlider _searchSpeed;
    private final JLabel _slow;
    private final JLabel _fast;
    private final JCheckBox _determinateProgress;
    private final JCheckBox _slowStopResponse;
    private static final SearchCategory ALL_CATEGORY = new SearchCategory("All");
    private static final SearchCategory CLASS_NAME_CATEGORY = new SearchCategory("Class Name");
    private static final SearchCategory PACKAGE_NAME_CATEGORY = new SearchCategory("Package Name");
    private final int MAX_TIME_TO_SEARCH;
    private boolean _searching;
    private Set<Class> _highlightedClasses;

    private void $init$() {
        this._list = new JList();
        this._options = new TransparentPanel();
        this._style = new JLabel("Style:");
        this._filter = new JRadioButton("Filter");
        this._search = new JRadioButton("Search");
        this._find = new JRadioButton("Find");
        this._categories = new JCheckBox("Add search categories");
        this._extraItems = new JCheckBox("Add extra menu items");
        this._buttonsInField = new JCheckBox("All buttons inside field border");
        this._searchSpeedLabel = new JLabel("Simulated search speed:");
        this._searchSpeed = new JSlider(0, 100);
        this._slow = new JLabel("Slow");
        this._fast = new JLabel("Fast");
        this._determinateProgress = new JCheckBox("Use determinate search progress");
        this._slowStopResponse = new JCheckBox("Respond to stop search slowly");
        this.MAX_TIME_TO_SEARCH = 15000;
        this._searching = false;
        this._highlightedClasses = null;
    }

    SearchFieldHarness() {
        this.$init$();
        this._buttonsInField.setSelected(true);
        HeaderPanel<JPanel> optionsHeader = new HeaderPanel<JPanel>(this._options);
        optionsHeader.getHeader().setLevel(Header.Level.SUB);
        optionsHeader.getHeader().setText("Options");
        optionsHeader.getHeader().setExpanded(true);
        optionsHeader.setComponentIndented(true);
        this._searchSpeed.setPaintLabels(true);
        Hashtable<Integer, JLabel> m = new Hashtable<Integer, JLabel>();
        ((Dictionary)m).put(100, this._slow);
        ((Dictionary)m).put(0, this._fast);
        this._searchSpeed.setLabelTable(m);
        this._list.setCellRenderer(new ClassListRenderer(null));
        this._list.setSelectionMode(0);
        this.createSearchField(this._buttonsInField.isSelected());
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this._searchField, "North");
        this.add((Component)new JScrollPane(this._list), "Center");
        this.add(optionsHeader, "South");
        this._options.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 5, 5);
        this._options.add((Component)this._style, gbc);
        ++gbc.gridx;
        this._options.add((Component)this._filter, gbc);
        ++gbc.gridx;
        this._options.add((Component)this._search, gbc);
        ++gbc.gridx;
        this._options.add((Component)this._find, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 4;
        this._options.add((Component)this._categories, gbc);
        ++gbc.gridy;
        this._options.add((Component)this._extraItems, gbc);
        ++gbc.gridy;
        this._options.add((Component)this._buttonsInField, gbc);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(5, 0));
        p.add((Component)this._searchSpeedLabel, "West");
        p.add((Component)this._searchSpeed, "Center");
        ++gbc.gridy;
        this._options.add((Component)p, gbc);
        ++gbc.gridy;
        this._options.add((Component)this._determinateProgress, gbc);
        ++gbc.gridy;
        this._options.add((Component)this._slowStopResponse, gbc);
        this.updateSearchOptions();
        this._buttonsInField.addActionListener(new 1());
        this._extraItems.addActionListener(new 2());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._filter);
        bg.add(this._search);
        bg.add(this._find);
        this._filter.setSelected(true);
        this._list.setModel(this.buildModel(null, null));
        3 al = new 3();
        this._filter.addActionListener(al);
        this._search.addActionListener(al);
        this._find.addActionListener(al);
        this._categories.addActionListener(new 4());
    }

    private void updateSearchOptions() {
        boolean isSearchStyle = !this._searching && this._searchField.getStyle() == SearchField.Style.SEARCH;
        this._slow.setEnabled(isSearchStyle);
        this._fast.setEnabled(isSearchStyle);
        this._searchSpeed.setEnabled(isSearchStyle);
        this._searchSpeedLabel.setEnabled(isSearchStyle);
        this._determinateProgress.setEnabled(isSearchStyle);
        this._slowStopResponse.setEnabled(isSearchStyle);
        this._filter.setEnabled(this._searching ^ true);
        this._find.setEnabled(this._searching ^ true);
        this._search.setEnabled(this._searching ^ true);
        this._categories.setEnabled(this._searching ^ true);
        this._buttonsInField.setEnabled(this._searching ^ true);
        this._extraItems.setEnabled(this._searching ^ true);
    }

    private void updateCategories() {
        this._searchField.clearCategories();
        if (this._categories.isSelected()) {
            this._searchField.addCategory(ALL_CATEGORY);
            this._searchField.addCategory(CLASS_NAME_CATEGORY);
            this._searchField.addCategory(PACKAGE_NAME_CATEGORY);
        }
    }

    private void createSearchField(boolean buttonsInField) {
        SearchField old = null;
        if (this._searchField != null) {
            old = this._searchField;
            this.remove(this._searchField);
        }
        this._searchField = new SearchField();
        this._searchField.clear();
        if (old != null) {
            this._searchField.setStyle(old.getStyle());
            this.updateCategories();
        }
        this._searchField.addSearchListener(new 5());
        this.add((Component)this._searchField, "North");
        this.validate();
        this.repaint();
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel("oracle.bali.ewt.olaf2.OracleLookAndFeel");
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        SearchFieldHarness harness = new SearchFieldHarness();
        f.setContentPane(harness);
        f.setTitle("Search Control Test Harness");
        f.pack();
        f.setVisible(true);
        harness._list.requestFocus();
    }

    private ListModel buildModel(SearchCategory category, String search) {
        List<Class> classes = this.getAllClasses();
        SearchMatcher helper = SearchMatcher.getSubstringMatcher(search, true);
        if (search != null && search.trim().length() > 0) {
            Iterator<Class> i = classes.iterator();
            while (i.hasNext()) {
                Class clz = i.next();
                if (SearchFieldHarness.matchesClass(clz, category, helper)) continue;
                i.remove();
            }
        }
        return new 6(this, classes);
    }

    private List<Class> getAllClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            classes.addAll((Vector)f.get(Thread.currentThread().getContextClassLoader()));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        return classes;
    }

    private static boolean matchesClass(Class clz, SearchCategory category, SearchMatcher search) {
        String className = clz.getSimpleName();
        String packageName = clz.getPackage() == null ? null : clz.getPackage().getName();
        String fqName = clz.getName();
        String textToSearch = "";
        if (category == null || category == ALL_CATEGORY) {
            textToSearch = fqName;
        } else if (category == CLASS_NAME_CATEGORY) {
            textToSearch = className;
        } else if (category == PACKAGE_NAME_CATEGORY) {
            textToSearch = packageName;
        }
        return search.matches(textToSearch);
    }

    static Set ra$_highlightedClasses(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._highlightedClasses;
    }

    static List mav$getAllClasses(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness.getAllClasses();
    }

    static JSlider ra$_searchSpeed(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._searchSpeed;
    }

    static JCheckBox ra$_determinateProgress(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._determinateProgress;
    }

    static JCheckBox ra$_slowStopResponse(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._slowStopResponse;
    }

    static boolean maS$matchesClass(Class clazz, SearchCategory searchCategory, SearchMatcher searchMatcher) {
        return SearchFieldHarness.matchesClass(clazz, searchCategory, searchMatcher);
    }

    static SearchField ra$_searchField(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._searchField;
    }

    static void wa$_highlightedClasses(SearchFieldHarness searchFieldHarness, Set set) {
        searchFieldHarness._highlightedClasses = set;
    }

    static JList ra$_list(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._list;
    }

    static void wa$_searching(SearchFieldHarness searchFieldHarness, boolean bl) {
        searchFieldHarness._searching = bl;
    }

    static void mav$updateSearchOptions(SearchFieldHarness searchFieldHarness) {
        searchFieldHarness.updateSearchOptions();
    }

    static ListModel mav$buildModel(SearchFieldHarness searchFieldHarness, SearchCategory searchCategory, String string) {
        return searchFieldHarness.buildModel(searchCategory, string);
    }

    static JCheckBox ra$_buttonsInField(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._buttonsInField;
    }

    static void mav$createSearchField(SearchFieldHarness searchFieldHarness, boolean bl) {
        searchFieldHarness.createSearchField(bl);
    }

    static JCheckBox ra$_extraItems(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._extraItems;
    }

    static JRadioButton ra$_filter(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._filter;
    }

    static JRadioButton ra$_search(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._search;
    }

    static JRadioButton ra$_find(SearchFieldHarness searchFieldHarness) {
        return searchFieldHarness._find;
    }

    static void mav$updateCategories(SearchFieldHarness searchFieldHarness) {
        searchFieldHarness.updateCategories();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SearchFieldHarness.mav$createSearchField(SearchFieldHarness.this, SearchFieldHarness.ra$_buttonsInField(SearchFieldHarness.this).isSelected());
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (!SearchFieldHarness.ra$_extraItems(SearchFieldHarness.this).isSelected()) {
                SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).clearCategoryMenuItems();
            } else {
                SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).addCategoryMenuItem(new JMenuItem("Advanced Search..."));
            }
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SearchField.Style newStyle = SearchField.Style.SEARCH;
            if (e.getSource() == SearchFieldHarness.ra$_filter(SearchFieldHarness.this)) {
                newStyle = SearchField.Style.FILTER;
            } else if (e.getSource() == SearchFieldHarness.ra$_search(SearchFieldHarness.this)) {
                newStyle = SearchField.Style.SEARCH;
            } else if (e.getSource() == SearchFieldHarness.ra$_find(SearchFieldHarness.this)) {
                newStyle = SearchField.Style.FIND;
            } else {
                throw new IllegalStateException("Illegal source for SearchEvent: " + e.getSource());
            }
            SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).clear();
            SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).setStyle(newStyle);
            SearchFieldHarness.wa$_highlightedClasses(SearchFieldHarness.this, null);
            SearchFieldHarness.this.repaint();
            switch (2.$sm$oracle$javatools$ui$search$SearchField$Style[newStyle.ordinal()]) {
                case 1: 
                case 2: {
                    SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).setAutoFind(true);
                    SearchFieldHarness.ra$_list(SearchFieldHarness.this).setModel(SearchFieldHarness.mav$buildModel(SearchFieldHarness.this, null, null));
                    break;
                }
                case 3: {
                    SearchFieldHarness.ra$_list(SearchFieldHarness.this).setModel(new 1());
                    break;
                }
            }
            SearchFieldHarness.mav$updateSearchOptions(SearchFieldHarness.this);
        }

        final class 1
        extends AbstractListModel {
            public int getSize() {
                return 0;
            }

            public Object getElementAt(int index) {
                return null;
            }
        }

        static class 2 {
            static final /* synthetic */ int[] $sm$oracle$javatools$ui$search$SearchField$Style;

            static {
                int[] nArray = new int[SearchField.Style.values().length];
                $sm$oracle$javatools$ui$search$SearchField$Style = nArray;
                try {
                    nArray[SearchField.Style.FILTER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    2.$sm$oracle$javatools$ui$search$SearchField$Style[SearchField.Style.FIND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    2.$sm$oracle$javatools$ui$search$SearchField$Style[SearchField.Style.SEARCH.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
            }
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SearchFieldHarness.mav$updateCategories(SearchFieldHarness.this);
        }
    }

    final class 5
    implements SearchListener {
        private void filter(SearchCategory category, String search) {
            SearchFieldHarness.ra$_list(SearchFieldHarness.this).setModel(SearchFieldHarness.mav$buildModel(SearchFieldHarness.this, category, search));
        }

        public void searchPerformed(SearchEvent se) {
            if (SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).getStyle() == SearchField.Style.FILTER) {
                this.filter(se.getSearchCategory(), se.getSearchText());
            } else if (SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).getStyle() == SearchField.Style.SEARCH) {
                MutableModel m = new MutableModel(null);
                SearchFieldHarness.ra$_list(SearchFieldHarness.this).setModel(m);
                SearchFieldHarness.wa$_searching(SearchFieldHarness.this, true);
                SearchFieldHarness.mav$updateSearchOptions(SearchFieldHarness.this);
                SearchRunnable r = new SearchRunnable(se.getSearchProgress(), se.getSearchCategory(), se.getSearchText(), m);
                Thread t = new Thread((Runnable)r, "Search runnable");
                t.start();
            } else if (SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).getStyle() == SearchField.Style.FIND) {
                this.find(se, se.getDirection() == SearchEvent.Direction.FORWARD);
            }
        }

        private void find(SearchEvent se, boolean direction) {
            Class clz;
            if (se.getSearchText().trim().length() == 0) {
                SearchFieldHarness.wa$_highlightedClasses(SearchFieldHarness.this, null);
                SearchFieldHarness.ra$_list(SearchFieldHarness.this).repaint();
                return;
            }
            SearchMatcher helper = SearchMatcher.getSubstringMatcher(se.getSearchText(), true);
            int curIdx = SearchFieldHarness.ra$_list(SearchFieldHarness.this).getSelectedIndex();
            SearchFieldHarness.wa$_highlightedClasses(SearchFieldHarness.this, new HashSet());
            int i = 0;
            while (i < SearchFieldHarness.ra$_list(SearchFieldHarness.this).getModel().getSize()) {
                Class z = (Class)SearchFieldHarness.ra$_list(SearchFieldHarness.this).getModel().getElementAt(i);
                if (SearchFieldHarness.maS$matchesClass(z, se.getSearchCategory(), helper)) {
                    SearchFieldHarness.ra$_highlightedClasses(SearchFieldHarness.this).add(z);
                }
                ++i;
            }
            SearchFieldHarness.ra$_list(SearchFieldHarness.this).repaint();
            if (SearchFieldHarness.ra$_highlightedClasses(SearchFieldHarness.this).size() == 0) {
                SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).showSearchFailed();
            }
            if (curIdx >= 0 && se.isTriggeredByKeypress() && SearchFieldHarness.maS$matchesClass(clz = (Class)SearchFieldHarness.ra$_list(SearchFieldHarness.this).getModel().getElementAt(curIdx), se.getSearchCategory(), helper)) {
                return;
            }
            int start = direction ? curIdx + 1 : curIdx - 1;
            int end = direction ? SearchFieldHarness.ra$_list(SearchFieldHarness.this).getModel().getSize() : -1;
            int modify = direction ? 1 : -1;
            int i2 = start;
            while (!(direction ? i2 >= end : i2 <= end)) {
                Class clz2 = (Class)SearchFieldHarness.ra$_list(SearchFieldHarness.this).getModel().getElementAt(i2);
                if (SearchFieldHarness.maS$matchesClass(clz2, se.getSearchCategory(), helper)) {
                    SearchFieldHarness.ra$_list(SearchFieldHarness.this).setSelectedIndex(i2);
                    return;
                }
                i2 += modify;
            }
            start = direction ? 0 : SearchFieldHarness.ra$_list(SearchFieldHarness.this).getModel().getSize() - 1;
            end = curIdx;
            int i3 = start;
            while (!(direction ? i3 >= end : i3 <= end)) {
                Class clz3 = (Class)SearchFieldHarness.ra$_list(SearchFieldHarness.this).getModel().getElementAt(i3);
                if (SearchFieldHarness.maS$matchesClass(clz3, se.getSearchCategory(), helper)) {
                    SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).showSearchWrapped();
                    SearchFieldHarness.ra$_list(SearchFieldHarness.this).setSelectedIndex(i3);
                    return;
                }
                i3 += modify;
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
            if (SearchFieldHarness.ra$_searchField(SearchFieldHarness.this).getStyle() == SearchField.Style.FILTER) {
                this.filter(se.getSearchCategory(), se.getSearchText());
            }
        }
    }

    final class 6
    extends AbstractListModel {
        private final /* synthetic */ List v$classes;
        final /* synthetic */ SearchFieldHarness this$0;

        public int getSize() {
            return this.v$classes.size();
        }

        public Object getElementAt(int index) {
            return (Class)this.v$classes.get(index);
        }

        public 6(SearchFieldHarness searchFieldHarness, List list) {
            this.v$classes = list;
            this.this$0 = searchFieldHarness;
        }
    }

    private class ClassListRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Class z = (Class)value;
            String label = "";
            int lastPeriod = z.getName().lastIndexOf(46);
            label = lastPeriod <= 0 ? z.getName() : z.getName().substring(lastPeriod + 1) + " (" + z.getName().substring(0, lastPeriod) + ")";
            this.setText(label);
            this.setIcon(OracleIcons.getIcon((String)"class.png"));
            if (!isSelected && SearchFieldHarness.ra$_highlightedClasses(SearchFieldHarness.this) != null && SearchFieldHarness.ra$_highlightedClasses(SearchFieldHarness.this).contains(z)) {
                this.setBackground(new Color(255, 255, 0));
            }
            return c;
        }

        private ClassListRenderer() {
        }

        ClassListRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SearchRunnable
    implements Runnable {
        private final SearchProgress _progress;
        private final SearchCategory _category;
        private final String _search;
        private final MutableModel _model;

        SearchRunnable(SearchProgress progress, SearchCategory category, String search, MutableModel model) {
            this._progress = progress;
            this._category = category;
            this._search = search;
            this._model = model;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void addClass(Class clz) {
            EventQueue.invokeLater(new 2(this, clz));
        }

        static MutableModel ra$_model(SearchRunnable searchRunnable) {
            return searchRunnable._model;
        }

        final class 1
        implements Runnable {
            public void run() {
                SearchFieldHarness.wa$_searching(SearchFieldHarness.this, false);
                SearchFieldHarness.mav$updateSearchOptions(SearchFieldHarness.this);
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ Class v$clz;
            final /* synthetic */ SearchRunnable this$0;

            public void run() {
                SearchRunnable.ra$_model(this.this$0).add(Collections.singleton(this.v$clz));
            }

            public 2(SearchRunnable searchRunnable, Class clazz) {
                this.v$clz = clazz;
                this.this$0 = searchRunnable;
            }
        }
    }

    private static class MutableModel
    extends AbstractListModel {
        private final List _items;

        private void $init$() {
            this._items = new ArrayList();
        }

        public int getSize() {
            return this._items.size();
        }

        public Object getElementAt(int index) {
            return this._items.get(index);
        }

        public void add(Collection items) {
            int oldCount = this._items.size();
            this._items.addAll(items);
            this.fireIntervalAdded(this, oldCount, this._items.size() - 1);
        }

        private MutableModel() {
            this.$init$();
        }

        MutableModel(5 var1_1) {
            this();
        }
    }
}

