/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import javax.swing.Icon;

public final class StretchIcon {
    private Insets _sizingMargin;
    private Image[] _images;
    private int _width;
    private int _height;
    private int _marginWidth;
    private int _marginHeight;

    public StretchIcon(BufferedImage image, Insets sizingMargin) throws IOException {
        this.ctorCheck(image, sizingMargin);
        this.initialize(image, sizingMargin);
    }

    public StretchIcon(Icon baseIcon, Insets sizingMargin) {
        this.ctorCheck(baseIcon, sizingMargin);
        BufferedImage image = StretchIcon.createCompatibleImage(baseIcon.getIconWidth(), baseIcon.getIconHeight());
        baseIcon.paintIcon(null, image.createGraphics(), 0, 0);
        this.initialize(image, sizingMargin);
    }

    private void ctorCheck(Object baseIcon, Insets sizingMargin) {
        if (baseIcon == null) {
            throw new NullPointerException("baseIcon is null");
        }
        if (sizingMargin == null) {
            throw new NullPointerException("sizingMargin is null");
        }
    }

    private void initialize(BufferedImage image, Insets sizingMargin) {
        this._sizingMargin = sizingMargin;
        this._width = image.getWidth();
        this._height = image.getHeight();
        this._marginWidth = sizingMargin.left + sizingMargin.right;
        this._marginHeight = sizingMargin.top + sizingMargin.bottom;
        this._images = this.splitImage(image);
    }

    private Image[] splitImage(BufferedImage i) {
        Image[] result = new Image[9];
        if (this._sizingMargin != null) {
            int top = this._sizingMargin.top;
            int left = this._sizingMargin.left;
            int bottom = this._sizingMargin.bottom;
            int right = this._sizingMargin.right;
            result[0] = StretchIcon.cropImage(i, 0, 0, left, top);
            result[1] = StretchIcon.cropImage(i, left, 0, this._width - left - right, top);
            result[2] = StretchIcon.cropImage(i, this._width - right, 0, right, top);
            result[3] = StretchIcon.cropImage(i, this._width - right, top, right, this._height - top - bottom);
            result[4] = StretchIcon.cropImage(i, this._width - right, this._height - bottom, right, bottom);
            result[5] = StretchIcon.cropImage(i, left, this._height - bottom, this._width - left - right, bottom);
            result[6] = StretchIcon.cropImage(i, 0, this._height - bottom, left, bottom);
            result[7] = StretchIcon.cropImage(i, 0, top, left, this._height - top - bottom);
        } else {
            this._sizingMargin = new Insets(0, 0, 0, 0);
        }
        int top = this._sizingMargin.top;
        int left = this._sizingMargin.left;
        int bottom = this._sizingMargin.bottom;
        int right = this._sizingMargin.right;
        result[8] = StretchIcon.cropImage(i, left, top, this._width - left - right, this._height - top - bottom);
        return result;
    }

    private static Image cropImage(BufferedImage image, int x, int y, int width, int height) {
        if (x < 0 || y < 0) {
            return null;
        }
        if (x > image.getWidth()) {
            return null;
        }
        if (x + width > image.getWidth()) {
            return null;
        }
        if (y > image.getHeight()) {
            return null;
        }
        if (y + height > image.getHeight()) {
            return null;
        }
        if (width * height <= 0) {
            return null;
        }
        return image.getSubimage(x, y, width, height);
    }

    public int getIconWidth() {
        return this._width;
    }

    public int getIconHeight() {
        return this._height;
    }

    private static BufferedImage createCompatibleImage(int w, int h) {
        w = Math.max(w, 1);
        h = Math.max(h, 1);
        if (GraphicsEnvironment.isHeadless()) {
            return new BufferedImage(w, h, 2);
        }
        GraphicsConfiguration configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return configuration.createCompatibleImage(w, h, 3);
    }

    public void paintIcon(ImageObserver observer, Graphics g, Rectangle bounds) {
        this.paintIcon(observer, g, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void paintIcon(ImageObserver observer, Graphics g, int x, int y, int w, int h) {
        Insets sm = this._sizingMargin;
        g.translate(x, y);
        int midwidth = w - this._marginWidth;
        int rightedge = w - sm.right;
        int midheight = h - this._marginHeight;
        int bottomedge = h - sm.bottom;
        if (this._images[0] != null) {
            g.drawImage(this._images[0], 0, 0, observer);
        }
        if (this._images[1] != null) {
            g.drawImage(this._images[1], sm.left, 0, midwidth, sm.top, observer);
        }
        if (this._images[2] != null) {
            g.drawImage(this._images[2], rightedge, 0, observer);
        }
        if (this._images[3] != null) {
            g.drawImage(this._images[3], rightedge, sm.top, sm.right, midheight, observer);
        }
        if (this._images[4] != null) {
            g.drawImage(this._images[4], rightedge, bottomedge, observer);
        }
        if (this._images[5] != null) {
            g.drawImage(this._images[5], sm.left, bottomedge, midwidth, sm.bottom, observer);
        }
        if (this._images[6] != null) {
            g.drawImage(this._images[6], 0, bottomedge, observer);
        }
        if (this._images[7] != null) {
            g.drawImage(this._images[7], 0, sm.top, sm.left, midheight, observer);
        }
        if (this._images[8] != null) {
            g.drawImage(this._images[8], sm.left, sm.top, midwidth, midheight, observer);
        }
        g.translate(-x, -y);
    }
}

